/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.datatype.impl.coverter;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jbpm.process.core.datatype.impl.coverter.DateTypeConverter;
import org.jbpm.process.core.datatype.impl.coverter.NoOpTypeConverter;

public class TypeConverterRegistry {
    private static TypeConverterRegistry INSTANCE = new TypeConverterRegistry();
    private Map<String, Function<String, ? extends Object>> converters = new HashMap<String, Function<String, ? extends Object>>();
    private Function<String, String> defaultConverter = new NoOpTypeConverter();

    private TypeConverterRegistry() {
        this.converters.put("java.util.Date", new DateTypeConverter());
    }

    public Function<String, ? extends Object> forType(String type) {
        return this.converters.getOrDefault(type, this.defaultConverter);
    }

    public void register(String type, Function<String, ? extends Object> converter) {
        this.converters.putIfAbsent(type, converter);
    }

    public static TypeConverterRegistry get() {
        return INSTANCE;
    }
}

