/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Optional;
import java.util.function.Function;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.event.impl.EventUtils;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.impl.Sig;
import org.kie.kogito.services.event.AbstractProcessDataEvent;
import org.kie.kogito.services.event.EventConsumer;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudEventConsumer<D, M extends Model, T extends AbstractProcessDataEvent<D>>
implements EventConsumer<M> {
    private static final Logger logger = LoggerFactory.getLogger(CloudEventConsumer.class);
    private Function<D, M> function;
    private Class<T> cloudEventClass;

    public CloudEventConsumer(Function<D, M> function, Class<T> cloudEventClass) {
        this.function = function;
        this.cloudEventClass = cloudEventClass;
    }

    public void consume(Application application, Process<M> process, String payload, String trigger) {
        try {
            AbstractProcessDataEvent cloudEvent = (AbstractProcessDataEvent)EventUtils.readEvent(payload, this.cloudEventClass);
            Model model = (Model)this.function.apply(cloudEvent.getData());
            UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)application.unitOfWorkManager(), () -> {
                if (cloudEvent.getKogitoReferenceId() != null) {
                    logger.debug("Received message with reference id '{}' going to use it to send signal '{}'", (Object)cloudEvent.getKogitoReferenceId(), (Object)trigger);
                    Optional instance = process.instances().findById(cloudEvent.getKogitoReferenceId());
                    if (instance.isPresent()) {
                        ((ProcessInstance)instance.get()).send(Sig.of("Message-" + trigger, cloudEvent.getData(), cloudEvent.getKogitoProcessinstanceId()));
                    } else {
                        logger.warn("Process instance with id '{}' not found for triggering signal '{}'", (Object)cloudEvent.getKogitoReferenceId(), (Object)trigger);
                    }
                } else {
                    logger.debug("Received message without reference id, staring new process instance with trigger '{}'", (Object)trigger);
                    ProcessInstance pi = process.createInstance((Object)model);
                    if (cloudEvent.getKogitoStartFromNode() != null) {
                        pi.startFrom(cloudEvent.getKogitoStartFromNode(), cloudEvent.getKogitoProcessinstanceId());
                    } else {
                        pi.start(trigger, cloudEvent.getKogitoProcessinstanceId());
                    }
                }
                return null;
            });
        }
        catch (JsonProcessingException e) {
            logger.error("Error when consuming message for process {}", (Object)process.id(), (Object)e);
        }
    }
}

