/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Optional;
import java.util.function.Function;
import org.kie.kogito.event.impl.EventUtils;
import org.kie.kogito.services.event.AbstractProcessDataEvent;
import org.kie.kogito.services.event.EventMarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEventMarshaller
implements EventMarshaller {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEventMarshaller.class);

    public <T, P extends AbstractProcessDataEvent<T>> String marshall(T dataEvent, Function<T, P> cloudFunction, Optional<Boolean> isCloudEvent) {
        T event = isCloudEvent.orElse(true) != false ? cloudFunction.apply(dataEvent) : dataEvent;
        logger.debug("Marshalling event {}", event);
        try {
            return EventUtils.writeEvent(event);
        }
        catch (JsonProcessingException e) {
            logger.error("Error marshalling event {}", event);
            throw new IllegalStateException(e);
        }
    }
}

