/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.impl.marshalling;

import com.google.protobuf.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import org.drools.core.impl.EnvironmentImpl;
import org.drools.core.marshalling.impl.ClassObjectMarshallingStrategyAcceptor;
import org.drools.core.marshalling.impl.KogitoMarshallerReaderContext;
import org.drools.core.marshalling.impl.KogitoProcessMarshallerWriteContext;
import org.drools.core.marshalling.impl.KogitoSerializablePlaceholderResolverStrategy;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.marshalling.impl.PersisterHelper;
import org.drools.core.marshalling.impl.SerializablePlaceholderResolverStrategy;
import org.jbpm.marshalling.impl.JBPMMessages;
import org.jbpm.marshalling.impl.ProcessMarshallerRegistry;
import org.jbpm.marshalling.impl.ProtobufRuleFlowProcessInstanceMarshaller;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyAcceptor;
import org.kie.api.runtime.Environment;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.impl.AbstractProcess;
import org.kie.kogito.process.impl.AbstractProcessInstance;

public class ProcessInstanceMarshaller {
    private Environment env = new EnvironmentImpl();

    public ProcessInstanceMarshaller(ObjectMarshallingStrategy ... strategies) {
        ObjectMarshallingStrategy[] strats = null;
        if (strategies == null) {
            strats = new ObjectMarshallingStrategy[]{new SerializablePlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)};
        } else {
            strats = new ObjectMarshallingStrategy[strategies.length + 1];
            int i = 0;
            ObjectMarshallingStrategy[] objectMarshallingStrategyArray = strategies;
            int n = objectMarshallingStrategyArray.length;
            for (int j = 0; j < n; ++j) {
                ObjectMarshallingStrategy strategy;
                strats[i] = strategy = objectMarshallingStrategyArray[j];
                ++i;
            }
            strats[i] = new KogitoSerializablePlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT);
        }
        this.env.set("org.kie.api.marshalling.ObjectMarshallingStrategies", (Object)strats);
    }

    public byte[] marshallProcessInstance(ProcessInstance<?> processInstance) {
        byte[] byArray;
        WorkflowProcessInstance pi = ((AbstractProcessInstance)processInstance).internalGetProcessInstance();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            KogitoProcessMarshallerWriteContext context = new KogitoProcessMarshallerWriteContext((OutputStream)baos, null, null, null, null, this.env);
            context.setProcessInstanceId(pi.getId());
            context.setState(pi.getState());
            String processType = pi.getProcess().getType();
            context.stream.writeUTF(processType);
            org.jbpm.marshalling.impl.ProcessInstanceMarshaller marshaller = ProcessMarshallerRegistry.INSTANCE.getMarshaller(processType);
            Object result = marshaller.writeProcessInstance((MarshallerWriteContext)context, pi);
            if (marshaller instanceof ProtobufRuleFlowProcessInstanceMarshaller && result != null) {
                JBPMMessages.ProcessInstance _instance = (JBPMMessages.ProcessInstance)result;
                PersisterHelper.writeToStreamWithHeader((MarshallerWriteContext)context, (Message)_instance);
            }
            context.close();
            pi.disconnect();
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Error while marshalling process instance", e);
            }
        }
        baos.close();
        return byArray;
    }

    public WorkflowProcessInstance unmarshallWorkflowProcessInstance(byte[] data, Process<?> process) {
        WorkflowProcessInstance workflowProcessInstance;
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        try {
            KogitoMarshallerReaderContext context = new KogitoMarshallerReaderContext((InputStream)bais, Collections.singletonMap(process.id(), ((AbstractProcess)process).process()), null, null, null, this.env);
            MarshallerReaderContext stream = context.stream;
            String processInstanceType = stream.readUTF();
            org.jbpm.marshalling.impl.ProcessInstanceMarshaller marshaller = ProcessMarshallerRegistry.INSTANCE.getMarshaller(processInstanceType);
            WorkflowProcessInstance pi = (WorkflowProcessInstance)marshaller.readProcessInstance((MarshallerReaderContext)context);
            context.close();
            workflowProcessInstance = pi;
        }
        catch (Throwable throwable) {
            try {
                try {
                    bais.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Error while unmarshalling process instance", e);
            }
        }
        bais.close();
        return workflowProcessInstance;
    }

    public ProcessInstance unmarshallProcessInstance(byte[] data, Process process) {
        return ((AbstractProcess)process).createInstance(this.unmarshallWorkflowProcessInstance(data, process));
    }

    public ProcessInstance unmarshallReadOnlyProcessInstance(byte[] data, Process process) {
        return ((AbstractProcess)process).createReadOnlyInstance(this.unmarshallWorkflowProcessInstance(data, process));
    }
}

