/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance;

import java.util.EventListener;
import java.util.Optional;
import org.drools.core.event.ProcessEventSupport;
import org.jbpm.process.instance.LightWorkItemManager;
import org.jbpm.process.instance.ProcessInstanceManager;
import org.jbpm.process.instance.ProcessRuntimeServiceProvider;
import org.jbpm.process.instance.impl.DefaultProcessInstanceManager;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.kogito.jobs.JobsService;
import org.kie.kogito.process.ProcessEventListenerConfig;
import org.kie.kogito.process.WorkItemHandlerConfig;
import org.kie.kogito.signal.SignalManager;
import org.kie.kogito.signal.SignalManagerHub;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.kie.services.signal.LightSignalManager;

public class AbstractProcessRuntimeServiceProvider
implements ProcessRuntimeServiceProvider {
    private final JobsService jobsService;
    private final ProcessInstanceManager processInstanceManager;
    private final SignalManager signalManager;
    private final WorkItemManager workItemManager;
    private final ProcessEventSupport eventSupport;
    private final UnitOfWorkManager unitOfWorkManager;

    public AbstractProcessRuntimeServiceProvider(JobsService jobsService, WorkItemHandlerConfig workItemHandlerProvider, ProcessEventListenerConfig processEventListenerProvider, SignalManagerHub compositeSignalManager, UnitOfWorkManager unitOfWorkManager) {
        this.unitOfWorkManager = unitOfWorkManager;
        this.processInstanceManager = new DefaultProcessInstanceManager();
        this.signalManager = new LightSignalManager(id -> Optional.ofNullable(this.processInstanceManager.getProcessInstance(id)), compositeSignalManager);
        this.eventSupport = new ProcessEventSupport(this.unitOfWorkManager);
        this.jobsService = jobsService;
        this.workItemManager = new LightWorkItemManager(this.processInstanceManager, this.signalManager, this.eventSupport);
        for (String workItem : workItemHandlerProvider.names()) {
            this.workItemManager.registerWorkItemHandler(workItem, workItemHandlerProvider.forName(workItem));
        }
        for (ProcessEventListener listener : processEventListenerProvider.listeners()) {
            this.eventSupport.addEventListener((EventListener)listener);
        }
    }

    @Override
    public JobsService getJobsService() {
        return this.jobsService;
    }

    @Override
    public ProcessInstanceManager getProcessInstanceManager() {
        return this.processInstanceManager;
    }

    @Override
    public SignalManager getSignalManager() {
        return this.signalManager;
    }

    @Override
    public WorkItemManager getWorkItemManager() {
        return this.workItemManager;
    }

    @Override
    public ProcessEventSupport getEventSupport() {
        return this.eventSupport;
    }

    @Override
    public UnitOfWorkManager getUnitOfWorkManager() {
        return this.unitOfWorkManager;
    }
}

