/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.event.listeners;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Map;
import org.drools.core.marshalling.impl.ProcessMarshallerWriteContext;
import org.drools.core.marshalling.impl.SerializablePlaceholderResolverStrategy;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarshalVariablesProcessEventListener
extends DefaultProcessEventListener {
    private static final Logger logger = LoggerFactory.getLogger(MarshalVariablesProcessEventListener.class);

    public void afterProcessCompleted(ProcessCompletedEvent event) {
        ObjectMarshallingStrategy[] strategies = (ObjectMarshallingStrategy[])event.getKieRuntime().getEnvironment().get("org.kie.api.marshalling.ObjectMarshallingStrategies");
        VariableScopeInstance variableScope = (VariableScopeInstance)((WorkflowProcessInstance)event.getProcessInstance()).getContextInstance("VariableScope");
        Map<String, Object> variables = variableScope.getVariables();
        block2: for (Map.Entry<String, Object> variable : variables.entrySet()) {
            logger.debug("Searching for applicable strategy to handle variable name '{}' value '{}'", (Object)variable.getKey(), variable.getValue());
            for (ObjectMarshallingStrategy strategy : strategies) {
                if (strategy instanceof SerializablePlaceholderResolverStrategy || !strategy.accept(variable.getValue())) continue;
                logger.debug("Strategy of type {} found to handle variable '{}'", (Object)strategy, (Object)variable.getKey());
                try {
                    ProcessMarshallerWriteContext context = new ProcessMarshallerWriteContext((OutputStream)new ByteArrayOutputStream(), null, null, null, null, event.getKieRuntime().getEnvironment());
                    context.setProcessInstanceId(event.getProcessInstance().getId());
                    context.setState(2);
                    strategy.marshal(null, (ObjectOutputStream)context, variable.getValue());
                    logger.debug("Variable '{}' successfully persisted by strategy {}", (Object)variable.getKey(), (Object)strategy);
                    continue block2;
                }
                catch (Exception e) {
                    logger.warn("Errer while storing process variable {} due to {}", (Object)variable.getKey(), (Object)e.getMessage());
                    logger.debug("Variable marshal error:", (Throwable)e);
                }
            }
        }
    }
}

