/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ruleflow.core.validation;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.process.core.validation.ProcessValidationError;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.ruleflow.core.validation.RuleFlowProcessValidator;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.impl.ConnectionImpl;
import org.jbpm.workflow.core.node.CompositeNode;
import org.jbpm.workflow.core.node.DynamicNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.StartNode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class RuleFlowProcessValidatorTest {
    private RuleFlowProcessValidator validator;
    private List<ProcessValidationError> errors;
    private RuleFlowProcess process = (RuleFlowProcess)Mockito.mock(RuleFlowProcess.class);
    private Node node = (Node)Mockito.mock(Node.class);

    @BeforeEach
    public void setUp() throws Exception {
        this.errors = new ArrayList<ProcessValidationError>();
        this.validator = RuleFlowProcessValidator.getInstance();
    }

    @Test
    public void testAddErrorMessage() throws Exception {
        Mockito.when((Object)this.node.getName()).thenReturn((Object)"nodeName");
        Mockito.when((Object)this.node.getId()).thenReturn((Object)Long.MAX_VALUE);
        this.validator.addErrorMessage(this.process, (org.kie.api.definition.process.Node)this.node, this.errors, "any message");
        Assertions.assertEquals((int)1, (int)this.errors.size());
        Assertions.assertEquals((Object)"Node 'nodeName' [9223372036854775807] any message", (Object)this.errors.get(0).getMessage());
    }

    @Test
    public void testDynamicNodeValidationInNotDynamicProcess() throws Exception {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.core.process");
        process.setName("Dynamic Node Process");
        process.setPackageName("org.mycomp.myprocess");
        process.setDynamic(false);
        DynamicNode dynamicNode = new DynamicNode();
        dynamicNode.setName("MyDynamicNode");
        dynamicNode.setId(1L);
        dynamicNode.setAutoComplete(false);
        dynamicNode.setCompletionExpression("");
        process.addNode((org.kie.api.definition.process.Node)dynamicNode);
        ProcessValidationError[] errors = this.validator.validateProcess(process);
        Assertions.assertNotNull((Object)errors);
        Assertions.assertEquals((int)6, (int)errors.length);
        Assertions.assertEquals((Object)"Process has no start node.", (Object)errors[0].getMessage());
        Assertions.assertEquals((Object)"Process has no end node.", (Object)errors[1].getMessage());
        Assertions.assertEquals((Object)"Node 'MyDynamicNode' [1] Dynamic has no incoming connection", (Object)errors[2].getMessage());
        Assertions.assertEquals((Object)"Node 'MyDynamicNode' [1] Dynamic has no outgoing connection", (Object)errors[3].getMessage());
        Assertions.assertEquals((Object)"Node 'MyDynamicNode' [1] Dynamic has no completion condition set", (Object)errors[4].getMessage());
        Assertions.assertEquals((Object)"Node 'MyDynamicNode' [1] Has no connection to the start node.", (Object)errors[5].getMessage());
    }

    @Test
    public void testDynamicNodeValidationInDynamicProcess() throws Exception {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.core.process");
        process.setName("Dynamic Node Process");
        process.setPackageName("org.mycomp.myprocess");
        process.setDynamic(true);
        DynamicNode dynamicNode = new DynamicNode();
        dynamicNode.setName("MyDynamicNode");
        dynamicNode.setId(1L);
        dynamicNode.setAutoComplete(false);
        dynamicNode.setCompletionExpression("completion-expression");
        process.addNode((org.kie.api.definition.process.Node)dynamicNode);
        ProcessValidationError[] errors = this.validator.validateProcess(process);
        Assertions.assertNotNull((Object)errors);
        Assertions.assertEquals((int)0, (int)errors.length);
        process.removeNode((org.kie.api.definition.process.Node)dynamicNode);
        DynamicNode dynamicNode2 = new DynamicNode();
        dynamicNode2.setName("MyDynamicNode");
        dynamicNode2.setId(1L);
        dynamicNode2.setAutoComplete(false);
        dynamicNode2.setCompletionExpression("");
        process.addNode((org.kie.api.definition.process.Node)dynamicNode2);
        ProcessValidationError[] errors2 = this.validator.validateProcess(process);
        Assertions.assertNotNull((Object)errors2);
        Assertions.assertEquals((int)1, (int)errors2.length);
        Assertions.assertEquals((Object)"Node 'MyDynamicNode' [1] Dynamic has no completion condition set", (Object)errors2[0].getMessage());
    }

    @Test
    public void testEmptyPackageName() throws Exception {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.core.process");
        process.setName("Empty Package Name Process");
        process.setPackageName("");
        process.setDynamic(true);
        ProcessValidationError[] errors = this.validator.validateProcess(process);
        Assertions.assertNotNull((Object)errors);
        Assertions.assertEquals((int)0, (int)errors.length);
    }

    @Test
    public void testNoPackageName() throws Exception {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.core.process");
        process.setName("No Package Name Process");
        process.setDynamic(true);
        ProcessValidationError[] errors = this.validator.validateProcess(process);
        Assertions.assertNotNull((Object)errors);
        Assertions.assertEquals((int)0, (int)errors.length);
    }

    @Test
    public void testCompositeNodeNoStart() throws Exception {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.core.process.process");
        process.setName("Process");
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        process.addNode((org.kie.api.definition.process.Node)startNode);
        EndNode endNode = new EndNode();
        endNode.setName("EndNode");
        endNode.setId(2L);
        process.addNode((org.kie.api.definition.process.Node)endNode);
        CompositeNode compositeNode = new CompositeNode();
        compositeNode.setName("CompositeNode");
        compositeNode.setId(3L);
        process.addNode((org.kie.api.definition.process.Node)compositeNode);
        new ConnectionImpl((org.kie.api.definition.process.Node)startNode, "DROOLS_DEFAULT", (org.kie.api.definition.process.Node)compositeNode, "DROOLS_DEFAULT");
        new ConnectionImpl((org.kie.api.definition.process.Node)compositeNode, "DROOLS_DEFAULT", (org.kie.api.definition.process.Node)endNode, "DROOLS_DEFAULT");
        ProcessValidationError[] errors = this.validator.validateProcess(process);
        Assertions.assertNotNull((Object)errors);
        Assertions.assertEquals((int)1, (int)errors.length);
        Assertions.assertEquals((Object)"Node 'CompositeNode' [3] Composite has no start node defined.", (Object)errors[0].getMessage());
    }
}

