/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.jbpm.process.core.event.EventTransformer;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.util.PatternConstants;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.impl.DummyEventListener;
import org.jbpm.workflow.instance.impl.ExtendedNodeInstanceImpl;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.EventBasedNodeInstanceInterface;
import org.jbpm.workflow.instance.node.EventNodeInstanceInterface;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.process.EventListener;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.kogito.jobs.JobsService;
import org.kie.services.time.TimerInstance;

public class EventNodeInstance
extends ExtendedNodeInstanceImpl
implements EventNodeInstanceInterface,
EventBasedNodeInstanceInterface {
    private static final long serialVersionUID = 510L;

    @Override
    public void signalEvent(String type, Object event) {
        if ("timerTriggered".equals(type)) {
            TimerInstance timerInstance = (TimerInstance)event;
            if (timerInstance.getId().equals(this.slaTimerId)) {
                this.handleSLAViolation();
            }
        } else if (("slaViolation:" + this.getId()).equals(type)) {
            this.handleSLAViolation();
        } else {
            String variableName = this.getEventNode().getVariableName();
            if (variableName != null) {
                VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", variableName);
                if (variableScopeInstance == null) {
                    throw new IllegalArgumentException("Could not find variable for event node: " + variableName);
                }
                EventTransformer transformer = this.getEventNode().getEventTransformer();
                if (transformer != null) {
                    event = transformer.transformEvent(event);
                }
                variableScopeInstance.setVariable(this, variableName, event);
            }
            this.triggerCompleted();
        }
    }

    @Override
    public void internalTrigger(NodeInstance from, String type) {
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("An EventNode only accepts default incoming connections!");
        }
        this.triggerTime = new Date();
        this.addEventListeners();
    }

    @Override
    protected void configureSla() {
        TimerInstance timer;
        String slaDueDateExpression = (String)this.getNode().getMetaData().get("customSLADueDate");
        if (slaDueDateExpression != null && (timer = ((WorkflowProcessInstanceImpl)this.getProcessInstance()).configureSLATimer(slaDueDateExpression)) != null) {
            this.slaTimerId = timer.getId();
            this.slaDueDate = new Date(System.currentTimeMillis() + timer.getDelay());
            this.slaCompliance = 1;
            logger.debug("SLA for node instance {} is PENDING with due date {}", (Object)this.getId(), (Object)this.slaDueDate);
        }
    }

    protected void handleSLAViolation() {
        if (this.slaCompliance == 1) {
            InternalProcessRuntime processRuntime = (InternalProcessRuntime)this.getProcessInstance().getKnowledgeRuntime().getProcessRuntime();
            processRuntime.getProcessEventSupport().fireBeforeSLAViolated((ProcessInstance)this.getProcessInstance(), (NodeInstance)this, (KieRuntime)this.getProcessInstance().getKnowledgeRuntime());
            logger.debug("SLA violated on node instance {}", (Object)this.getId());
            this.slaCompliance = 3;
            this.slaTimerId = null;
            processRuntime.getProcessEventSupport().fireAfterSLAViolated((ProcessInstance)this.getProcessInstance(), (NodeInstance)this, (KieRuntime)this.getProcessInstance().getKnowledgeRuntime());
        }
    }

    private void cancelSlaTimer() {
        if (this.slaTimerId != null && !this.slaTimerId.trim().isEmpty()) {
            JobsService jobService = ((InternalProcessRuntime)this.getProcessInstance().getKnowledgeRuntime().getProcessRuntime()).getJobsService();
            jobService.cancelJob(this.slaTimerId);
            logger.debug("SLA Timer {} has been canceled", (Object)this.slaTimerId);
        }
    }

    protected void addTimerListener() {
        this.getProcessInstance().addEventListener("timerTriggered", new VariableExternalEventListener("timerTriggered"), false);
        this.getProcessInstance().addEventListener("timer", new VariableExternalEventListener("timer"), true);
        this.getProcessInstance().addEventListener("slaViolation:" + this.getId(), new VariableExternalEventListener("slaViolation"), true);
    }

    public void removeTimerListeners() {
        this.getProcessInstance().removeEventListener("timerTriggered", new VariableExternalEventListener("timerTriggered"), false);
        this.getProcessInstance().removeEventListener("timer", new VariableExternalEventListener("timer"), true);
        this.getProcessInstance().removeEventListener("slaViolation:" + this.getId(), new VariableExternalEventListener("slaViolation"), true);
    }

    public EventNode getEventNode() {
        return (EventNode)this.getNode();
    }

    public void triggerCompleted() {
        this.getProcessInstance().removeEventListener(this.getEventType(), this.getEventListener(), true);
        this.removeTimerListeners();
        if (this.slaCompliance == 1) {
            this.slaCompliance = System.currentTimeMillis() > this.slaDueDate.getTime() ? 3 : 2;
        }
        this.cancelSlaTimer();
        ((NodeInstanceContainer)this.getNodeInstanceContainer()).setCurrentLevel(this.getLevel());
        this.triggerCompleted("DROOLS_DEFAULT", true);
    }

    @Override
    public void cancel() {
        this.getProcessInstance().removeEventListener(this.getEventType(), this.getEventListener(), true);
        this.removeTimerListeners();
        if (this.slaCompliance == 1) {
            this.slaCompliance = System.currentTimeMillis() > this.slaDueDate.getTime() ? 3 : 4;
        }
        this.removeTimerListeners();
        super.cancel();
    }

    @Override
    public void addEventListeners() {
        String eventType = this.getEventType();
        if (this.isVariableExpression(this.getEventNode().getType())) {
            this.getProcessInstance().addEventListener(eventType, new VariableExternalEventListener(eventType), true);
        } else {
            this.getProcessInstance().addEventListener(eventType, this.getEventListener(), true);
        }
        if (this.slaTimerId != null && !this.slaTimerId.trim().isEmpty()) {
            this.addTimerListener();
        }
    }

    @Override
    public void removeEventListeners() {
    }

    public String getEventType() {
        return this.resolveVariable(this.getEventNode().getType());
    }

    protected EventListener getEventListener() {
        return DummyEventListener.EMPTY_EVENT_LISTENER;
    }

    private boolean isVariableExpression(String eventType) {
        if (eventType == null) {
            return false;
        }
        Matcher matcher = PatternConstants.PARAMETER_MATCHER.matcher(eventType);
        return matcher.find();
    }

    private String resolveVariable(String s) {
        if (s == null) {
            return null;
        }
        HashMap<String, String> replacements = new HashMap<String, String>();
        Matcher matcher = PatternConstants.PARAMETER_MATCHER.matcher(s);
        while (matcher.find()) {
            VariableScopeInstance variableScopeInstance;
            String paramName = matcher.group(1);
            if (replacements.get(paramName) != null || (variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", paramName)) == null) continue;
            Object variableValue = variableScopeInstance.getVariable(paramName);
            String variableValueString = variableValue == null ? "" : variableValue.toString();
            replacements.put(paramName, variableValueString);
        }
        for (Map.Entry replacement : replacements.entrySet()) {
            s = s.replace("#{" + (String)replacement.getKey() + "}", (CharSequence)replacement.getValue());
        }
        return s;
    }

    private void callSignal(String type, Object event) {
        this.signalEvent(type, event);
    }

    private class VariableExternalEventListener
    implements EventListener,
    Serializable {
        private static final long serialVersionUID = 5L;
        private String eventType;

        VariableExternalEventListener(String eventType) {
            this.eventType = eventType;
        }

        public String[] getEventTypes() {
            return new String[]{this.eventType};
        }

        public void signalEvent(String type, Object event) {
            EventNodeInstance.this.callSignal(type, event);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.eventType == null ? 0 : this.eventType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VariableExternalEventListener other = (VariableExternalEventListener)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.eventType == null ? other.eventType != null : !this.eventType.equals(other.eventType));
        }

        private EventNodeInstance getOuterType() {
            return EventNodeInstance.this;
        }
    }
}

