/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.core.node;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.impl.ExtendedNodeImpl;
import org.jbpm.workflow.core.node.DataAssociation;
import org.kie.api.definition.process.Connection;

public class ActionNode
extends ExtendedNodeImpl {
    private static final long serialVersionUID = 510L;
    private DroolsAction action;
    private List<DataAssociation> inMapping = new LinkedList<DataAssociation>();
    private List<DataAssociation> outMapping = new LinkedList<DataAssociation>();

    public DroolsAction getAction() {
        return this.action;
    }

    public void setAction(DroolsAction action) {
        this.action = action;
    }

    @Override
    public void validateAddIncomingConnection(String type, Connection connection) {
        super.validateAddIncomingConnection(type, connection);
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("This type of node [" + connection.getTo().getMetaData().get("UniqueId") + ", " + connection.getTo().getName() + "] only accepts default incoming connection type!");
        }
        if (this.getFrom() != null && !"true".equals(System.getProperty("jbpm.enable.multi.con"))) {
            throw new IllegalArgumentException("This type of node [" + connection.getTo().getMetaData().get("UniqueId") + ", " + connection.getTo().getName() + "] cannot have more than one incoming connection!");
        }
    }

    @Override
    public void validateAddOutgoingConnection(String type, Connection connection) {
        super.validateAddOutgoingConnection(type, connection);
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("This type of node [" + connection.getFrom().getMetaData().get("UniqueId") + ", " + connection.getFrom().getName() + "] only accepts default outgoing connection type!");
        }
        if (this.getTo() != null && !"true".equals(System.getProperty("jbpm.enable.multi.con"))) {
            throw new IllegalArgumentException("This type of node [" + connection.getFrom().getMetaData().get("UniqueId") + ", " + connection.getFrom().getName() + "] cannot have more than one outgoing connection!");
        }
    }

    public void addInAssociation(DataAssociation dataAssociation) {
        this.inMapping.add(dataAssociation);
    }

    public List<DataAssociation> getInAssociations() {
        return Collections.unmodifiableList(this.inMapping);
    }

    public void addOutAssociation(DataAssociation dataAssociation) {
        this.outMapping.add(dataAssociation);
    }

    public List<DataAssociation> getOutAssociations() {
        return Collections.unmodifiableList(this.outMapping);
    }
}

