/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.drools.core.WorkItemHandlerNotFoundException;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.spi.KogitoProcessContextImpl;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.ParameterDefinition;
import org.jbpm.process.core.Work;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.impl.DataTransformerRegistry;
import org.jbpm.process.instance.ContextInstance;
import org.jbpm.process.instance.ContextInstanceContainer;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.context.exception.ExceptionScopeInstance;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.process.instance.impl.AssignmentAction;
import org.jbpm.process.instance.impl.ContextInstanceFactory;
import org.jbpm.process.instance.impl.ContextInstanceFactoryRegistry;
import org.jbpm.process.instance.impl.ProcessInstanceImpl;
import org.jbpm.util.PatternConstants;
import org.jbpm.workflow.core.node.Assignment;
import org.jbpm.workflow.core.node.DataAssociation;
import org.jbpm.workflow.core.node.Transformation;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.WorkflowRuntimeException;
import org.jbpm.workflow.instance.impl.MVELProcessHelper;
import org.jbpm.workflow.instance.impl.NodeInstanceResolverFactory;
import org.jbpm.workflow.instance.impl.WorkItemResolverFactory;
import org.jbpm.workflow.instance.node.StateBasedNodeInstance;
import org.kie.api.definition.process.Node;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.process.DataTransformer;
import org.kie.api.runtime.process.EventListener;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessContext;
import org.kie.api.runtime.process.ProcessRuntime;
import org.kie.api.runtime.process.ProcessWorkItemHandlerException;
import org.kie.api.runtime.process.WorkItem;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.kie.kogito.process.EventDescription;
import org.kie.kogito.process.GroupedNamedDataType;
import org.kie.kogito.process.IOEventDescription;
import org.kie.kogito.process.NamedDataType;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.process.workitem.WorkItemExecutionException;
import org.kie.kogito.process.workitems.InternalKogitoWorkItem;
import org.kie.kogito.process.workitems.InternalKogitoWorkItemManager;
import org.kie.kogito.process.workitems.impl.KogitoWorkItemImpl;
import org.mvel2.integration.VariableResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkItemNodeInstance
extends StateBasedNodeInstance
implements EventListener,
ContextInstanceContainer {
    private static final long serialVersionUID = 510L;
    private static final Logger logger = LoggerFactory.getLogger(WorkItemNodeInstance.class);
    private static List<String> defaultOutputVariables = Arrays.asList("ActorId");
    private Map<String, List<ContextInstance>> subContextInstances = new HashMap<String, List<ContextInstance>>();
    private String workItemId;
    private transient InternalKogitoWorkItem workItem;
    private String exceptionHandlingProcessInstanceId;

    protected WorkItemNode getWorkItemNode() {
        return (WorkItemNode)this.getNode();
    }

    public InternalKogitoWorkItem getWorkItem() {
        if (this.workItem == null && this.workItemId != null) {
            this.workItem = ((InternalKogitoWorkItemManager)this.getProcessInstance().getKnowledgeRuntime().getWorkItemManager()).getWorkItem(this.workItemId);
        }
        return this.workItem;
    }

    public String getWorkItemId() {
        return this.workItemId;
    }

    public void internalSetWorkItemId(String workItemId) {
        this.workItemId = workItemId;
    }

    public void internalSetWorkItem(InternalKogitoWorkItem workItem) {
        this.workItem = workItem;
        this.workItem.setProcessInstance((KogitoProcessInstance)this.getProcessInstance());
        this.workItem.setNodeInstance((KogitoNodeInstance)this);
    }

    @Override
    public boolean isInversionOfControl() {
        return false;
    }

    public void internalRegisterWorkItem() {
        ((InternalKogitoWorkItemManager)this.getProcessInstance().getKnowledgeRuntime().getWorkItemManager()).internalAddWorkItem(this.workItem);
    }

    @Override
    public void internalTrigger(KogitoNodeInstance from, String type) {
        super.internalTrigger(from, type);
        if (this.getNodeInstanceContainer().getNodeInstance(this.getStringId()) == null) {
            return;
        }
        WorkItemNode workItemNode = this.getWorkItemNode();
        this.createWorkItem(workItemNode);
        if (workItemNode.isWaitForCompletion()) {
            this.addWorkItemListener();
        }
        String deploymentId = (String)this.getProcessInstance().getKnowledgeRuntime().getEnvironment().get("deploymentId");
        this.workItem.setDeploymentId(deploymentId);
        this.workItem.setNodeInstanceId(this.getStringId());
        this.workItem.setNodeId(this.getNodeId());
        this.workItem.setNodeInstance((KogitoNodeInstance)this);
        this.workItem.setProcessInstance((KogitoProcessInstance)this.getProcessInstance());
        if (this.isInversionOfControl()) {
            this.getProcessInstance().getKnowledgeRuntime().update(this.getProcessInstance().getKnowledgeRuntime().getFactHandle((Object)this), (Object)this);
        } else {
            try {
                ((InternalKogitoWorkItemManager)this.getProcessInstance().getKnowledgeRuntime().getWorkItemManager()).internalExecuteWorkItem(this.workItem);
            }
            catch (WorkItemHandlerNotFoundException wihnfe) {
                this.getProcessInstance().setState(3);
                throw wihnfe;
            }
            catch (ProcessWorkItemHandlerException handlerException) {
                this.workItemId = this.workItem.getStringId();
                this.handleWorkItemHandlerException(handlerException, this.workItem);
            }
            catch (WorkItemExecutionException e) {
                this.handleException(e.getErrorCode(), (Exception)((Object)e));
            }
            catch (Exception e) {
                String exceptionName = e.getClass().getName();
                this.handleException(exceptionName, e);
            }
        }
        if (!workItemNode.isWaitForCompletion()) {
            this.triggerCompleted();
        }
        this.workItemId = this.workItem.getStringId();
    }

    protected void handleException(String exceptionName, Exception e) {
        ExceptionScopeInstance exceptionScopeInstance = (ExceptionScopeInstance)this.resolveContextInstance("ExceptionScope", exceptionName);
        if (exceptionScopeInstance == null) {
            throw new WorkflowRuntimeException(this, this.getProcessInstance(), "Unable to execute Action: " + e.getMessage(), e);
        }
        this.workItemId = this.workItem.getStringId();
        exceptionScopeInstance.handleException(exceptionName, e);
    }

    protected InternalKogitoWorkItem newWorkItem() {
        return new KogitoWorkItemImpl();
    }

    protected InternalKogitoWorkItem createWorkItem(WorkItemNode workItemNode) {
        Work work = workItemNode.getWork();
        this.workItem = this.newWorkItem();
        this.workItem.setName(work.getName());
        this.workItem.setProcessInstanceId(this.getProcessInstance().getStringId());
        Set<String> metaParameters = work.getMetaParameters();
        for (Map.Entry<String, Object> entry : work.getParameters().entrySet()) {
            if (metaParameters.contains(entry.getKey())) continue;
            this.workItem.setParameter(entry.getKey(), entry.getValue());
        }
        this.workItem.setStartDate(new Date());
        if (this.dynamicParameters != null) {
            this.workItem.getParameters().putAll(this.dynamicParameters);
        }
        for (DataAssociation dataAssociation : workItemNode.getInAssociations()) {
            if (dataAssociation.getTransformation() != null) {
                Object parameterValue;
                Transformation transformation = dataAssociation.getTransformation();
                DataTransformer transformer = DataTransformerRegistry.get().find(transformation.getLanguage());
                if (transformer == null || (parameterValue = transformer.transform(transformation.getCompiledExpression(), this.getSourceParameters(dataAssociation))) == null) continue;
                this.workItem.setParameter(dataAssociation.getTarget(), parameterValue);
                continue;
            }
            if (dataAssociation.getAssignments() == null || dataAssociation.getAssignments().isEmpty()) {
                Object parameterValue = null;
                VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", dataAssociation.getSources().get(0));
                if (variableScopeInstance != null) {
                    parameterValue = variableScopeInstance.getVariable(dataAssociation.getSources().get(0));
                } else {
                    try {
                        parameterValue = MVELProcessHelper.evaluator().eval(dataAssociation.getSources().get(0), (VariableResolverFactory)new NodeInstanceResolverFactory(this));
                    }
                    catch (Throwable t) {
                        logger.error("Could not find variable scope for variable {}", (Object)dataAssociation.getSources().get(0));
                        logger.error("when trying to execute Work Item {}", (Object)work.getName());
                        logger.error("Continuing without setting parameter.");
                    }
                }
                if (parameterValue == null) continue;
                this.workItem.setParameter(dataAssociation.getTarget(), parameterValue);
                continue;
            }
            dataAssociation.getAssignments().forEach(this::handleAssignment);
        }
        for (Map.Entry entry : this.workItem.getParameters().entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            String s = (String)entry.getValue();
            HashMap<String, String> replacements = new HashMap<String, String>();
            Matcher matcher = PatternConstants.PARAMETER_MATCHER.matcher(s);
            while (matcher.find()) {
                String variableValueString;
                Object variableValue;
                String paramName = matcher.group(1);
                if (replacements.get(paramName) != null) continue;
                VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", paramName);
                if (variableScopeInstance != null) {
                    variableValue = variableScopeInstance.getVariable(paramName);
                    variableValueString = variableValue == null ? "" : variableValue.toString();
                    replacements.put(paramName, variableValueString);
                    continue;
                }
                try {
                    variableValue = MVELProcessHelper.evaluator().eval(paramName, (VariableResolverFactory)new NodeInstanceResolverFactory(this));
                    variableValueString = variableValue == null ? "" : variableValue.toString();
                    replacements.put(paramName, variableValueString);
                }
                catch (Throwable t) {
                    logger.error("Could not find variable scope for variable {}", (Object)paramName);
                    logger.error("when trying to replace variable in string for Work Item {}", (Object)work.getName());
                    logger.error("Continuing without setting parameter.");
                }
            }
            for (Map.Entry replacement : replacements.entrySet()) {
                s = s.replace("#{" + (String)replacement.getKey() + "}", (CharSequence)replacement.getValue());
            }
            this.workItem.setParameter((String)entry.getKey(), (Object)s);
        }
        return this.workItem;
    }

    private void handleAssignment(Assignment assignment) {
        AssignmentAction action = (AssignmentAction)assignment.getMetaData("Action");
        try {
            KogitoProcessContextImpl context = new KogitoProcessContextImpl((KieRuntime)this.getProcessInstance().getKnowledgeRuntime());
            context.setNodeInstance((NodeInstance)this);
            action.execute(this.getWorkItem(), (ProcessContext)context);
        }
        catch (Exception e) {
            throw new RuntimeException("unable to execute Assignment", e);
        }
    }

    public void triggerCompleted(InternalKogitoWorkItem workItem) {
        this.workItem = workItem;
        WorkItemNode workItemNode = this.getWorkItemNode();
        if (workItemNode != null && workItem.getState() == 2) {
            this.validateWorkItemResultVariable(this.getProcessInstance().getProcessName(), workItemNode.getOutAssociations(), workItem);
            for (DataAssociation association : this.getWorkItemNode().getOutAssociations()) {
                if (association.getTransformation() != null) {
                    Transformation transformation = association.getTransformation();
                    DataTransformer transformer = DataTransformerRegistry.get().find(transformation.getLanguage());
                    if (transformer == null) continue;
                    Object parameterValue = transformer.transform(transformation.getCompiledExpression(), workItem.getResults());
                    VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", association.getTarget());
                    if (variableScopeInstance != null && parameterValue != null) {
                        variableScopeInstance.getVariableScope().validateVariable(this.getProcessInstance().getProcessName(), association.getTarget(), parameterValue);
                        variableScopeInstance.setVariable(this, association.getTarget(), parameterValue);
                    } else {
                        logger.warn("Could not find variable scope for variable {}", (Object)association.getTarget());
                        logger.warn("when trying to complete Work Item {}", (Object)workItem.getName());
                        logger.warn("Continuing without setting variable.");
                    }
                    if (parameterValue == null) continue;
                    workItem.setParameter(association.getTarget(), parameterValue);
                    continue;
                }
                if (association.getAssignments() == null || association.getAssignments().isEmpty()) {
                    VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", association.getTarget());
                    if (variableScopeInstance != null) {
                        Variable varDef;
                        DataType dataType;
                        Object value = workItem.getResult(association.getSources().get(0));
                        if (value == null) {
                            try {
                                value = MVELProcessHelper.evaluator().eval(association.getSources().get(0), (VariableResolverFactory)new WorkItemResolverFactory((WorkItem)workItem));
                            }
                            catch (Throwable parameterValue) {
                                // empty catch block
                            }
                        }
                        if (!(dataType = (varDef = variableScopeInstance.getVariableScope().findVariable(association.getTarget())).getType()).getStringType().endsWith("java.lang.Object") && !dataType.getStringType().endsWith("Object") && value instanceof String) {
                            value = dataType.readValue((String)value);
                        } else {
                            variableScopeInstance.getVariableScope().validateVariable(this.getProcessInstance().getProcessName(), association.getTarget(), value);
                        }
                        variableScopeInstance.setVariable(this, association.getTarget(), value);
                        continue;
                    }
                    String output = association.getSources().get(0);
                    String target = association.getTarget();
                    Matcher matcher = PatternConstants.PARAMETER_MATCHER.matcher(target);
                    if (matcher.find()) {
                        String paramName = matcher.group(1);
                        String expression = paramName + " = " + output;
                        NodeInstanceResolverFactory resolver = new NodeInstanceResolverFactory(this);
                        resolver.addExtraParameters(workItem.getResults());
                        Serializable compiled = MVELProcessHelper.compileExpression(expression);
                        MVELProcessHelper.evaluator().executeExpression((Object)compiled, (VariableResolverFactory)resolver);
                        continue;
                    }
                    logger.warn("Could not find variable scope for variable {}", (Object)association.getTarget());
                    logger.warn("when trying to complete Work Item {}", (Object)workItem.getName());
                    logger.warn("Continuing without setting variable.");
                    continue;
                }
                try {
                    association.getAssignments().forEach(this::handleAssignment);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getNode() == null) {
            this.setMetaData("NodeType", workItem.getName());
            this.mapDynamicOutputData(workItem.getResults());
        }
        if (this.isInversionOfControl()) {
            InternalKnowledgeRuntime kruntime = this.getProcessInstance().getKnowledgeRuntime();
            kruntime.update(kruntime.getFactHandle((Object)this), (Object)this);
        } else {
            this.triggerCompleted();
        }
    }

    @Override
    public void cancel() {
        KogitoProcessRuntime kruntime;
        ProcessInstance processInstance;
        InternalKogitoWorkItem item = this.getWorkItem();
        if (item != null && item.getState() != 2 && item.getState() != 3) {
            try {
                ((InternalKogitoWorkItemManager)this.getProcessInstance().getKnowledgeRuntime().getWorkItemManager()).internalAbortWorkItem(item.getStringId());
            }
            catch (WorkItemHandlerNotFoundException wihnfe) {
                this.getProcessInstance().setState(3);
                throw wihnfe;
            }
        }
        if (this.exceptionHandlingProcessInstanceId != null && (processInstance = (ProcessInstance)(kruntime = this.getKieRuntimeForSubprocess()).getProcessInstance(this.exceptionHandlingProcessInstanceId)) != null) {
            processInstance.setState(3);
        }
        super.cancel();
    }

    @Override
    public void addEventListeners() {
        super.addEventListeners();
        this.addWorkItemListener();
        this.addExceptionProcessListener();
    }

    protected void addWorkItemListener() {
        this.getProcessInstance().addEventListener("workItemCompleted", this, false);
        this.getProcessInstance().addEventListener("workItemAborted", this, false);
    }

    protected void removeWorkItemListener() {
        this.getProcessInstance().removeEventListener("workItemCompleted", this, false);
        this.getProcessInstance().removeEventListener("workItemAborted", this, false);
    }

    @Override
    public void removeEventListeners() {
        super.removeEventListeners();
        this.removeWorkItemListener();
    }

    @Override
    public void signalEvent(String type, Object event) {
        if ("workItemCompleted".equals(type)) {
            this.workItemCompleted((InternalKogitoWorkItem)event);
        } else if ("workItemAborted".equals(type)) {
            this.workItemAborted((InternalKogitoWorkItem)event);
        } else if (("processInstanceCompleted:" + this.exceptionHandlingProcessInstanceId).equals(type)) {
            this.exceptionHandlingCompleted((ProcessInstance)event, null);
        } else if (type.equals("RuleFlow-Activate" + this.getProcessInstance().getProcessId() + "-" + this.getNode().getMetaData().get("UniqueId"))) {
            this.trigger(null, "DROOLS_DEFAULT");
        } else {
            super.signalEvent(type, event);
        }
    }

    @Override
    public String[] getEventTypes() {
        if (this.exceptionHandlingProcessInstanceId != null) {
            return new String[]{"workItemCompleted", "processInstanceCompleted:" + this.exceptionHandlingProcessInstanceId};
        }
        return new String[]{"workItemCompleted"};
    }

    public void workItemAborted(InternalKogitoWorkItem workItem) {
        if (workItem.getStringId().equals(this.workItemId) || this.workItemId == null && this.getWorkItem().getStringId().equals(workItem.getStringId())) {
            this.removeEventListeners();
            this.triggerCompleted(workItem);
        }
    }

    public void workItemCompleted(InternalKogitoWorkItem workItem) {
        if (workItem.getStringId().equals(this.workItemId) || this.workItemId == null && this.getWorkItem().getStringId().equals(workItem.getStringId())) {
            this.removeEventListeners();
            this.triggerCompleted(workItem);
        }
    }

    @Override
    public String getNodeName() {
        Node node = this.getNode();
        if (node == null) {
            Object nodeName = "[Dynamic]";
            InternalKogitoWorkItem item = this.getWorkItem();
            if (item != null) {
                nodeName = (String)nodeName + " " + item.getParameter("TaskName");
            }
            return nodeName;
        }
        return super.getNodeName();
    }

    @Override
    public List<ContextInstance> getContextInstances(String contextId) {
        return this.subContextInstances.get(contextId);
    }

    @Override
    public void addContextInstance(String contextId, ContextInstance contextInstance) {
        this.subContextInstances.computeIfAbsent(contextId, k -> new ArrayList()).add(contextInstance);
    }

    @Override
    public void removeContextInstance(String contextId, ContextInstance contextInstance) {
        List<ContextInstance> list = this.subContextInstances.get(contextId);
        if (list != null) {
            list.remove(contextInstance);
        }
    }

    @Override
    public ContextInstance getContextInstance(String contextId, long id) {
        List<ContextInstance> instances = this.subContextInstances.get(contextId);
        if (instances != null) {
            for (ContextInstance contextInstance : instances) {
                if (contextInstance.getContextId() != id) continue;
                return contextInstance;
            }
        }
        return null;
    }

    @Override
    public ContextInstance getContextInstance(Context context) {
        ContextInstanceFactory conf = ContextInstanceFactoryRegistry.INSTANCE.getContextInstanceFactory(context);
        if (conf == null) {
            throw new IllegalArgumentException("Illegal context type (registry not found): " + context.getClass());
        }
        ContextInstance contextInstance = conf.getContextInstance(context, this, this.getProcessInstance());
        if (contextInstance == null) {
            throw new IllegalArgumentException("Illegal context type (instance not found): " + context.getClass());
        }
        return contextInstance;
    }

    @Override
    public ContextContainer getContextContainer() {
        return this.getWorkItemNode();
    }

    protected Map<String, Object> getSourceParameters(DataAssociation association) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (String sourceParam : association.getSources()) {
            Object parameterValue = null;
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", sourceParam);
            if (variableScopeInstance != null) {
                parameterValue = variableScopeInstance.getVariable(sourceParam);
            } else {
                try {
                    parameterValue = MVELProcessHelper.evaluator().eval(sourceParam, (VariableResolverFactory)new NodeInstanceResolverFactory(this));
                }
                catch (Throwable t) {
                    logger.warn("Could not find variable scope for variable {}", (Object)sourceParam);
                }
            }
            if (parameterValue == null) continue;
            parameters.put(association.getTarget(), parameterValue);
        }
        return parameters;
    }

    public void validateWorkItemResultVariable(String processName, List<DataAssociation> outputs, InternalKogitoWorkItem workItem) {
        if (!VariableScope.isVariableStrictEnabled() || workItem.getResults().isEmpty()) {
            return;
        }
        ArrayList<String> outputNames = new ArrayList<String>();
        for (DataAssociation association : outputs) {
            if (association.getSources() != null) {
                outputNames.add(association.getSources().get(0));
            }
            if (association.getAssignments() == null) continue;
            association.getAssignments().forEach(a -> outputNames.add(a.getFrom()));
        }
        for (String outputName : workItem.getResults().keySet()) {
            if (outputNames.contains(outputName) || defaultOutputVariables.contains(outputName)) continue;
            throw new IllegalArgumentException("Data output '" + outputName + "' is not defined in process '" + processName + "' for task '" + workItem.getParameter("NodeName") + "'");
        }
    }

    private void handleWorkItemHandlerException(ProcessWorkItemHandlerException handlerException, InternalKogitoWorkItem workItem) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("DeploymentId", workItem.getDeploymentId());
        parameters.put("ProcessInstanceId", workItem.getProcessInstanceStringId());
        parameters.put("WorkItemId", workItem.getStringId());
        parameters.put("NodeInstanceId", this.getStringId());
        parameters.put("ErrorMessage", handlerException.getMessage());
        parameters.put("Error", (Object)handlerException);
        parameters.putAll(workItem.getParameters());
        KogitoProcessRuntime kruntime = this.getKieRuntimeForSubprocess();
        ProcessInstance processInstance = (ProcessInstance)kruntime.createProcessInstance(handlerException.getProcessId(), parameters);
        this.exceptionHandlingProcessInstanceId = processInstance.getStringId();
        ((ProcessInstanceImpl)processInstance).setMetaData("ParentProcessInstanceId", this.getProcessInstance().getStringId());
        ((ProcessInstanceImpl)processInstance).setMetaData("ParentNodeInstanceId", this.getUniqueId());
        processInstance.setParentProcessInstanceId(this.getProcessInstance().getStringId());
        processInstance.setSignalCompletion(true);
        kruntime.startProcessInstance(processInstance.getStringId());
        if (processInstance.getState() == 2 || processInstance.getState() == 3) {
            this.exceptionHandlingCompleted(processInstance, handlerException);
        } else {
            this.addExceptionProcessListener();
        }
    }

    private void exceptionHandlingCompleted(ProcessInstance processInstance, ProcessWorkItemHandlerException handlerException) {
        if (handlerException == null) {
            handlerException = (ProcessWorkItemHandlerException)((Object)((WorkflowProcessInstance)processInstance).getVariable("Error"));
        }
        switch (handlerException.getStrategy()) {
            case ABORT: {
                KogitoProcessRuntime.asKogitoProcessRuntime((ProcessRuntime)this.getProcessInstance().getKnowledgeRuntime()).getKogitoWorkItemManager().abortWorkItem(this.getWorkItem().getStringId(), new Policy[0]);
                break;
            }
            case RETHROW: {
                String exceptionName = handlerException.getCause().getClass().getName();
                ExceptionScopeInstance exceptionScopeInstance = (ExceptionScopeInstance)this.resolveContextInstance("ExceptionScope", exceptionName);
                if (exceptionScopeInstance == null) {
                    throw new WorkflowRuntimeException(this, this.getProcessInstance(), "Unable to execute work item " + handlerException.getMessage(), handlerException.getCause());
                }
                exceptionScopeInstance.handleException(exceptionName, handlerException.getCause());
                break;
            }
            case RETRY: {
                HashMap parameters = new HashMap(this.getWorkItem().getParameters());
                parameters.putAll(processInstance.getVariables());
                ((InternalKogitoWorkItemManager)this.getProcessInstance().getKnowledgeRuntime().getWorkItemManager()).retryWorkItem(this.getWorkItem().getStringId(), parameters);
                break;
            }
            case COMPLETE: {
                KogitoProcessRuntime kruntime = KogitoProcessRuntime.asKogitoProcessRuntime((ProcessRuntime)this.getProcessInstance().getKnowledgeRuntime());
                kruntime.getKogitoWorkItemManager().completeWorkItem(this.getWorkItem().getStringId(), processInstance.getVariables(), new Policy[0]);
                break;
            }
        }
    }

    public void addExceptionProcessListener() {
        if (this.exceptionHandlingProcessInstanceId != null) {
            this.getProcessInstance().addEventListener("processInstanceCompleted:" + this.exceptionHandlingProcessInstanceId, this, true);
        }
    }

    public void removeExceptionProcessListeners() {
        super.removeEventListeners();
        this.getProcessInstance().removeEventListener("processInstanceCompleted:" + this.exceptionHandlingProcessInstanceId, this, true);
    }

    public String getExceptionHandlingProcessInstanceId() {
        return this.exceptionHandlingProcessInstanceId;
    }

    public void internalSetProcessInstanceId(String processInstanceId) {
        if (processInstanceId != null && !processInstanceId.isEmpty()) {
            this.exceptionHandlingProcessInstanceId = processInstanceId;
        }
    }

    protected KogitoProcessRuntime getKieRuntimeForSubprocess() {
        return KogitoProcessRuntime.asKogitoProcessRuntime((ProcessRuntime)this.getProcessInstance().getKnowledgeRuntime());
    }

    public Set<EventDescription<?>> getEventDescriptions() {
        ArrayList<NamedDataType> inputs = new ArrayList<NamedDataType>();
        for (ParameterDefinition paramDef : this.getWorkItemNode().getWork().getParameterDefinitions()) {
            inputs.add(new NamedDataType(paramDef.getName(), (Object)paramDef.getType()));
        }
        ArrayList outputs = new ArrayList();
        VariableScope variableScope = (VariableScope)this.getProcessInstance().getContextContainer().getDefaultContext("VariableScope");
        this.getWorkItemNode().getOutAssociations().forEach(da -> da.getSources().forEach(s -> outputs.add(new NamedDataType(s, (Object)variableScope.findVariable(da.getTarget()).getType()))));
        GroupedNamedDataType dataTypes = new GroupedNamedDataType();
        dataTypes.add("Input", inputs);
        dataTypes.add("Output", outputs);
        return Collections.singleton(new IOEventDescription("workItemCompleted", this.getNodeDefinitionId(), this.getNodeName(), "workItem", this.getWorkItemId(), this.getProcessInstance().getStringId(), dataTypes));
    }
}

