/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process;

import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.impl.ConnectionImpl;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.SubProcessNode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.definition.process.Process;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.slf4j.LoggerFactory;

public class SubProcessTest
extends AbstractBaseTest {
    @Override
    public void addLogger() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Test
    public void testNonExistentSubProcess() {
        String nonExistentSubProcessName = "nonexistent.process";
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.core.process.process");
        process.setName("Process");
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        SubProcessNode subProcessNode = new SubProcessNode();
        subProcessNode.setName("SubProcessNode");
        subProcessNode.setId(2L);
        subProcessNode.setProcessId(nonExistentSubProcessName);
        EndNode endNode = new EndNode();
        endNode.setName("End");
        endNode.setId(3L);
        this.connect((Node)startNode, (Node)subProcessNode);
        this.connect((Node)subProcessNode, (Node)endNode);
        process.addNode((org.kie.api.definition.process.Node)startNode);
        process.addNode((org.kie.api.definition.process.Node)subProcessNode);
        process.addNode((org.kie.api.definition.process.Node)endNode);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime(new Process[]{process});
        KogitoProcessInstance pi = kruntime.startProcess("org.drools.core.process.process");
        Assertions.assertEquals((int)5, (int)pi.getState());
    }

    private void connect(Node sourceNode, Node targetNode) {
        new ConnectionImpl((org.kie.api.definition.process.Node)sourceNode, "DROOLS_DEFAULT", (org.kie.api.definition.process.Node)targetNode, "DROOLS_DEFAULT");
    }
}

