/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jbpm.process.core.timer.DateTimeUtils;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.LightProcessRuntime;
import org.jbpm.process.instance.LightProcessRuntimeContext;
import org.jbpm.process.instance.LightProcessRuntimeServiceProvider;
import org.jbpm.process.instance.ProcessRuntimeServiceProvider;
import org.jbpm.workflow.core.impl.WorkflowProcessImpl;
import org.jbpm.workflow.core.node.StartNode;
import org.kie.api.runtime.process.EventListener;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemManager;
import org.kie.kogito.jobs.DurationExpirationTime;
import org.kie.kogito.jobs.ExactExpirationTime;
import org.kie.kogito.jobs.ExpirationTime;
import org.kie.kogito.jobs.ProcessJobDescription;
import org.kie.kogito.process.MutableProcessInstances;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessConfig;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.ProcessInstances;
import org.kie.kogito.process.ProcessInstancesFactory;
import org.kie.kogito.process.Signal;
import org.kie.kogito.process.impl.ConfiguredProcessServices;
import org.kie.kogito.process.impl.MapProcessInstances;
import org.kie.kogito.process.impl.Sig;

public abstract class AbstractProcess<T extends Model>
implements Process<T> {
    protected final ProcessRuntimeServiceProvider services;
    protected ProcessInstancesFactory processInstancesFactory;
    protected MutableProcessInstances<T> instances;
    protected CompletionEventListener completionEventListener = new CompletionEventListener();
    protected Application app;
    protected boolean activated;
    protected List<String> startTimerInstances = new ArrayList<String>();
    protected KogitoProcessRuntime processRuntime;

    protected AbstractProcess() {
        this(new LightProcessRuntimeServiceProvider());
    }

    protected AbstractProcess(ProcessConfig config) {
        this(new ConfiguredProcessServices(config));
    }

    protected AbstractProcess(ProcessRuntimeServiceProvider services) {
        this(services, Collections.emptyList(), null);
    }

    protected AbstractProcess(Application app, Collection<KogitoWorkItemHandler> handlers) {
        this(app, handlers, null);
    }

    protected AbstractProcess(Application app, Collection<KogitoWorkItemHandler> handlers, ProcessInstancesFactory factory) {
        this(new ConfiguredProcessServices((ProcessConfig)app.config().get(ProcessConfig.class)), handlers, factory);
        this.app = app;
    }

    protected AbstractProcess(ProcessRuntimeServiceProvider services, Collection<KogitoWorkItemHandler> handlers, ProcessInstancesFactory factory) {
        this.services = services;
        this.instances = new MapProcessInstances();
        this.processInstancesFactory = factory;
        KogitoWorkItemManager workItemManager = services.getKogitoWorkItemManager();
        for (KogitoWorkItemHandler handler : handlers) {
            workItemManager.registerWorkItemHandler(handler.getName(), handler);
        }
    }

    public String id() {
        return this.process().getId();
    }

    public String name() {
        return this.process().getName();
    }

    public T createModel() {
        return null;
    }

    public ProcessInstance<T> createInstance(String businessKey, Model m) {
        return this.createInstance(businessKey, m);
    }

    public abstract ProcessInstance<T> createInstance(WorkflowProcessInstance var1);

    public abstract ProcessInstance<T> createReadOnlyInstance(WorkflowProcessInstance var1);

    public ProcessInstances<T> instances() {
        return this.instances;
    }

    public <S> void send(Signal<S> signal) {
        this.instances().values(ProcessInstanceReadMode.MUTABLE).forEach(pi -> pi.send(signal));
    }

    public Process<T> configure() {
        this.registerListeners();
        if (this.isProcessFactorySet()) {
            this.instances = this.processInstancesFactory.createProcessInstances((Process)this);
        }
        return this;
    }

    protected void registerListeners() {
    }

    public void activate() {
        if (this.activated) {
            return;
        }
        this.configure();
        WorkflowProcessImpl p = (WorkflowProcessImpl)this.process();
        List<StartNode> startNodes = p.getTimerStart();
        if (startNodes != null && !startNodes.isEmpty()) {
            this.processRuntime = this.createProcessRuntime().getKogitoProcessRuntime();
            for (StartNode startNode : startNodes) {
                if (startNode == null || startNode.getTimer() == null) continue;
                String timerId = this.processRuntime.getJobsService().scheduleProcessJob(ProcessJobDescription.of((ExpirationTime)this.configureTimerInstance(startNode.getTimer()), (Process)this));
                this.startTimerInstances.add(timerId);
            }
        }
        this.activated = true;
    }

    public void deactivate() {
        for (String startTimerId : this.startTimerInstances) {
            this.processRuntime.getJobsService().cancelJob(startTimerId);
        }
        this.activated = false;
    }

    protected ExpirationTime configureTimerInstance(Timer timer) {
        switch (timer.getTimeType()) {
            case 2: {
                long[] repeatValues = DateTimeUtils.parseRepeatableDateTime(timer.getDelay());
                if (repeatValues.length == 3) {
                    int parsedReapedCount = (int)repeatValues[0];
                    if (parsedReapedCount <= -1) {
                        parsedReapedCount = Integer.MAX_VALUE;
                    }
                    return DurationExpirationTime.repeat((long)repeatValues[1], (Long)repeatValues[2], (Integer)parsedReapedCount);
                }
                if (repeatValues.length == 2) {
                    return DurationExpirationTime.repeat((long)repeatValues[0], (Long)repeatValues[1], (Integer)Integer.MAX_VALUE);
                }
                return DurationExpirationTime.repeat((long)repeatValues[0], (Long)repeatValues[0], (Integer)Integer.MAX_VALUE);
            }
            case 1: {
                long duration = DateTimeUtils.parseDuration(timer.getDelay());
                return DurationExpirationTime.repeat((long)duration);
            }
            case 3: {
                return ExactExpirationTime.of((String)timer.getDate());
            }
        }
        throw new UnsupportedOperationException("Not supported timer definition");
    }

    public abstract org.kie.api.definition.process.Process process();

    protected InternalProcessRuntime createProcessRuntime() {
        return new LightProcessRuntime(new LightProcessRuntimeContext(Collections.singletonList(this.process())), this.services);
    }

    protected boolean isProcessFactorySet() {
        return this.processInstancesFactory != null;
    }

    public void setProcessInstancesFactory(ProcessInstancesFactory processInstancesFactory) {
        this.processInstancesFactory = processInstancesFactory;
    }

    public EventListener eventListener() {
        return this.completionEventListener;
    }

    protected class CompletionEventListener
    implements EventListener {
        public void signalEvent(String type, Object event) {
            if (type.startsWith("processInstanceCompleted:")) {
                KogitoProcessInstance pi = (KogitoProcessInstance)event;
                if (!AbstractProcess.this.id().equals(pi.getProcessId()) && pi.getParentProcessInstanceStringId() != null) {
                    AbstractProcess.this.instances().findById(pi.getParentProcessInstanceStringId()).ifPresent(p -> p.send(Sig.of(type, event)));
                }
            }
        }

        public String[] getEventTypes() {
            return new String[0];
        }
    }
}

