/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.context.variable;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.instance.ContextInstanceContainer;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.context.AbstractContextInstance;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.instance.node.CompositeContextNodeInstance;
import org.kie.api.runtime.KieRuntime;
import org.kie.kogito.internal.process.event.KogitoProcessEventSupport;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.process.VariableViolationException;

public class VariableScopeInstance
extends AbstractContextInstance {
    private static final long serialVersionUID = 510L;
    private Map<String, Object> variables = new HashMap<String, Object>();
    private transient String variableIdPrefix = null;
    private transient String variableInstanceIdPrefix = null;

    @Override
    public String getContextType() {
        return "VariableScope";
    }

    public Object getVariable(String name) {
        Object value = this.variables.get(name);
        if (value != null) {
            return value;
        }
        if ("processInstanceId".equals(name) && this.getProcessInstance() != null) {
            return this.getProcessInstance().getStringId();
        }
        if ("parentProcessInstanceId".equals(name) && this.getProcessInstance() != null) {
            return this.getProcessInstance().getParentProcessInstanceStringId();
        }
        if (this.getProcessInstance() != null && this.getProcessInstance().getKnowledgeRuntime() != null && (value = this.getProcessInstance().getKnowledgeRuntime().getGlobal(name)) != null) {
            return value;
        }
        return null;
    }

    public Map<String, Object> getVariables() {
        return Collections.unmodifiableMap(this.variables);
    }

    public void setVariable(String name, Object value) {
        this.setVariable(null, name, value);
    }

    public void setVariable(KogitoNodeInstance nodeInstance, String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("The name of a variable may not be null!");
        }
        Object oldValue = this.getVariable(name);
        if (oldValue == null && value == null) {
            return;
        }
        if (oldValue != null && this.getVariableScope().isReadOnly(name)) {
            throw new VariableViolationException(this.getProcessInstance().getStringId(), name, "Variable '" + name + "' is already set and is marked as read only");
        }
        KogitoProcessEventSupport processEventSupport = ((InternalProcessRuntime)this.getProcessInstance().getKnowledgeRuntime().getProcessRuntime()).getProcessEventSupport();
        processEventSupport.fireBeforeVariableChanged((String)(this.variableIdPrefix == null ? "" : this.variableIdPrefix + ":") + name, (String)(this.variableInstanceIdPrefix == null ? "" : this.variableInstanceIdPrefix + ":") + name, oldValue, value, this.getVariableScope().tags(name), (KogitoProcessInstance)this.getProcessInstance(), nodeInstance, (KieRuntime)this.getProcessInstance().getKnowledgeRuntime());
        this.internalSetVariable(name, value);
        processEventSupport.fireAfterVariableChanged((String)(this.variableIdPrefix == null ? "" : this.variableIdPrefix + ":") + name, (String)(this.variableInstanceIdPrefix == null ? "" : this.variableInstanceIdPrefix + ":") + name, oldValue, value, this.getVariableScope().tags(name), (KogitoProcessInstance)this.getProcessInstance(), nodeInstance, (KieRuntime)this.getProcessInstance().getKnowledgeRuntime());
    }

    public void internalSetVariable(String name, Object value) {
        this.variables.put(name, value);
    }

    public VariableScope getVariableScope() {
        return (VariableScope)this.getContext();
    }

    @Override
    public void setContextInstanceContainer(ContextInstanceContainer contextInstanceContainer) {
        super.setContextInstanceContainer(contextInstanceContainer);
        for (Variable variable : this.getVariableScope().getVariables()) {
            if (variable.getValue() == null) continue;
            this.setVariable(variable.getName(), variable.getValue());
        }
        if (contextInstanceContainer instanceof CompositeContextNodeInstance) {
            this.variableIdPrefix = ((Node)((CompositeContextNodeInstance)contextInstanceContainer).getNode()).getUniqueId();
            this.variableInstanceIdPrefix = ((CompositeContextNodeInstance)contextInstanceContainer).getUniqueId();
        }
    }

    public void enforceRequiredVariables() {
        VariableScope variableScope = this.getVariableScope();
        for (Variable variable : variableScope.getVariables()) {
            if (!variableScope.isRequired(variable.getName()) || this.variables.containsKey(variable.getName())) continue;
            throw new VariableViolationException(this.getProcessInstance().getStringId(), variable.getName(), "Variable '" + variable.getName() + "' is required but not set");
        }
    }
}

