/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jbpm.process.instance.impl.humantask.HumanTaskHelper;
import org.jbpm.process.instance.impl.humantask.HumanTaskTransition;
import org.jbpm.util.JsonSchemaUtil;
import org.jbpm.workflow.instance.node.HumanTaskNodeInstance;
import org.kie.kogito.Application;
import org.kie.kogito.MapOutput;
import org.kie.kogito.MappableToModel;
import org.kie.kogito.Model;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessConfig;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.ProcessService;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.impl.Sig;
import org.kie.kogito.process.workitem.Attachment;
import org.kie.kogito.process.workitem.AttachmentInfo;
import org.kie.kogito.process.workitem.Comment;
import org.kie.kogito.process.workitem.HumanTaskWorkItem;
import org.kie.kogito.process.workitem.Policies;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.process.workitem.Transition;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.uow.UnitOfWorkManager;

public class ProcessServiceImpl
implements ProcessService {
    private final Application application;

    public ProcessServiceImpl(Application application) {
        this.application = application;
    }

    public <T extends Model> ProcessInstance<T> createProcessInstance(Process<T> process, String businessKey, T model, String startFromNodeId) {
        return (ProcessInstance)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            ProcessInstance pi = process.createInstance(businessKey, (Object)model);
            if (startFromNodeId != null) {
                pi.startFrom(startFromNodeId);
            } else {
                pi.start();
            }
            return pi;
        });
    }

    public <T extends Model> ProcessInstance<T> createProcessInstance(Process<T> process, T model, String startFromNodeId, String trigger, String kogitoReferenceId) {
        return (ProcessInstance)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            ProcessInstance pi = process.createInstance((Object)model);
            if (startFromNodeId != null) {
                pi.startFrom(startFromNodeId, kogitoReferenceId);
            } else {
                pi.start(trigger, kogitoReferenceId);
            }
            return pi;
        });
    }

    public <T extends MappableToModel<R>, R> List<R> getProcessInstanceOutput(Process<T> process) {
        return process.instances().values().stream().map(ProcessInstance::variables).map(MappableToModel::toModel).collect(Collectors.toList());
    }

    public <T extends MappableToModel<R>, R> Optional<R> findById(Process<T> process, String id) {
        return process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(ProcessInstance::variables).map(MappableToModel::toModel);
    }

    public <T extends MappableToModel<R>, R> Optional<R> delete(Process<T> process, String id) {
        return (Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> {
            pi.abort();
            return pi;
        }).map(ProcessInstance::checkError).map(ProcessInstance::variables).map(MappableToModel::toModel));
    }

    public <T extends MappableToModel<R>, R> Optional<R> update(Process<T> process, String id, T resource) {
        return (Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> (MappableToModel)pi.updateVariables((Object)resource)).map(MappableToModel::toModel));
    }

    public <T extends Model> Optional<List<WorkItem>> getTasks(Process<T> process, String id, String user, List<String> groups) {
        return process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> pi.workItems(HumanTaskNodeInstance.class::isInstance, Policies.of((String)user, (Collection)groups)));
    }

    public <T extends Model> Optional<WorkItem> signalTask(Process<T> process, String id, String taskNodeName, String taskName) {
        return (Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> {
            pi.send(Sig.of(taskNodeName, Collections.emptyMap()));
            return pi;
        }).map(pi -> this.getTaskByName((ProcessInstance)pi, taskName).orElse(null)));
    }

    public <T extends Model> Optional<WorkItem> getTaskByName(ProcessInstance<T> pi, String taskName) {
        return pi.workItems(new Policy[0]).stream().filter(wi -> wi.getName().equals(taskName)).findFirst();
    }

    public <T extends MappableToModel<R>, R> Optional<R> completeTask(Process<T> process, String id, String taskId, String phase, String user, List<String> groups, MapOutput taskModel) {
        return (Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(taskId, (Transition)HumanTaskTransition.withModel(phase, taskModel, Policies.of((String)user, (Collection)groups)));
            return pi;
        }).map(ProcessInstance::variables).map(MappableToModel::toModel));
    }

    public <T extends Model, R extends MapOutput> Optional<R> saveTask(Process<T> process, String id, String taskId, String user, List<String> groups, MapOutput model, Function<Map<String, Object>, R> mapper) {
        return ((Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> (Map)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.updateContent(wi, model), Policies.of((String)user, (Collection)groups))))).map(mapper::apply);
    }

    public <T extends MappableToModel<R>, R> Optional<R> taskTransition(Process<T> process, String id, String taskId, String phase, String user, List<String> groups, MapOutput model) {
        return (Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(taskId, (Transition)HumanTaskTransition.withModel(phase, model, Policies.of((String)user, (Collection)groups)));
            return ((MappableToModel)pi.variables()).toModel();
        }));
    }

    public <T extends MappableToModel<?>, R> Optional<R> getTask(Process<T> process, String id, String taskId, String user, List<String> groups, Function<WorkItem, R> mapper) {
        return process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> pi.workItem(taskId, Policies.of((String)user, (Collection)groups))).map(mapper::apply);
    }

    public <T extends MappableToModel<R>, R> Optional<R> abortTask(Process<T> process, String id, String taskId, String phase, String user, List<String> groups) {
        return (Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(taskId, (Transition)HumanTaskTransition.withoutModel(phase, Policies.of((String)user, (Collection)groups)));
            return ((MappableToModel)pi.variables()).toModel();
        }));
    }

    public <T extends Model> Optional<Comment> addComment(Process<T> process, String id, String taskId, String user, List<String> groups, String commentInfo) {
        return (Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> (Comment)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.addComment(wi, commentInfo, user), Policies.of((String)user, (Collection)groups))));
    }

    public <T extends Model> Optional<Comment> updateComment(Process<T> process, String id, String taskId, String commentId, String user, List<String> groups, String commentInfo) {
        return (Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> (Comment)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.updateComment(wi, commentId, commentInfo, user), Policies.of((String)user, (Collection)groups))));
    }

    public <T extends Model> Optional<Boolean> deleteComment(Process<T> process, String id, String taskId, String commentId, String user, List<String> groups) {
        return (Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> (Boolean)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.deleteComment(wi, commentId, user), Policies.of((String)user, (Collection)groups))));
    }

    public <T extends Model> Optional<Attachment> addAttachment(Process<T> process, String id, String taskId, String user, List<String> groups, AttachmentInfo attachmentInfo) {
        return (Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> (Attachment)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.addAttachment(wi, attachmentInfo, user), Policies.of((String)user, (Collection)groups))));
    }

    public <T extends Model> Optional<Attachment> updateAttachment(Process<T> process, String id, String taskId, String attachmentId, String user, List<String> groups, AttachmentInfo attachment) {
        return (Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> (Attachment)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.updateAttachment(wi, attachmentId, attachment, user), Policies.of((String)user, (Collection)groups))));
    }

    public <T extends Model> Optional<Boolean> deleteAttachment(Process<T> process, String id, String taskId, String attachmentId, String user, List<String> groups) {
        return (Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> (Boolean)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.deleteAttachment(wi, attachmentId, user), Policies.of((String)user, (Collection)groups))));
    }

    public <T extends Model> Optional<Attachment> getAttachment(Process<T> process, String id, String taskId, String attachmentId, String user, List<String> groups) {
        return process.instances().findById(id).map(pi -> HumanTaskHelper.findTask(pi, taskId, Policies.of((String)user, (Collection)groups))).map(HumanTaskWorkItem::getAttachments).map(attachments -> (Attachment)attachments.get(attachmentId));
    }

    public <T extends Model> Optional<Collection<Attachment>> getAttachments(Process<T> process, String id, String taskId, String user, List<String> groups) {
        return process.instances().findById(id).map(pi -> HumanTaskHelper.findTask(pi, taskId, Policies.of((String)user, (Collection)groups))).map(HumanTaskWorkItem::getAttachments).map(Map::values);
    }

    public <T extends Model> Optional<Comment> getComment(Process<T> process, String id, String taskId, String commentId, String user, List<String> groups) {
        return process.instances().findById(id).map(pi -> HumanTaskHelper.findTask(pi, taskId, Policies.of((String)user, (Collection)groups))).map(HumanTaskWorkItem::getComments).map(comments -> (Comment)comments.get(commentId));
    }

    public <T extends Model> Optional<Collection<Comment>> getComments(Process<T> process, String id, String taskId, String user, List<String> groups) {
        return process.instances().findById(id).map(pi -> HumanTaskHelper.findTask(pi, taskId, Policies.of((String)user, (Collection)groups))).map(HumanTaskWorkItem::getComments).map(Map::values);
    }

    public <T extends MappableToModel<R>, R> Optional<R> signalProcessInstance(Process<T> process, String id, Object data, String signalName) {
        return (Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> process.instances().findById(id).map(pi -> {
            pi.send(Sig.of(signalName, data));
            return ((MappableToModel)pi.checkError().variables()).toModel();
        }));
    }

    public <T extends Model> Map<String, Object> getSchemaAndPhases(Process<T> process, String id, String taskId, String taskName, String user, List<String> groups) {
        return JsonSchemaUtil.addPhases(process, ((ProcessConfig)this.application.config().get(ProcessConfig.class)).workItemHandlers().forName("Human Task"), id, taskId, Policies.of((String)user, groups), JsonSchemaUtil.load(Thread.currentThread().getContextClassLoader(), process.id(), taskName));
    }
}

