/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.event.EventMarshaller;
import org.kie.kogito.event.impl.DefaultEventConsumerFactory;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstances;
import org.kie.kogito.process.ProcessService;
import org.kie.kogito.services.event.AbstractProcessDataEvent;
import org.kie.kogito.services.event.EventConsumer;
import org.kie.kogito.services.event.EventConsumerFactory;
import org.kie.kogito.services.event.impl.DefaultEventMarshaller;
import org.kie.kogito.services.uow.CollectingUnitOfWorkFactory;
import org.kie.kogito.services.uow.DefaultUnitOfWorkManager;
import org.kie.kogito.uow.UnitOfWorkFactory;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class EventImplTest {
    private static EventConsumerFactory factory;
    private static EventMarshaller marshaller;
    private Process<DummyModel> process;
    private Application application;
    private ProcessService processService;
    private ExecutorService executor;
    private ProcessInstance<DummyModel> processInstance;
    private ProcessInstances<DummyModel> processInstances;

    @BeforeAll
    static void init() {
        factory = new DefaultEventConsumerFactory();
        marshaller = new DefaultEventMarshaller(new ObjectMapper());
    }

    @BeforeEach
    void setup() {
        this.application = (Application)Mockito.mock(Application.class);
        Mockito.when((Object)this.application.unitOfWorkManager()).thenReturn((Object)new DefaultUnitOfWorkManager((UnitOfWorkFactory)new CollectingUnitOfWorkFactory()));
        this.process = (Process)Mockito.mock(Process.class);
        this.processInstances = (ProcessInstances)Mockito.mock(ProcessInstances.class);
        this.processInstance = (ProcessInstance)Mockito.mock(ProcessInstance.class);
        Mockito.when((Object)this.process.instances()).thenReturn(this.processInstances);
        Mockito.when((Object)this.processInstances.findById(Mockito.anyString())).thenReturn(Optional.of(this.processInstance));
        Mockito.when((Object)this.process.createInstance((Object)((DummyModel)Mockito.any(DummyModel.class)))).thenReturn(this.processInstance);
        this.processService = (ProcessService)Mockito.mock(ProcessService.class);
        this.executor = Executors.newSingleThreadExecutor();
    }

    @AfterEach
    void close() {
        this.executor.shutdown();
    }

    @Test
    void testSigCloudEvent() {
        EventConsumer consumer = factory.get(this.processService, this.executor, DummyModel::new, true);
        String trigger = "dummyTopic";
        consumer.consume(this.application, this.process, (Object)new DummyCloudEvent(new DummyEvent("pepe"), "1"), "dummyTopic");
        ArgumentCaptor signal = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor processInstanceId = ArgumentCaptor.forClass(String.class);
        ((ProcessService)Mockito.verify((Object)this.processService, (VerificationMode)Mockito.times((int)1))).signalProcessInstance((Process)Mockito.any(Process.class), (String)processInstanceId.capture(), Mockito.any(DummyEvent.class), (String)signal.capture());
        Assertions.assertEquals((Object)"Message-dummyTopic", (Object)signal.getValue());
        Assertions.assertEquals((Object)"1", (Object)processInstanceId.getValue());
    }

    @Test
    void testCloudEvent() {
        EventConsumer consumer = factory.get(this.processService, this.executor, DummyModel::new, true);
        String trigger = "dummyTopic";
        consumer.consume(this.application, this.process, (Object)new DummyCloudEvent(new DummyEvent("pepe")), "dummyTopic");
        ArgumentCaptor signal = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor processInstanceId = ArgumentCaptor.forClass(String.class);
        ((ProcessService)Mockito.verify((Object)this.processService, (VerificationMode)Mockito.timeout((long)1500L).times(1))).createProcessInstance((Process)Mockito.any(Process.class), (Model)((DummyModel)Mockito.any(DummyModel.class)), (String)Mockito.isNull(), (String)signal.capture(), (String)processInstanceId.capture());
        Assertions.assertEquals((Object)"dummyTopic", (Object)signal.getValue());
        Assertions.assertEquals((Object)"1", (Object)processInstanceId.getValue());
    }

    @Test
    void testDataEvent() {
        EventConsumer consumer = factory.get(this.processService, this.executor, DummyModel::new, false);
        String trigger = "dummyTopic";
        consumer.consume(this.application, this.process, (Object)new DummyEvent("pepe"), "dummyTopic");
        ArgumentCaptor signal = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor processInstanceId = ArgumentCaptor.forClass(String.class);
        ((ProcessService)Mockito.verify((Object)this.processService, (VerificationMode)Mockito.timeout((long)1500L).times(1))).createProcessInstance((Process)Mockito.any(Process.class), (Model)((DummyModel)Mockito.any(DummyModel.class)), (String)Mockito.isNull(), (String)signal.capture(), (String)Mockito.isNull());
        Assertions.assertEquals((Object)"dummyTopic", (Object)signal.getValue());
    }

    @Test
    void testDataMarshaller() {
        DummyEvent dataEvent = new DummyEvent("pepe");
        Assertions.assertEquals((Object)"{\"dummyField\":\"pepe\"}", (Object)marshaller.marshall((Object)dataEvent));
    }

    @Test
    void testEventMarshaller() {
        DummyEvent dataEvent = new DummyEvent("pepe");
        String jsonString = marshaller.marshall((Object)dataEvent);
        Assertions.assertTrue((boolean)jsonString.contains("\"dummyField\":\"pepe\""));
    }

    @Test
    void testEventPayloadException() {
        EventConsumer consumer = factory.get(this.processService, this.executor, DummyModel::new, true);
        String trigger = "dummyTopic";
        String payload = "{ a = b }";
        Assertions.assertThrows(ClassCastException.class, () -> consumer.consume(this.application, this.process, (Object)"{ a = b }", "dummyTopic"));
    }

    private static class DummyCloudEvent
    extends AbstractProcessDataEvent<DummyEvent> {
        public DummyCloudEvent() {
        }

        public DummyCloudEvent(DummyEvent dummyEvent) {
            this(dummyEvent, null);
        }

        public DummyCloudEvent(DummyEvent dummyEvent, String referenceId) {
            super("dummyTopic", (Object)dummyEvent, "1", "1", "1", "1", "1", "1", null);
            this.kogitoReferenceId = referenceId;
        }
    }

    private static class DummyModel
    implements Model {
        private DummyEvent dummyEvent;

        public DummyModel fromMap(Map<String, Object> params) {
            this.dummyEvent = (DummyEvent)params.get("dummyEvent");
            return this;
        }

        public Map<String, Object> toMap() {
            return Collections.singletonMap("dummyEvent", this.dummyEvent);
        }

        public DummyModel(DummyEvent dummyEvent) {
            this.dummyEvent = dummyEvent;
        }

        public void update(Map<String, Object> params) {
            this.fromMap(params);
        }
    }

    private static class DummyEvent {
        private String dummyField;

        public DummyEvent() {
        }

        public DummyEvent(String dummyField) {
            this.dummyField = dummyField;
        }

        public String getDummyField() {
            return this.dummyField;
        }
    }
}

