/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.common.KogitoInternalAgenda;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.Activation;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.core.timer.BusinessCalendar;
import org.jbpm.process.core.timer.DateTimeUtils;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.process.instance.impl.Action;
import org.jbpm.util.PatternConstants;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.node.StateBasedNode;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.impl.ExtendedNodeInstanceImpl;
import org.jbpm.workflow.instance.impl.MVELProcessHelper;
import org.jbpm.workflow.instance.impl.NodeInstanceResolverFactory;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.EventBasedNodeInstanceInterface;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.rule.Match;
import org.kie.kogito.internal.process.event.KogitoEventListener;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.kie.kogito.jobs.DurationExpirationTime;
import org.kie.kogito.jobs.ExactExpirationTime;
import org.kie.kogito.jobs.ExpirationTime;
import org.kie.kogito.jobs.JobsService;
import org.kie.kogito.jobs.ProcessInstanceJobDescription;
import org.kie.kogito.timer.TimerInstance;
import org.mvel2.integration.VariableResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StateBasedNodeInstance
extends ExtendedNodeInstanceImpl
implements EventBasedNodeInstanceInterface,
KogitoEventListener {
    private static final long serialVersionUID = 510L;
    private static final Logger logger = LoggerFactory.getLogger(StateBasedNodeInstance.class);
    private List<String> timerInstances;

    public StateBasedNode getEventBasedNode() {
        return (StateBasedNode)this.getNode();
    }

    @Override
    public void internalTrigger(KogitoNodeInstance from, String type) {
        super.internalTrigger(from, type);
        if (this.getNodeInstanceContainer().getNodeInstance(this.getStringId()) == null) {
            return;
        }
        Map<Timer, DroolsAction> timers = this.getEventBasedNode().getTimers();
        if (timers != null) {
            this.addTimerListener();
            this.timerInstances = new ArrayList<String>(timers.size());
            JobsService jobService = ((KogitoProcessRuntime.Provider)this.getProcessInstance().getKnowledgeRuntime().getProcessRuntime()).getKogitoProcessRuntime().getJobsService();
            for (Timer timer : timers.keySet()) {
                ProcessInstanceJobDescription jobDescription = ProcessInstanceJobDescription.of((long)timer.getId(), (ExpirationTime)this.createTimerInstance(timer), (String)this.getProcessInstance().getStringId(), (String)this.getProcessInstance().getRootProcessInstanceId(), (String)this.getProcessInstance().getProcessId(), (String)this.getProcessInstance().getRootProcessId(), (String)Optional.ofNullable(from).map(KogitoNodeInstance::getStringId).orElse(null));
                this.timerInstances.add(jobService.scheduleProcessInstanceJob(jobDescription));
            }
        }
        if (this.getEventBasedNode().getBoundaryEvents() != null) {
            for (String name : this.getEventBasedNode().getBoundaryEvents()) {
                boolean isActive = ((KogitoInternalAgenda)this.getProcessInstance().getKnowledgeRuntime().getAgenda()).isRuleActiveInRuleFlowGroup("DROOLS_SYSTEM", name, this.getProcessInstance().getId());
                if (isActive) {
                    this.getProcessInstance().getKnowledgeRuntime().signalEvent(name, null);
                    continue;
                }
                this.addActivationListener();
            }
        }
        ((WorkflowProcessInstanceImpl)this.getProcessInstance()).addActivatingNodeId((String)this.getNode().getMetaData().get("UniqueId"));
    }

    @Override
    protected void configureSla() {
        TimerInstance timer;
        String slaDueDateExpression = (String)this.getNode().getMetaData().get("customSLADueDate");
        if (slaDueDateExpression != null && (timer = ((WorkflowProcessInstanceImpl)this.getProcessInstance()).configureSLATimer(slaDueDateExpression)) != null) {
            this.slaTimerId = timer.getId();
            this.slaDueDate = new Date(System.currentTimeMillis() + timer.getDelay());
            this.slaCompliance = 1;
            logger.debug("SLA for node instance {} is PENDING with due date {}", (Object)this.getStringId(), (Object)this.slaDueDate);
            this.addTimerListener();
        }
    }

    protected ExpirationTime createTimerInstance(Timer timer) {
        InternalKnowledgeRuntime kruntime = this.getProcessInstance().getKnowledgeRuntime();
        if (kruntime != null && kruntime.getEnvironment().get("jbpm.business.calendar") != null) {
            BusinessCalendar businessCalendar = (BusinessCalendar)kruntime.getEnvironment().get("jbpm.business.calendar");
            String delay = null;
            switch (timer.getTimeType()) {
                case 2: {
                    String tempDelay = this.resolveVariable(timer.getDelay());
                    String tempPeriod = this.resolveVariable(timer.getPeriod());
                    if (DateTimeUtils.isRepeatable(tempDelay)) {
                        String[] values = DateTimeUtils.parseISORepeatable(tempDelay);
                        String tempRepeatLimit = values[0];
                        tempDelay = values[1];
                        tempPeriod = values[2];
                        if (!tempRepeatLimit.isEmpty()) {
                            try {
                                int repeatLimit = Integer.parseInt(tempRepeatLimit);
                                if (repeatLimit <= -1) {
                                    repeatLimit = Integer.MAX_VALUE;
                                }
                                return DurationExpirationTime.repeat((long)businessCalendar.calculateBusinessTimeAsDuration(tempDelay), (Long)businessCalendar.calculateBusinessTimeAsDuration(tempPeriod), (Integer)repeatLimit);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                    long actualDelay = businessCalendar.calculateBusinessTimeAsDuration(tempDelay);
                    if (tempPeriod == null) {
                        return DurationExpirationTime.repeat((long)actualDelay, (Long)actualDelay, (Integer)Integer.MAX_VALUE);
                    }
                    return DurationExpirationTime.repeat((long)actualDelay, (Long)businessCalendar.calculateBusinessTimeAsDuration(tempPeriod), (Integer)Integer.MAX_VALUE);
                }
                case 1: {
                    delay = this.resolveVariable(timer.getDelay());
                    return DurationExpirationTime.repeat((long)businessCalendar.calculateBusinessTimeAsDuration(delay));
                }
                case 3: {
                    return ExactExpirationTime.of((String)timer.getDate());
                }
            }
            throw new UnsupportedOperationException("Not supported timer definition");
        }
        return this.configureTimerInstance(timer);
    }

    protected ExpirationTime configureTimerInstance(Timer timer) {
        String s = null;
        long duration = -1L;
        switch (timer.getTimeType()) {
            case 2: {
                if (timer.getPeriod() != null) {
                    long actualDelay = DateTimeUtils.parseDuration(this.resolveVariable(timer.getDelay()));
                    if (timer.getPeriod() == null) {
                        return DurationExpirationTime.repeat((long)actualDelay, (Long)actualDelay, (Integer)Integer.MAX_VALUE);
                    }
                    return DurationExpirationTime.repeat((long)actualDelay, (Long)DateTimeUtils.parseDuration(this.resolveVariable(timer.getPeriod())), (Integer)Integer.MAX_VALUE);
                }
                String resolvedDelay = this.resolveVariable(timer.getDelay());
                long[] repeatValues = null;
                try {
                    repeatValues = DateTimeUtils.parseRepeatableDateTime(timer.getDelay());
                }
                catch (RuntimeException e) {
                    repeatValues = DateTimeUtils.parseRepeatableDateTime(resolvedDelay);
                }
                if (repeatValues.length == 3) {
                    int parsedReapedCount = (int)repeatValues[0];
                    if (parsedReapedCount <= -1) {
                        parsedReapedCount = Integer.MAX_VALUE;
                    }
                    return DurationExpirationTime.repeat((long)repeatValues[1], (Long)repeatValues[2], (Integer)parsedReapedCount);
                }
                if (repeatValues.length == 2) {
                    return DurationExpirationTime.repeat((long)repeatValues[0], (Long)repeatValues[1], (Integer)Integer.MAX_VALUE);
                }
                return DurationExpirationTime.repeat((long)repeatValues[0], (Long)repeatValues[0], (Integer)Integer.MAX_VALUE);
            }
            case 1: {
                try {
                    duration = DateTimeUtils.parseDuration(timer.getDelay());
                }
                catch (RuntimeException e) {
                    s = this.resolveVariable(timer.getDelay());
                    duration = DateTimeUtils.parseDuration(s);
                }
                return DurationExpirationTime.after((long)duration);
            }
            case 3: {
                try {
                    return ExactExpirationTime.of((String)timer.getDate());
                }
                catch (RuntimeException e) {
                    s = this.resolveVariable(timer.getDate());
                    return ExactExpirationTime.of((String)s);
                }
            }
        }
        throw new UnsupportedOperationException("Not supported timer definition");
    }

    protected String resolveVariable(String s) {
        if (s == null) {
            return null;
        }
        HashMap<String, String> replacements = new HashMap<String, String>();
        Matcher matcher = PatternConstants.PARAMETER_MATCHER.matcher(s);
        while (matcher.find()) {
            String variableValueString;
            Object variableValue;
            String paramName = matcher.group(1);
            if (replacements.get(paramName) != null) continue;
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", paramName);
            if (variableScopeInstance != null) {
                variableValue = variableScopeInstance.getVariable(paramName);
                variableValueString = variableValue == null ? "" : variableValue.toString();
                replacements.put(paramName, variableValueString);
                continue;
            }
            try {
                variableValue = MVELProcessHelper.evaluator().eval(paramName, (VariableResolverFactory)new NodeInstanceResolverFactory(this));
                variableValueString = variableValue == null ? "" : variableValue.toString();
                replacements.put(paramName, variableValueString);
            }
            catch (Throwable t) {
                logger.error("Could not find variable scope for variable {}", (Object)paramName);
                logger.error("when trying to replace variable in processId for sub process {}", (Object)this.getNodeName());
                logger.error("Continuing without setting process id.");
            }
        }
        for (Map.Entry replacement : replacements.entrySet()) {
            s = s.replace("#{" + (String)replacement.getKey() + "}", (CharSequence)replacement.getValue());
        }
        return s;
    }

    protected void handleSLAViolation() {
        if (this.slaCompliance == 1) {
            InternalProcessRuntime processRuntime = (InternalProcessRuntime)this.getProcessInstance().getKnowledgeRuntime().getProcessRuntime();
            processRuntime.getProcessEventSupport().fireBeforeSLAViolated((KogitoProcessInstance)this.getProcessInstance(), (KogitoNodeInstance)this, (KieRuntime)this.getProcessInstance().getKnowledgeRuntime());
            logger.debug("SLA violated on node instance {}", (Object)this.getStringId());
            this.slaCompliance = 3;
            this.slaTimerId = null;
            processRuntime.getProcessEventSupport().fireAfterSLAViolated((KogitoProcessInstance)this.getProcessInstance(), (KogitoNodeInstance)this, (KieRuntime)this.getProcessInstance().getKnowledgeRuntime());
        }
    }

    public void signalEvent(String type, Object event) {
        if ("timerTriggered".equals(type)) {
            TimerInstance timerInstance = (TimerInstance)event;
            if (this.timerInstances != null && this.timerInstances.contains(timerInstance.getId())) {
                this.triggerTimer(timerInstance);
            } else if (timerInstance.getId().equals(this.slaTimerId)) {
                this.handleSLAViolation();
            }
        } else if (("slaViolation:" + this.getStringId()).equals(type)) {
            this.handleSLAViolation();
        } else if (type.equals(this.getActivationType()) && event instanceof MatchCreatedEvent) {
            String name = ((MatchCreatedEvent)event).getMatch().getRule().getName();
            if (this.checkProcessInstance((Activation)((MatchCreatedEvent)event).getMatch())) {
                ((MatchCreatedEvent)event).getKieRuntime().signalEvent(name, null);
            }
        }
    }

    private void triggerTimer(TimerInstance timerInstance) {
        for (Map.Entry<Timer, DroolsAction> entry : this.getEventBasedNode().getTimers().entrySet()) {
            if (entry.getKey().getId() != timerInstance.getTimerId()) continue;
            if (timerInstance.getRepeatLimit() == 0) {
                this.timerInstances.remove(timerInstance.getId());
            }
            this.executeAction((Action)entry.getValue().getMetaData("Action"));
            return;
        }
    }

    public String[] getEventTypes() {
        return new String[]{"timerTriggered", this.getActivationType()};
    }

    public void triggerCompleted() {
        this.triggerCompleted("DROOLS_DEFAULT", true);
    }

    @Override
    public void addEventListeners() {
        if (this.timerInstances != null && !this.timerInstances.isEmpty() || this.slaTimerId != null && !this.slaTimerId.trim().isEmpty()) {
            this.addTimerListener();
        }
        if (this.slaCompliance == 1) {
            this.getProcessInstance().addEventListener("slaViolation:" + this.getStringId(), this, true);
        }
    }

    protected void addTimerListener() {
        this.getProcessInstance().addEventListener("timerTriggered", this, false);
        this.getProcessInstance().addEventListener("timer", this, true);
        this.getProcessInstance().addEventListener("slaViolation:" + this.getStringId(), this, true);
    }

    @Override
    public void removeEventListeners() {
        this.getProcessInstance().removeEventListener("timerTriggered", this, false);
        this.getProcessInstance().removeEventListener("timer", this, true);
        this.getProcessInstance().removeEventListener("slaViolation:" + this.getStringId(), this, true);
    }

    @Override
    public void triggerCompleted(String type, boolean remove) {
        if (this.slaCompliance == 1) {
            this.slaCompliance = System.currentTimeMillis() > this.slaDueDate.getTime() ? 3 : 2;
        }
        this.cancelSlaTimer();
        ((NodeInstanceContainer)this.getNodeInstanceContainer()).setCurrentLevel(this.getLevel());
        this.cancelTimers();
        this.removeActivationListener();
        super.triggerCompleted(type, remove);
    }

    public List<String> getTimerInstances() {
        return this.timerInstances;
    }

    public void internalSetTimerInstances(List<String> timerInstances) {
        this.timerInstances = timerInstances;
    }

    @Override
    public void cancel() {
        if (this.slaCompliance == 1) {
            this.slaCompliance = System.currentTimeMillis() > this.slaDueDate.getTime() ? 3 : 4;
        }
        this.cancelSlaTimer();
        this.cancelTimers();
        this.removeEventListeners();
        this.removeActivationListener();
        super.cancel();
    }

    private void cancelTimers() {
        if (this.timerInstances != null) {
            JobsService jobService = ((InternalProcessRuntime)this.getProcessInstance().getKnowledgeRuntime().getProcessRuntime()).getJobsService();
            for (String id : this.timerInstances) {
                jobService.cancelJob(id);
            }
        }
    }

    private void cancelSlaTimer() {
        if (this.slaTimerId != null && !this.slaTimerId.trim().isEmpty()) {
            JobsService jobService = ((InternalProcessRuntime)this.getProcessInstance().getKnowledgeRuntime().getProcessRuntime()).getJobsService();
            jobService.cancelJob(this.slaTimerId);
            logger.debug("SLA Timer {} has been canceled", (Object)this.slaTimerId);
        }
    }

    protected String getActivationType() {
        return "RuleFlowStateEvent-" + this.getProcessInstance().getProcessId();
    }

    private void addActivationListener() {
        this.getProcessInstance().addEventListener(this.getActivationType(), this, true);
    }

    private void removeActivationListener() {
        this.getProcessInstance().removeEventListener(this.getActivationType(), this, true);
    }

    protected boolean checkProcessInstance(Activation activation) {
        Map declarations = activation.getSubRule().getOuterDeclarations();
        for (Declaration declaration : declarations.values()) {
            Object value;
            if (!"processInstance".equals(declaration.getIdentifier()) && !"org.kie.api.runtime.process.WorkflowProcessInstance".equals(declaration.getTypeName()) || !((value = declaration.getValue((ReteEvaluator)this.getProcessInstance().getKnowledgeRuntime(), activation.getTuple().get(declaration).getObject())) instanceof ProcessInstance)) continue;
            return ((ProcessInstance)value).getStringId().equals(this.getProcessInstance().getStringId());
        }
        return true;
    }

    protected boolean checkDeclarationMatch(Match match, String matchVariable) {
        if (matchVariable == null) {
            return true;
        }
        Object dec = match.getDeclarationIds().contains("$" + matchVariable) ? match.getDeclarationValue("$" + matchVariable) : match.getDeclarationValue(matchVariable);
        Object var = this.getVariable(matchVariable);
        return var.equals(dec);
    }

    protected void mapDynamicOutputData(Map<String, Object> results) {
        if (results != null && !results.isEmpty()) {
            VariableScope variableScope = (VariableScope)((ContextContainer)this.getProcessInstance().getProcess()).getDefaultContext("VariableScope");
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.getProcessInstance().getContextInstance("VariableScope");
            for (Map.Entry<String, Object> result : results.entrySet()) {
                String variableName = result.getKey();
                Variable variable = variableScope.findVariable(variableName);
                if (variable == null) continue;
                variableScopeInstance.getVariableScope().validateVariable(this.getProcessInstance().getProcessName(), variableName, result.getValue());
                variableScopeInstance.setVariable(this, variableName, result.getValue());
            }
        }
    }

    public Map<String, String> extractTimerEventInformation() {
        if (this.getTimerInstances() != null) {
            for (String id : this.getTimerInstances()) {
                String[] ids = id.split("_");
                for (Timer entry : this.getEventBasedNode().getTimers().keySet()) {
                    if (entry.getId() != Long.valueOf(ids[1]).longValue()) continue;
                    HashMap<String, String> properties = new HashMap<String, String>();
                    properties.put("TimerID", id);
                    properties.put("Delay", entry.getDelay());
                    properties.put("Period", entry.getPeriod());
                    properties.put("Date", entry.getDate());
                    return properties;
                }
            }
        }
        return null;
    }
}

