/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.event;

import java.io.Serializable;
import java.util.function.Function;
import org.jbpm.process.core.correlation.CorrelationInstance;
import org.jbpm.process.core.correlation.CorrelationManager;
import org.jbpm.process.core.event.EventFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventTypeFilter
implements EventFilter,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(EventTypeFilter.class);
    private static final long serialVersionUID = 510L;
    protected String type;
    private String messageRef;
    private CorrelationManager correlationManager;

    @Override
    public boolean isCorrelated() {
        return this.messageRef != null;
    }

    public void setCorrelationManager(CorrelationManager correlationManager) {
        this.correlationManager = correlationManager;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return "Event filter: [" + this.type + "]";
    }

    @Override
    public boolean acceptsEvent(String type, Object event, Function<String, Object> resolver) {
        if (resolver == null) {
            return this.type != null && this.type.equals(type);
        }
        if (this.type != null && this.type.equals(type)) {
            if (this.correlationManager != null && this.correlationManager.isSubscribe(this.messageRef)) {
                if (event == null) {
                    logger.debug("This event is subscribed to a message ref {}", (Object)type);
                    return false;
                }
                CorrelationInstance messageCorrelation = this.correlationManager.computeCorrelationInstance(this.messageRef, event);
                CorrelationInstance processCorrelation = this.correlationManager.computeSubscription(this.messageRef, resolver);
                logger.debug("The event type {} is correlated, computing correlations. Message correlation is {}; process correlation is: {} ", new Object[]{type, messageCorrelation, processCorrelation});
                return messageCorrelation.equals(processCorrelation);
            }
            return true;
        }
        String resolvedType = (String)resolver.apply(this.type);
        return resolvedType != null && resolvedType.equals(type);
    }

    public void setMessageRef(String messageRef) {
        this.messageRef = messageRef;
    }
}

