/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ruleflow.core.factory;

import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.instance.impl.Action;
import org.jbpm.ruleflow.core.RuleFlowNodeContainerFactory;
import org.jbpm.ruleflow.core.factory.AbstractCompositeNodeFactory;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.impl.DataDefinition;
import org.jbpm.workflow.core.node.ForEachNode;

public class ForEachNodeFactory<T extends RuleFlowNodeContainerFactory<T, ?>>
extends AbstractCompositeNodeFactory<ForEachNodeFactory<T>, T> {
    public static final String METHOD_COLLECTION_EXPRESSION = "collectionExpression";
    public static final String METHOD_OUTPUT_COLLECTION_EXPRESSION = "outputCollectionExpression";
    public static final String METHOD_INPUT_VARIABLE = "variable";
    public static final String METHOD_OUTPUT_VARIABLE = "outputVariable";
    public static final String METHOD_OUTPUT_TEMP = "tempVariable";
    public static final String METHOD_SEQUENTIAL = "sequential";

    public ForEachNodeFactory(T nodeContainerFactory, NodeContainer nodeContainer, long id) {
        super(nodeContainerFactory, nodeContainer, new ForEachNode(), (Object)id);
    }

    protected ForEachNode getForEachNode() {
        return (ForEachNode)this.node;
    }

    public ForEachNodeFactory<T> collectionExpression(String collectionExpression) {
        this.getForEachNode().setCollectionExpression(collectionExpression);
        this.getForEachNode().getMultiInstanceSpecification().setLoopDataInputRef(DataDefinition.toExpression(collectionExpression));
        return this;
    }

    @Override
    public ForEachNodeFactory<T> variable(String variableName, DataType dataType) {
        return this.variable(variableName, variableName, dataType);
    }

    public ForEachNodeFactory<T> variable(String varRef, String variableName, DataType dataType) {
        this.getForEachNode().setInputRef(variableName);
        this.getForEachNode().addContextVariable(varRef, variableName, dataType);
        this.getForEachNode().getMultiInstanceSpecification().setInputDataItem(new DataDefinition(varRef, variableName, dataType.getStringType()));
        return this;
    }

    public ForEachNodeFactory<T> outputCollectionExpression(String collectionExpression) {
        this.getForEachNode().setOutputCollectionExpression(collectionExpression);
        this.getForEachNode().getMultiInstanceSpecification().setLoopDataOutputRef(DataDefinition.toExpression(collectionExpression));
        return this;
    }

    public ForEachNodeFactory<T> expressionLanguage(String exprLanguage) {
        this.getForEachNode().setExpressionLanguage(exprLanguage);
        return this;
    }

    public ForEachNodeFactory<T> completionAction(Action completionAction) {
        this.getForEachNode().setCompletionAction(completionAction);
        return this;
    }

    public ForEachNodeFactory<T> outputVariable(String variableName, DataType dataType) {
        return this.outputVariable(variableName, variableName, dataType);
    }

    public ForEachNodeFactory<T> tempVariable(String variableName, DataType dataType) {
        this.getForEachNode().addContextVariable(variableName, variableName, dataType);
        return this;
    }

    public ForEachNodeFactory<T> tempVariable(String varRef, String variableName, DataType dataType) {
        this.getForEachNode().addContextVariable(varRef, variableName, dataType);
        return this;
    }

    public ForEachNodeFactory<T> outputVariable(String varRef, String variableName, DataType dataType) {
        this.getForEachNode().setOutputRef(variableName);
        this.getForEachNode().addContextVariable(varRef, variableName, dataType);
        this.getForEachNode().getMultiInstanceSpecification().setOutputDataItem(new DataDefinition(varRef, variableName, dataType.getStringType()));
        return this;
    }

    public ForEachNodeFactory<T> waitForCompletion(boolean waitForCompletion) {
        this.getForEachNode().setWaitForCompletion(waitForCompletion);
        return this;
    }

    public ForEachNodeFactory<T> sequential(boolean sequential) {
        this.getForEachNode().setSequential(sequential);
        return this;
    }
}

