/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.core.node;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Supplier;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.context.AbstractContext;
import org.jbpm.process.core.impl.ContextContainerImpl;
import org.jbpm.workflow.core.node.RuleUnitFactory;
import org.jbpm.workflow.core.node.StateBasedNode;
import org.kie.api.definition.process.Connection;
import org.kie.api.runtime.KieRuntime;
import org.kie.kogito.decision.DecisionModel;
import org.kie.kogito.rules.RuleUnitData;

public class RuleSetNode
extends StateBasedNode
implements ContextContainer {
    private static final long serialVersionUID = 510L;
    public static final String DRL_LANG = "http://www.jboss.org/drools/rule";
    public static final String RULE_UNIT_LANG = "http://www.jboss.org/drools/rule-unit";
    public static final String DMN_LANG = "http://www.jboss.org/drools/dmn";
    private String language = "http://www.jboss.org/drools/rule";
    private ContextContainer contextContainer = new ContextContainerImpl();
    private RuleType ruleType;
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private Supplier<DecisionModel> decisionModel;
    private Supplier<KieRuntime> kieRuntime;
    private RuleUnitFactory<RuleUnitData> ruleUnitFactory;

    public void setRuleType(RuleType ruleType) {
        this.ruleType = ruleType;
    }

    public RuleType getRuleType() {
        return this.ruleType;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public Supplier<DecisionModel> getDecisionModel() {
        return this.decisionModel;
    }

    public void setDecisionModel(Supplier<DecisionModel> decisionModel) {
        this.decisionModel = decisionModel;
    }

    public Supplier<KieRuntime> getKieRuntime() {
        return this.kieRuntime;
    }

    public RuleUnitFactory<RuleUnitData> getRuleUnitFactory() {
        return this.ruleUnitFactory;
    }

    public void setRuleUnitFactory(RuleUnitFactory<?> ruleUnitFactory) {
        this.ruleUnitFactory = ruleUnitFactory;
    }

    public void setKieRuntime(Supplier<KieRuntime> kieRuntime) {
        this.kieRuntime = kieRuntime;
    }

    @Override
    public void validateAddIncomingConnection(String type, Connection connection) {
        super.validateAddIncomingConnection(type, connection);
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("This type of node [" + connection.getTo().getMetaData().get("UniqueId") + ", " + connection.getTo().getName() + "] only accepts default incoming connection type!");
        }
        if (this.getFrom() != null && !"true".equals(System.getProperty("jbpm.enable.multi.con"))) {
            throw new IllegalArgumentException("This type of node [" + connection.getTo().getMetaData().get("UniqueId") + ", " + connection.getTo().getName() + "] cannot have more than one incoming connection!");
        }
    }

    @Override
    public void validateAddOutgoingConnection(String type, Connection connection) {
        super.validateAddOutgoingConnection(type, connection);
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("This type of node [" + connection.getFrom().getMetaData().get("UniqueId") + ", " + connection.getFrom().getName() + "] only accepts default outgoing connection type!");
        }
        if (this.getTo() != null && !"true".equals(System.getProperty("jbpm.enable.multi.con"))) {
            throw new IllegalArgumentException("This type of node [" + connection.getFrom().getMetaData().get("UniqueId") + ", " + connection.getFrom().getName() + "] cannot have more than one outgoing connection!");
        }
    }

    public Map<String, Object> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public void setParameter(String param, Object value) {
        this.parameters.put(param, value);
    }

    public Object getParameter(String param) {
        return this.parameters.get(param);
    }

    public Object removeParameter(String param) {
        return this.parameters.remove(param);
    }

    public boolean isDMN() {
        return DMN_LANG.equals(this.language);
    }

    @Override
    public List<Context> getContexts(String contextType) {
        return this.contextContainer.getContexts(contextType);
    }

    @Override
    public void addContext(Context context) {
        ((AbstractContext)context).setContextContainer(this);
        this.contextContainer.addContext(context);
    }

    @Override
    public Context getContext(String contextType, long id) {
        return this.contextContainer.getContext(contextType, id);
    }

    @Override
    public void setDefaultContext(Context context) {
        ((AbstractContext)context).setContextContainer(this);
        this.contextContainer.setDefaultContext(context);
    }

    @Override
    public Context getDefaultContext(String contextType) {
        return this.contextContainer.getDefaultContext(contextType);
    }

    @Override
    public Context getContext(String contextId) {
        Context context = this.getDefaultContext(contextId);
        if (context != null) {
            return context;
        }
        return super.getContext(contextId);
    }

    public static abstract class RuleType
    implements Serializable {
        private static final String UNIT_RULEFLOW_PREFIX = "unit:";
        protected String name;

        public static RuleType of(String name, String language) {
            if (language.equals(RuleSetNode.DRL_LANG)) {
                return RuleType.parseRuleFlowGroup(name);
            }
            if (language.equals(RuleSetNode.RULE_UNIT_LANG)) {
                return RuleType.ruleUnit(name);
            }
            throw new IllegalArgumentException("Unsupported language " + language);
        }

        private static RuleType parseRuleFlowGroup(String name) {
            if (name.startsWith(UNIT_RULEFLOW_PREFIX)) {
                String unitId = name.substring(UNIT_RULEFLOW_PREFIX.length());
                return RuleType.ruleUnit(unitId);
            }
            return RuleType.ruleFlowGroup(name);
        }

        public static RuleFlowGroup ruleFlowGroup(String name) {
            return new RuleFlowGroup(name);
        }

        public static RuleUnit ruleUnit(String name) {
            return new RuleUnit(name);
        }

        public static Decision decision(String namespace, String model, String decision) {
            return new Decision(namespace, model, decision);
        }

        private RuleType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean isRuleFlowGroup() {
            return false;
        }

        public boolean isRuleUnit() {
            return false;
        }

        public boolean isDecision() {
            return false;
        }

        public static class Decision
        extends RuleType {
            private String namespace;
            private String decision;

            private Decision(String namespace, String model, String decision) {
                super(model);
                this.namespace = namespace;
                this.decision = decision;
            }

            @Override
            public boolean isDecision() {
                return true;
            }

            public String getNamespace() {
                return this.namespace;
            }

            public String getModel() {
                return this.getName();
            }

            public String getDecision() {
                return this.decision;
            }

            public String toString() {
                return new StringJoiner(", ", Decision.class.getSimpleName() + "[", "]").add("namespace='" + this.namespace + "'").add("model='" + this.name + "'").add("decision='" + this.decision + "'").toString();
            }
        }

        public static class RuleUnit
        extends RuleType {
            private RuleUnit(String name) {
                super(name);
            }

            @Override
            public boolean isRuleUnit() {
                return true;
            }

            public String toString() {
                return new StringJoiner(", ", RuleUnit.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").toString();
            }
        }

        public static class RuleFlowGroup
        extends RuleType {
            private RuleFlowGroup(String name) {
                super(name);
            }

            @Override
            public boolean isRuleFlowGroup() {
                return true;
            }

            public String toString() {
                return new StringJoiner(", ", RuleFlowGroup.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").toString();
            }
        }
    }
}

