/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jbpm.process.core.ParameterDefinition;
import org.jbpm.process.core.Work;
import org.jbpm.process.instance.impl.humantask.DeadlineHelper;
import org.jbpm.process.instance.impl.humantask.DeadlineInfo;
import org.jbpm.process.instance.impl.humantask.Reassignment;

public class WorkImpl
implements Work,
Serializable {
    private static final long serialVersionUID = 510L;
    private String name;
    private Map<String, Object> parameters = new LinkedHashMap<String, Object>();
    private Map<String, ParameterDefinition> parameterDefinitions = new LinkedHashMap<String, ParameterDefinition>();
    private Collection<DeadlineInfo<Map<String, Object>>> startDeadlines;
    private Collection<DeadlineInfo<Map<String, Object>>> endDeadlines;
    private Collection<DeadlineInfo<Reassignment>> startReassigments;
    private Collection<DeadlineInfo<Reassignment>> endReassigments;
    private static final String NOT_STARTED = "NotStartedNotify";
    private static final String NOT_COMPLETED = "NotCompletedNotify";
    private static final String NOT_STARTED_ASSIGN = "NotStartedReassign";
    private static final String NOT_COMPLETED_ASSIGN = "NotCompletedReassign";
    private static final Set<String> META_NAMES = new HashSet<String>();

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setParameter(String name, Object value) {
        if (name == null) {
            throw new NullPointerException("Parameter name is null");
        }
        this.parameters.put(name, value);
    }

    @Override
    public void setParameters(Map<String, Object> parameters) {
        if (parameters == null) {
            throw new NullPointerException();
        }
        this.parameters = new HashMap<String, Object>(parameters);
    }

    @Override
    public Object getParameter(String name) {
        if (name == null) {
            throw new NullPointerException("Parameter name is null");
        }
        return this.parameters.get(name);
    }

    @Override
    public Map<String, Object> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public String toString() {
        return "Work " + this.name;
    }

    @Override
    public void setParameterDefinitions(Set<ParameterDefinition> parameterDefinitions) {
        this.parameterDefinitions.clear();
        for (ParameterDefinition parameterDefinition : parameterDefinitions) {
            this.addParameterDefinition(parameterDefinition);
        }
    }

    @Override
    public void addParameterDefinition(ParameterDefinition parameterDefinition) {
        this.parameterDefinitions.put(parameterDefinition.getName(), parameterDefinition);
    }

    @Override
    public Set<ParameterDefinition> getParameterDefinitions() {
        return new LinkedHashSet<ParameterDefinition>(this.parameterDefinitions.values());
    }

    @Override
    public String[] getParameterNames() {
        return this.parameterDefinitions.keySet().toArray(new String[this.parameterDefinitions.size()]);
    }

    @Override
    public ParameterDefinition getParameterDefinition(String name) {
        return this.parameterDefinitions.get(name);
    }

    @Override
    public Collection<DeadlineInfo<Map<String, Object>>> getNotStartedDeadlines() {
        if (this.startDeadlines == null) {
            this.startDeadlines = DeadlineHelper.parseDeadlines(this.getParameter(NOT_STARTED));
        }
        return this.startDeadlines;
    }

    @Override
    public Collection<DeadlineInfo<Map<String, Object>>> getNotCompletedDeadlines() {
        if (this.endDeadlines == null) {
            this.endDeadlines = DeadlineHelper.parseDeadlines(this.getParameter(NOT_COMPLETED));
        }
        return this.endDeadlines;
    }

    @Override
    public Set<String> getMetaParameters() {
        return META_NAMES;
    }

    @Override
    public Collection<DeadlineInfo<Reassignment>> getNotStartedReassignments() {
        if (this.startReassigments == null) {
            this.startReassigments = DeadlineHelper.parseReassignments(this.getParameter(NOT_STARTED_ASSIGN));
        }
        return this.startReassigments;
    }

    @Override
    public Collection<DeadlineInfo<Reassignment>> getNotCompletedReassigments() {
        if (this.endReassigments == null) {
            this.endReassigments = DeadlineHelper.parseReassignments(this.getParameter(NOT_COMPLETED_ASSIGN));
        }
        return this.endReassigments;
    }

    static {
        META_NAMES.add(NOT_STARTED);
        META_NAMES.add(NOT_COMPLETED);
        META_NAMES.add(NOT_STARTED_ASSIGN);
        META_NAMES.add(NOT_COMPLETED_ASSIGN);
    }
}

