/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.context.exception;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.context.AbstractContext;
import org.jbpm.process.core.context.exception.ExceptionHandler;
import org.jbpm.process.core.context.exception.ExceptionHandlerPolicy;
import org.jbpm.process.core.context.exception.ExceptionHandlerPolicyFactory;

public class ExceptionScope
extends AbstractContext {
    private static final long serialVersionUID = 510L;
    public static final String EXCEPTION_SCOPE = "ExceptionScope";
    protected Map<String, ExceptionHandler> exceptionHandlers = new HashMap<String, ExceptionHandler>();

    @Override
    public String getType() {
        return EXCEPTION_SCOPE;
    }

    public void setExceptionHandler(String exception, ExceptionHandler exceptionHandler) {
        this.exceptionHandlers.put(exception, exceptionHandler);
    }

    public ExceptionHandler getExceptionHandler(String exception) {
        ExceptionHandler result = this.exceptionHandlers.get(exception);
        if (result == null) {
            result = this.exceptionHandlers.get(null);
        }
        return result;
    }

    public ExceptionHandler getExceptionHandler(Throwable exception) {
        Class<?> exceptionClass = exception.getClass();
        ExceptionHandler handler = this.exceptionHandlers.get(exceptionClass.getName());
        if (handler == null) {
            Collection<ExceptionHandlerPolicy> policies = ExceptionHandlerPolicyFactory.getHandlerPolicies();
            handler = this.exceptionHandlers.entrySet().stream().filter(e -> this.test(policies, (String)e.getKey(), exception)).findFirst().map(Map.Entry::getValue).orElse(null);
        }
        if (handler == null) {
            handler = this.exceptionHandlers.get(null);
        }
        return handler;
    }

    private boolean test(Collection<ExceptionHandlerPolicy> policies, String className, Throwable exception) {
        if (className == null) {
            return false;
        }
        Iterator<ExceptionHandlerPolicy> iter = policies.iterator();
        boolean found = false;
        while (!found && iter.hasNext()) {
            found = iter.next().test(className, exception);
        }
        return found;
    }

    public void removeExceptionHandler(String exception) {
        this.exceptionHandlers.remove(exception);
    }

    public Map<String, ExceptionHandler> getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    public void setExceptionHandlers(Map<String, ExceptionHandler> exceptionHandlers) {
        if (exceptionHandlers == null) {
            throw new IllegalArgumentException("Exception handlers are null");
        }
        this.exceptionHandlers = exceptionHandlers;
    }

    @Override
    public Context resolveContext(Object param) {
        if (param instanceof String) {
            return this.getExceptionHandler((String)param) == null ? null : this;
        }
        if (param instanceof Throwable) {
            return this.getExceptionHandler((Throwable)param) == null ? null : this;
        }
        throw new IllegalArgumentException("ExceptionScopes can only resolve exception names: " + param);
    }
}

