/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.transformation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.jbpm.process.core.transformation.JsonResolver;
import org.junit.jupiter.api.Test;

public class JsonResolverTest {
    private JsonResolver resolver = new JsonResolver();

    @Test
    void testResolveItemsWithoutJsonAnnotation() {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("parent", new Parent());
        items.put("parent2", new Parent());
        items.put("child", new Child());
        items.put("string", "value");
        Map output = this.resolver.resolveOnlyAnnotatedItems(items);
        Assertions.assertThat(output.get("parent")).isExactlyInstanceOf(Parent.class);
        Assertions.assertThat(output.get("parent2")).isExactlyInstanceOf(Parent.class);
        Assertions.assertThat(output.get("child")).isExactlyInstanceOf(Child.class);
        Assertions.assertThat(output.get("string")).isEqualTo((Object)"value");
    }

    @Test
    void testResolveItemsWithJsonAnnotation() {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("parent", new Parent());
        items.put("parent2", new ParentJson());
        items.put("string", "value");
        Map output = this.resolver.resolveOnlyAnnotatedItems(items);
        Assertions.assertThat(output.get("parent")).isExactlyInstanceOf(Parent.class);
        Assertions.assertThat(output.get("parent2")).isInstanceOf(Map.class);
        Assertions.assertThat(output.get("string")).isEqualTo((Object)"value");
    }

    @Test
    void testResolveItemsWithNestedJsonAnnotation() {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("parent", new Parent());
        items.put("parent2", new ParentChildJson());
        items.put("string", "value");
        Map output = this.resolver.resolveOnlyAnnotatedItems(items);
        Assertions.assertThat(output.get("parent")).isExactlyInstanceOf(Parent.class);
        Assertions.assertThat(output.get("parent2")).isInstanceOf(Map.class);
        Assertions.assertThat(output.get("string")).isEqualTo((Object)"value");
    }

    @Test
    void testResolveAll() {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("parent", new Parent());
        items.put("parent2", new ParentChildJson());
        items.put("child", new Child());
        items.put("child2", new ChildJson());
        items.put("string", "value");
        Map output = this.resolver.resolveAll(items);
        Assertions.assertThat(output.get("parent")).isInstanceOf(Map.class);
        Assertions.assertThat(output.get("parent2")).isInstanceOf(Map.class);
        Assertions.assertThat(output.get("child")).isInstanceOf(Map.class);
        Assertions.assertThat(output.get("child2")).isInstanceOf(Map.class);
        Assertions.assertThat(output.get("string")).isEqualTo((Object)"value");
    }

    @Test
    void testDate() {
        LocalDate localDate = LocalDate.of(2021, 12, 21);
        Map r = this.resolver.resolveAll(Map.of("date", localDate));
        Assertions.assertThat(r.get("date")).isEqualTo(List.of(Integer.valueOf(2021), Integer.valueOf(12), Integer.valueOf(21)));
    }

    public static class ParentChildJson {
        private String id;
        private String age;
        private ChildJson child;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getAge() {
            return this.age;
        }

        public void setAge(String age) {
            this.age = age;
        }

        public ChildJson getChild() {
            return this.child;
        }

        public void setChild(ChildJson child) {
            this.child = child;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ChildJson {
        private String id;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    public static class ParentJson {
        @JsonProperty(value="User Identifier")
        private String id;
        @JsonIgnore
        private String age;
        private Child child;

        public String getAge() {
            return this.age;
        }

        public void setAge(String age) {
            this.age = age;
        }

        public Child getChild() {
            return this.child;
        }

        public void setChild(Child child) {
            this.child = child;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    public static class Child {
        private String id;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    public static class Parent {
        private String id;
        private String age;
        private Child child;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getAge() {
            return this.age;
        }

        public void setAge(String age) {
            this.age = age;
        }

        public Child getChild() {
            return this.child;
        }

        public void setChild(Child child) {
            this.child = child;
        }
    }
}

