/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.datatype.impl.coverter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jbpm.process.core.datatype.impl.coverter.CloneHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CloneHelperTest {
    @Test
    void testCloneable() {
        CloneableCollectionHolder<Integer> toClone = new CloneableCollectionHolder<Integer>(Arrays.asList(1, 2, 3, 4));
        CollectionHolder cloned = (CollectionHolder)CloneHelper.clone(toClone);
        Assertions.assertNotSame(toClone.getCollection(), cloned.getCollection());
        Assertions.assertEquals(toClone.getCollection(), cloned.getCollection());
    }

    @Test
    void testCopyConstructor() {
        CopyCollectionHolder<Integer> toClone = new CopyCollectionHolder<Integer>(Arrays.asList(1, 2, 3, 4));
        CollectionHolder cloned = (CollectionHolder)CloneHelper.clone(toClone);
        Assertions.assertNotSame(toClone.getCollection(), cloned.getCollection());
        Assertions.assertEquals(toClone.getCollection(), cloned.getCollection());
    }

    @Test
    void testDefault() {
        CollectionHolder<Integer> toClone = new CollectionHolder<Integer>(Arrays.asList(1, 2, 3, 4));
        CollectionHolder cloned = (CollectionHolder)CloneHelper.clone(toClone);
        Assertions.assertSame(toClone.getCollection(), cloned.getCollection());
    }

    @Test
    void testCloneableError() {
        DumbCloneableCollectionHolder<Integer> toClone = new DumbCloneableCollectionHolder<Integer>(Arrays.asList(1, 2, 3, 4));
        Assertions.assertThrows(IllegalStateException.class, () -> CloneHelper.clone((Object)toClone));
    }

    @Test
    void testCopyError() {
        DumbCopyCollectionHolder<Integer> toClone = new DumbCopyCollectionHolder<Integer>(Arrays.asList(1, 2, 3, 4));
        Assertions.assertThrows(IllegalStateException.class, () -> CloneHelper.clone((Object)toClone));
    }

    public static class CopyCollectionHolder<T>
    extends CollectionHolder<T> {
        public CopyCollectionHolder(Collection<T> collection) {
            super(collection);
        }

        public CopyCollectionHolder(CopyCollectionHolder<T> collection) {
            super(new ArrayList(collection.getCollection()));
        }
    }

    public static class DumbCopyCollectionHolder<T>
    extends CollectionHolder<T> {
        public DumbCopyCollectionHolder(Collection<T> collection) {
            super(collection);
        }

        public DumbCopyCollectionHolder(CollectionHolder<T> collection) {
            super(new ArrayList<T>(collection.getCollection()));
            throw new RuntimeException();
        }
    }

    public static class DumbCloneableCollectionHolder<T>
    extends CollectionHolder<T>
    implements Cloneable {
        public DumbCloneableCollectionHolder(Collection<T> collection) {
            super(collection);
        }

        public Object clone() {
            throw new UnsupportedOperationException();
        }
    }

    public static class CloneableCollectionHolder<T>
    extends CollectionHolder<T>
    implements Cloneable {
        public CloneableCollectionHolder(Collection<T> collection) {
            super(collection);
        }

        public Object clone() {
            return new CloneableCollectionHolder(new ArrayList(super.getCollection()));
        }
    }

    public static class CollectionHolder<T> {
        private final Collection<T> collection;

        public Collection<T> getCollection() {
            return this.collection;
        }

        public CollectionHolder(Collection<T> collection) {
            this.collection = collection;
        }
    }
}

