/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.List;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.workflow.core.impl.ConnectionImpl;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.instance.impl.NodeInstanceFactory;
import org.jbpm.workflow.instance.impl.NodeInstanceFactoryRegistry;
import org.jbpm.workflow.instance.node.MockNode;
import org.jbpm.workflow.instance.node.MockNodeInstance;
import org.jbpm.workflow.instance.node.MockNodeInstanceFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.slf4j.LoggerFactory;

public class StartNodeInstanceTest
extends AbstractBaseTest {
    @Override
    public void addLogger() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Test
    public void testStartNode() {
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime(new Process[0]);
        MockNode mockNode = new MockNode();
        MockNodeInstanceFactory mockNodeFactory = new MockNodeInstanceFactory(new MockNodeInstance(mockNode));
        NodeInstanceFactoryRegistry.getInstance((Environment)kruntime.getKieRuntime().getEnvironment()).register(((Object)((Object)mockNode)).getClass(), (NodeInstanceFactory)mockNodeFactory);
        RuleFlowProcess process = new RuleFlowProcess();
        StartNode startNode = new StartNode();
        startNode.setId(1L);
        startNode.setName("start node");
        mockNode.setId(2L);
        new ConnectionImpl((Node)startNode, "DROOLS_DEFAULT", (Node)mockNode, "DROOLS_DEFAULT");
        process.addNode((Node)startNode);
        process.addNode((Node)mockNode);
        RuleFlowProcessInstance processInstance = new RuleFlowProcessInstance();
        processInstance.setProcess((Process)process);
        processInstance.setKnowledgeRuntime((InternalKnowledgeRuntime)kruntime.getKieSession());
        Assertions.assertEquals((int)0, (int)processInstance.getState());
        processInstance.start();
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        MockNodeInstance mockNodeInstance = mockNodeFactory.getMockNodeInstance();
        List<NodeInstance> triggeredBy = mockNodeInstance.getTriggers().get("DROOLS_DEFAULT");
        Assertions.assertNotNull(triggeredBy);
        Assertions.assertEquals((int)1, (int)triggeredBy.size());
        Assertions.assertSame((Object)startNode.getId(), (Object)triggeredBy.get(0).getNodeId());
    }
}

