/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.context.exception;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.jbpm.process.core.context.exception.ExceptionHandlerPolicy;
import org.jbpm.process.core.context.exception.ExceptionHandlerPolicyFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.kie.kogito.process.workitem.WorkItemExecutionException;

class ExceptionHandlerPolicyTest {
    private static Collection<ExceptionHandlerPolicy> policies;

    ExceptionHandlerPolicyTest() {
    }

    @BeforeAll
    static void setup() {
        policies = ExceptionHandlerPolicyFactory.getHandlerPolicies();
    }

    @ParameterizedTest
    @ValueSource(strings={"java.lang.RuntimeException", "Unknown error", "(?i)Status code 400", "(.*)code 4[0-9]{2}", "code 4[0-9]{2}"})
    void testExceptionHandlerPolicyFactory(String errorString) {
        IllegalStateException exception = new IllegalStateException("Unknown error, status code 400");
        Assertions.assertTrue((boolean)this.test(policies, errorString, exception));
    }

    @ParameterizedTest
    @ValueSource(strings={"java.lang.RuntimeException", "Unknown error", "(?i)Status code 400", "(.*)code 4[0-9]{2}", "code 4[0-9]{2}"})
    void testExceptionChainPolicyFactory(String errorString) {
        IOException exception = new IOException(new RuntimeException("Unknown error, status code 400"));
        Assertions.assertTrue((boolean)this.test(policies, errorString, exception));
    }

    @ParameterizedTest
    @ValueSource(strings={"["})
    void testInvalidRegexExceptionHandlerPolicyFactory(String errorString) {
        IllegalStateException exception = new IllegalStateException("Unknown error, status code 400");
        Assertions.assertFalse((boolean)this.test(policies, errorString, exception));
    }

    @ParameterizedTest
    @ValueSource(strings={"HTTP:500", "500"})
    void testWebExceptionHandlerPolicyFactory(String errorString) {
        WorkItemExecutionException exception = new WorkItemExecutionException("500", "Unknown error");
        Assertions.assertTrue((boolean)this.test(policies, errorString, (Throwable)exception));
    }

    @ParameterizedTest
    @ValueSource(strings={"HTTP:xyz", "xyz"})
    void testWebExceptionHandlerPolicyFactoryIncorrectFormat(String errorString) {
        WorkItemExecutionException exception = new WorkItemExecutionException("500", "Unknown error");
        Assertions.assertFalse((boolean)this.test(policies, errorString, (Throwable)exception));
    }

    private boolean test(Collection<ExceptionHandlerPolicy> policies, String className, Throwable exception) {
        if (className == null) {
            return false;
        }
        Iterator<ExceptionHandlerPolicy> iter = policies.iterator();
        boolean found = false;
        while (!found && iter.hasNext()) {
            found = iter.next().test((Object)className, (Object)exception);
        }
        return found;
    }
}

