/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.datatype.impl.coverter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.jbpm.process.core.datatype.impl.coverter.TypeConverterRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CloneHelperTest {
    @Test
    void testCloneable() {
        CloneableCollectionHolder<Integer> toClone = new CloneableCollectionHolder<Integer>(Arrays.asList(1, 2, 3, 4));
        CollectionHolder cloned = (CollectionHolder)TypeConverterRegistry.get().forTypeCloner(toClone.getClass()).apply(toClone);
        Assertions.assertNotSame(toClone.getCollection(), cloned.getCollection());
        Assertions.assertEquals(toClone.getCollection(), cloned.getCollection());
    }

    @Test
    void testCopyConstructor() {
        CopyCollectionHolder<Integer> toClone = new CopyCollectionHolder<Integer>(Arrays.asList(1, 2, 3, 4));
        CollectionHolder cloned = (CollectionHolder)TypeConverterRegistry.get().forTypeCloner(toClone.getClass()).apply(toClone);
        Assertions.assertNotSame(toClone.getCollection(), cloned.getCollection());
        Assertions.assertEquals(toClone.getCollection(), cloned.getCollection());
    }

    @Test
    void testDefault() {
        CollectionHolder<Integer> toClone = new CollectionHolder<Integer>(Arrays.asList(1, 2, 3, 4));
        CollectionHolder cloned = (CollectionHolder)TypeConverterRegistry.get().forTypeCloner(toClone.getClass()).apply(toClone);
        Assertions.assertSame(toClone.getCollection(), cloned.getCollection());
    }

    @Test
    void testCloneableError() {
        DumbCloneableCollectionHolder<Integer> toClone = new DumbCloneableCollectionHolder<Integer>(Arrays.asList(1, 2, 3, 4));
        UnaryOperator cloner = TypeConverterRegistry.get().forTypeCloner(toClone.getClass());
        Assertions.assertThrows(IllegalStateException.class, () -> cloner.apply(toClone));
    }

    @Test
    void testCopyError() {
        DumbCopyCollectionHolder<Integer> toClone = new DumbCopyCollectionHolder<Integer>(Arrays.asList(1, 2, 3, 4));
        UnaryOperator cloner = TypeConverterRegistry.get().forTypeCloner(toClone.getClass());
        Assertions.assertThrows(IllegalStateException.class, () -> cloner.apply(toClone));
    }

    @Test
    void NoCloneableError() {
        LierCloneableCollectionHolder<Integer> toClone = new LierCloneableCollectionHolder<Integer>(Arrays.asList(1, 2, 3, 4));
        Assertions.assertSame(toClone, TypeConverterRegistry.get().forTypeCloner(toClone.getClass()).apply(toClone));
    }

    @Test
    void testCloneRegister() {
        TypeConverterRegistry.get().registerCloner(CustomCloneable.class, o -> new CustomCloneable(o.getName() + "_" + o.getName()));
        CustomCloneable toClone = new CustomCloneable("Javierito");
        Assertions.assertEquals((Object)new CustomCloneable("Javierito_Javierito"), TypeConverterRegistry.get().forTypeCloner(toClone.getClass()).apply(toClone));
    }

    private static class CustomCloneable {
        private final String name;

        public CustomCloneable(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CustomCloneable)) {
                return false;
            }
            CustomCloneable other = (CustomCloneable)obj;
            return Objects.equals(this.name, other.name);
        }
    }

    private static class CopyCollectionHolder<T>
    extends CollectionHolder<T> {
        public CopyCollectionHolder(Collection<T> collection) {
            super(collection);
        }

        public CopyCollectionHolder(CopyCollectionHolder<T> collection) {
            super(new ArrayList(collection.getCollection()));
        }
    }

    private static class DumbCopyCollectionHolder<T>
    extends CollectionHolder<T> {
        public DumbCopyCollectionHolder(Collection<T> collection) {
            super(collection);
        }

        public DumbCopyCollectionHolder(CollectionHolder<T> collection) {
            super(new ArrayList<T>(collection.getCollection()));
            throw new RuntimeException();
        }
    }

    private static class LierCloneableCollectionHolder<T>
    extends CollectionHolder<T>
    implements Cloneable {
        public LierCloneableCollectionHolder(Collection<T> collection) {
            super(collection);
        }
    }

    private static class DumbCloneableCollectionHolder<T>
    extends CollectionHolder<T>
    implements Cloneable {
        public DumbCloneableCollectionHolder(Collection<T> collection) {
            super(collection);
        }

        public Object clone() {
            throw new UnsupportedOperationException();
        }
    }

    private static class CloneableCollectionHolder<T>
    extends CollectionHolder<T>
    implements Cloneable {
        public CloneableCollectionHolder(Collection<T> collection) {
            super(collection);
        }

        public Object clone() {
            return new CloneableCollectionHolder(new ArrayList(super.getCollection()));
        }
    }

    private static class CollectionHolder<T> {
        private final Collection<T> collection;

        public Collection<T> getCollection() {
            return this.collection;
        }

        public CollectionHolder(Collection<T> collection) {
            this.collection = collection;
        }
    }
}

