/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.datatype.impl.coverter;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jbpm.process.core.datatype.impl.coverter.CloneHelperFactory;
import org.jbpm.process.core.datatype.impl.coverter.DateTypeConverter;
import org.jbpm.process.core.datatype.impl.coverter.NoOpTypeConverter;
import org.kie.kogito.jackson.utils.JsonNodeConverter;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;
import org.kie.kogito.jackson.utils.StringConverter;

public class TypeConverterRegistry {
    private static TypeConverterRegistry INSTANCE = new TypeConverterRegistry();
    private Map<String, Function<String, ? extends Object>> converters = new HashMap<String, Function<String, ? extends Object>>();
    private Map<String, Function<? extends Object, String>> unconverters = new HashMap<String, Function<? extends Object, String>>();
    private Map<Class<?>, UnaryOperator<Object>> cloners = new HashMap();
    private Function<String, String> defaultConverter = new NoOpTypeConverter();

    private TypeConverterRegistry() {
        this.converters.put("java.util.Date", new DateTypeConverter());
        this.converters.put(JsonNode.class.getName(), (Function<String, ? extends Object>)new JsonNodeConverter(ObjectMapperFactory::listenerAware));
        this.unconverters.put(JsonNode.class.getName(), (Function<? extends Object, String>)new StringConverter());
        this.cloners.put(JsonNode.class, o -> ((JsonNode)o).deepCopy());
    }

    public boolean isRegistered(String type) {
        return this.converters.containsKey(type);
    }

    public Function<String, ? extends Object> forType(String type) {
        return this.converters.getOrDefault(type, this.defaultConverter);
    }

    public <T> Function<T, String> forTypeReverse(T obj) {
        Function<? extends Object, String> result = null;
        Class<?> clazz = obj.getClass();
        do {
            result = this.unconverters.get(clazz.getName());
        } while ((clazz = clazz.getSuperclass()) != null && result == null);
        return result == null ? Object::toString : result;
    }

    public UnaryOperator<Object> forTypeCloner(Class<?> type) {
        return this.cloners.getOrDefault(type, CloneHelperFactory.getCloner(type));
    }

    public TypeConverterRegistry register(String type, Function<String, ? extends Object> converter) {
        this.converters.put(type, converter);
        return this;
    }

    public <T> TypeConverterRegistry registerUnconverter(String type, Function<T, String> unconverter) {
        this.unconverters.put(type, unconverter);
        return this;
    }

    public <T> TypeConverterRegistry registerCloner(Class<T> type, UnaryOperator<T> cloner) {
        this.cloners.put(type, cloner);
        return this;
    }

    public static TypeConverterRegistry get() {
        return INSTANCE;
    }
}

