/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.datatype;

import java.util.Arrays;
import org.jbpm.process.core.datatype.DataTypeResolver;
import org.jbpm.process.core.datatype.impl.type.BooleanDataType;
import org.jbpm.process.core.datatype.impl.type.EnumDataType;
import org.jbpm.process.core.datatype.impl.type.FloatDataType;
import org.jbpm.process.core.datatype.impl.type.IntegerDataType;
import org.jbpm.process.core.datatype.impl.type.ListDataType;
import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.process.core.datatype.impl.type.StringDataType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DataTypeResolverTest {
    @Test
    public void testDataType() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Assertions.assertTrue((boolean)(DataTypeResolver.fromObject((Object)"pepe") instanceof StringDataType));
        Assertions.assertTrue((boolean)(DataTypeResolver.fromObject((Object)true) instanceof BooleanDataType));
        Assertions.assertTrue((boolean)(DataTypeResolver.fromObject((Object)4) instanceof IntegerDataType));
        Assertions.assertTrue((boolean)(DataTypeResolver.fromObject((Object)Float.valueOf(23.2f)) instanceof FloatDataType));
        Assertions.assertTrue((boolean)(DataTypeResolver.fromObject(Arrays.asList("1", "2", "3")) instanceof ListDataType));
        Assertions.assertTrue((boolean)(DataTypeResolver.fromObject((Object)new byte[0]) instanceof ObjectDataType));
        Assertions.assertTrue((boolean)(DataTypeResolver.fromObject((Object)((Object)Champions.BETIS)) instanceof EnumDataType));
        Assertions.assertTrue((boolean)(DataTypeResolver.fromType((String)"String", (ClassLoader)cl) instanceof StringDataType));
        Assertions.assertTrue((boolean)(DataTypeResolver.fromType((String)"Boolean", (ClassLoader)cl) instanceof BooleanDataType));
        Assertions.assertTrue((boolean)(DataTypeResolver.fromType((String)"Integer", (ClassLoader)cl) instanceof IntegerDataType));
        Assertions.assertTrue((boolean)(DataTypeResolver.fromType((String)"Float", (ClassLoader)cl) instanceof FloatDataType));
        Assertions.assertTrue((boolean)(DataTypeResolver.fromType((String)"java.util.List", (ClassLoader)cl) instanceof ListDataType));
        Assertions.assertTrue((boolean)(DataTypeResolver.fromType((String)"Object", (ClassLoader)cl) instanceof ObjectDataType));
    }

    private static enum Champions {
        BETIS,
        DEPORTIVO,
        REAL_SOCIEDAD,
        VALENCIA;

    }
}

