/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ruleflow.core.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.impl.type.StringDataType;
import org.jbpm.process.core.validation.ProcessValidationError;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.ruleflow.core.validation.RuleFlowProcessValidator;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.impl.ConnectionImpl;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.impl.ExtendedNodeImpl;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.CompositeNode;
import org.jbpm.workflow.core.node.DynamicNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.ForEachNode;
import org.jbpm.workflow.core.node.MilestoneNode;
import org.jbpm.workflow.core.node.RuleSetNode;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.SubProcessNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class RuleFlowProcessValidatorTest {
    private RuleFlowProcessValidator validator;
    private List<ProcessValidationError> errors;
    private RuleFlowProcess process = new RuleFlowProcess();
    private Node node = (Node)Mockito.mock(Node.class);

    @BeforeEach
    public void setUp() {
        this.errors = new ArrayList<ProcessValidationError>();
        this.validator = RuleFlowProcessValidator.getInstance();
        this.process = new RuleFlowProcess();
        this.process.setId("org.drools.core.process");
        this.process.setName("Dynamic Node Process");
        this.process.setPackageName("org.mycomp.myprocess");
        this.process.setDynamic(false);
    }

    @Test
    void testAddErrorMessage() {
        Mockito.when((Object)this.node.getName()).thenReturn((Object)"nodeName");
        Mockito.when((Object)this.node.getId()).thenReturn((Object)Long.MAX_VALUE);
        this.validator.addErrorMessage(this.process, (org.kie.api.definition.process.Node)this.node, this.errors, "any message");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.errors.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Node 'nodeName' [9223372036854775807] any message", (Object)this.errors.get(0).getMessage());
    }

    @Test
    void testDynamicNodeValidationInNotDynamicProcess() {
        DynamicNode dynamicNode = new DynamicNode();
        dynamicNode.setName("MyDynamicNode");
        dynamicNode.setId(1L);
        dynamicNode.setAutoComplete(false);
        this.process.addNode((org.kie.api.definition.process.Node)dynamicNode);
        ProcessValidationError[] errors = this.validator.validateProcess(this.process);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)errors);
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)errors.length);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Process has no start node.", (Object)errors[0].getMessage());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Process has no end node.", (Object)errors[1].getMessage());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Node 'MyDynamicNode' [1] Dynamic has no incoming connection", (Object)errors[2].getMessage());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Node 'MyDynamicNode' [1] Dynamic has no outgoing connection", (Object)errors[3].getMessage());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Node 'MyDynamicNode' [1] Dynamic has no completion condition set", (Object)errors[4].getMessage());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Node 'MyDynamicNode' [1] Has no connection to the start node.", (Object)errors[5].getMessage());
    }

    @Test
    void testDynamicNodeValidationInDynamicProcess() {
        this.process.setDynamic(true);
        DynamicNode dynamicNode = new DynamicNode();
        dynamicNode.setName("MyDynamicNode");
        dynamicNode.setId(1L);
        dynamicNode.setAutoComplete(false);
        dynamicNode.setCompletionExpression(kcontext -> true);
        this.process.addNode((org.kie.api.definition.process.Node)dynamicNode);
        ProcessValidationError[] errors = this.validator.validateProcess(this.process);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)errors);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)errors.length);
        this.process.removeNode((org.kie.api.definition.process.Node)dynamicNode);
        DynamicNode dynamicNode2 = new DynamicNode();
        dynamicNode2.setName("MyDynamicNode");
        dynamicNode2.setId(1L);
        dynamicNode2.setAutoComplete(false);
        this.process.addNode((org.kie.api.definition.process.Node)dynamicNode2);
        ProcessValidationError[] errors2 = this.validator.validateProcess(this.process);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)errors2);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)errors2.length);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Node 'MyDynamicNode' [1] Dynamic has no completion condition set", (Object)errors2[0].getMessage());
    }

    @Test
    void testEmptyPackageName() {
        this.process.setDynamic(true);
        ProcessValidationError[] errors = this.validator.validateProcess(this.process);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)errors);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)errors.length);
    }

    @Test
    void testNoPackageName() {
        this.process.setDynamic(true);
        ProcessValidationError[] errors = this.validator.validateProcess(this.process);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)errors);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)errors.length);
    }

    @Test
    void testIdVariableName() {
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        this.process.addNode((org.kie.api.definition.process.Node)startNode);
        EndNode endNode = new EndNode();
        endNode.setName("EndNode");
        endNode.setId(2L);
        this.process.addNode((org.kie.api.definition.process.Node)endNode);
        new ConnectionImpl((org.kie.api.definition.process.Node)startNode, "DROOLS_DEFAULT", (org.kie.api.definition.process.Node)endNode, "DROOLS_DEFAULT");
        Variable idVariable = new Variable();
        idVariable.setName("id");
        idVariable.setType((DataType)new StringDataType());
        this.process.getVariableScope().addVariable(idVariable);
        ProcessValidationError[] errors = this.validator.validateProcess(this.process);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)errors);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)errors.length);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Variable 'id' is used by Kogito, please rename it.", (Object)errors[0].getMessage());
    }

    @Test
    void testCompositeNodeNoStart() {
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        this.process.addNode((org.kie.api.definition.process.Node)startNode);
        EndNode endNode = new EndNode();
        endNode.setName("EndNode");
        endNode.setId(2L);
        this.process.addNode((org.kie.api.definition.process.Node)endNode);
        CompositeNode compositeNode = new CompositeNode();
        compositeNode.setName("CompositeNode");
        compositeNode.setId(3L);
        this.process.addNode((org.kie.api.definition.process.Node)compositeNode);
        new ConnectionImpl((org.kie.api.definition.process.Node)startNode, "DROOLS_DEFAULT", (org.kie.api.definition.process.Node)compositeNode, "DROOLS_DEFAULT");
        new ConnectionImpl((org.kie.api.definition.process.Node)compositeNode, "DROOLS_DEFAULT", (org.kie.api.definition.process.Node)endNode, "DROOLS_DEFAULT");
        ProcessValidationError[] errors = this.validator.validateProcess(this.process);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)errors);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)errors.length);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Node 'CompositeNode' [3] Composite has no start node defined.", (Object)errors[0].getMessage());
    }

    @Test
    void testOnEntryOnExitValidation() {
        this.testNodeOnEntryOnExit((ExtendedNodeImpl)new MilestoneNode());
        RuleSetNode ruleSetNode = new RuleSetNode();
        ruleSetNode.setRuleType((RuleSetNode.RuleType)RuleSetNode.RuleType.ruleUnit((String)"test"));
        this.testNodeOnEntryOnExit((ExtendedNodeImpl)ruleSetNode);
        this.testNodeOnEntryOnExit((ExtendedNodeImpl)new SubProcessNode());
        this.testNodeOnEntryOnExit((ExtendedNodeImpl)new WorkItemNode());
        this.testNodeOnEntryOnExit((ExtendedNodeImpl)new ForEachNode());
        this.testNodeOnEntryOnExit((ExtendedNodeImpl)new DynamicNode());
        this.testNodeOnEntryOnExit((ExtendedNodeImpl)new CompositeNode());
    }

    private void testNodeOnEntryOnExit(ExtendedNodeImpl node) {
        ArrayList errors = new ArrayList();
        node.setName("name");
        node.setId(1L);
        node.setActions("onEntry", Collections.singletonList(new DroolsAction()));
        node.setActions("onExit", Collections.singletonList(new DroolsAction()));
        this.validator.validateNodes(new org.kie.api.definition.process.Node[]{node}, errors, this.process);
        Assertions.assertThat(errors).extracting("message").contains(new Object[]{"Node 'name' [1] On Entry Action is not yet supported in Kogito", "Node 'name' [1] On Exit Action is not yet supported in Kogito"});
    }

    @Test
    void testScriptTaskDialect() {
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        this.process.addNode((org.kie.api.definition.process.Node)startNode);
        EndNode endNode = new EndNode();
        endNode.setName("EndNode");
        endNode.setId(2L);
        this.process.addNode((org.kie.api.definition.process.Node)endNode);
        ActionNode actionNode1 = new ActionNode();
        actionNode1.setName("ActionNode1");
        actionNode1.setAction((DroolsAction)new DroolsConsequenceAction("mvel", "System.out.println();"));
        actionNode1.setId(3L);
        this.process.addNode((org.kie.api.definition.process.Node)actionNode1);
        ActionNode actionNode2 = new ActionNode();
        actionNode2.setName("ActionNode2");
        actionNode2.setAction((DroolsAction)new DroolsConsequenceAction("java", "System.out.println();"));
        actionNode2.setId(4L);
        this.process.addNode((org.kie.api.definition.process.Node)actionNode2);
        new ConnectionImpl((org.kie.api.definition.process.Node)startNode, "DROOLS_DEFAULT", (org.kie.api.definition.process.Node)actionNode1, "DROOLS_DEFAULT");
        new ConnectionImpl((org.kie.api.definition.process.Node)actionNode1, "DROOLS_DEFAULT", (org.kie.api.definition.process.Node)actionNode2, "DROOLS_DEFAULT");
        new ConnectionImpl((org.kie.api.definition.process.Node)actionNode2, "DROOLS_DEFAULT", (org.kie.api.definition.process.Node)endNode, "DROOLS_DEFAULT");
        ProcessValidationError[] errors = this.validator.validateProcess(this.process);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)errors);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)errors.length);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Node 'ActionNode1' [3] mvel script language is not supported in Kogito.", (Object)errors[0].getMessage());
    }
}

