/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.event.process;

import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.jbpm.process.core.event.EventFilter;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.impl.ConnectionImpl;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.core.node.EventTrigger;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.Trigger;
import org.junit.jupiter.api.Test;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.slf4j.LoggerFactory;

public class ProcessEventSupportTest
extends AbstractBaseTest {
    @Override
    public void addLogger() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Test
    public void testProcessEventListener() throws Exception {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.core.process.event");
        process.setName("Event Process");
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        process.addNode((Node)startNode);
        ActionNode actionNode = new ActionNode();
        actionNode.setName("Print");
        DroolsConsequenceAction action = new DroolsConsequenceAction("java", null);
        action.setMetaData("Action", context -> this.logger.info("Executed action"));
        actionNode.setAction((DroolsAction)action);
        actionNode.setId(2L);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)startNode, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        EndNode endNode = new EndNode();
        endNode.setName("End");
        endNode.setId(3L);
        process.addNode((Node)endNode);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)endNode, "DROOLS_DEFAULT");
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime(new Process[]{process});
        final ArrayList processEventList = new ArrayList();
        ProcessEventListener processEventListener = new ProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                processEventList.add(event);
            }

            public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
                processEventList.add(event);
            }

            public void afterProcessCompleted(ProcessCompletedEvent event) {
                processEventList.add(event);
            }

            public void afterProcessStarted(ProcessStartedEvent event) {
                processEventList.add(event);
            }

            public void beforeNodeLeft(ProcessNodeLeftEvent event) {
                processEventList.add(event);
            }

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                processEventList.add(event);
            }

            public void beforeProcessCompleted(ProcessCompletedEvent event) {
                processEventList.add(event);
            }

            public void beforeProcessStarted(ProcessStartedEvent event) {
                processEventList.add(event);
            }

            public void beforeVariableChanged(ProcessVariableChangedEvent event) {
                processEventList.add(event);
            }

            public void afterVariableChanged(ProcessVariableChangedEvent event) {
                processEventList.add(event);
            }
        };
        kruntime.getProcessEventManager().addEventListener(processEventListener);
        kruntime.startProcess("org.drools.core.process.event");
        Assertions.assertThat(processEventList).hasSize(16);
        Assertions.assertThat((String)((ProcessEvent)processEventList.get(0)).getProcessInstance().getProcessId()).isEqualTo("org.drools.core.process.event");
        Assertions.assertThat((String)((ProcessNodeTriggeredEvent)processEventList.get(1)).getNodeInstance().getNodeName()).isEqualTo("Start");
        Assertions.assertThat((String)((ProcessNodeLeftEvent)processEventList.get(2)).getNodeInstance().getNodeName()).isEqualTo("Start");
        Assertions.assertThat((String)((ProcessNodeTriggeredEvent)processEventList.get(3)).getNodeInstance().getNodeName()).isEqualTo("Print");
        Assertions.assertThat((String)((ProcessNodeLeftEvent)processEventList.get(4)).getNodeInstance().getNodeName()).isEqualTo("Print");
        Assertions.assertThat((String)((ProcessNodeTriggeredEvent)processEventList.get(5)).getNodeInstance().getNodeName()).isEqualTo("End");
        Assertions.assertThat((String)((ProcessNodeLeftEvent)processEventList.get(6)).getNodeInstance().getNodeName()).isEqualTo("End");
        Assertions.assertThat((String)((ProcessEvent)processEventList.get(7)).getProcessInstance().getProcessId()).isEqualTo("org.drools.core.process.event");
        Assertions.assertThat((String)((ProcessEvent)processEventList.get(8)).getProcessInstance().getProcessId()).isEqualTo("org.drools.core.process.event");
        Assertions.assertThat((String)((ProcessNodeLeftEvent)processEventList.get(9)).getNodeInstance().getNodeName()).isEqualTo("End");
        Assertions.assertThat((String)((ProcessNodeTriggeredEvent)processEventList.get(10)).getNodeInstance().getNodeName()).isEqualTo("End");
        Assertions.assertThat((String)((ProcessNodeLeftEvent)processEventList.get(11)).getNodeInstance().getNodeName()).isEqualTo("Print");
        Assertions.assertThat((String)((ProcessNodeTriggeredEvent)processEventList.get(12)).getNodeInstance().getNodeName()).isEqualTo("Print");
        Assertions.assertThat((String)((ProcessNodeLeftEvent)processEventList.get(13)).getNodeInstance().getNodeName()).isEqualTo("Start");
        Assertions.assertThat((String)((ProcessNodeTriggeredEvent)processEventList.get(14)).getNodeInstance().getNodeName()).isEqualTo("Start");
        Assertions.assertThat((String)((ProcessEvent)processEventList.get(15)).getProcessInstance().getProcessId()).isEqualTo("org.drools.core.process.event");
    }

    @Test
    public void testProcessEventListenerProcessState() throws Exception {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.core.process.event");
        process.setName("Event Process");
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        process.addNode((Node)startNode);
        ActionNode actionNode = new ActionNode();
        actionNode.setName("Print");
        DroolsConsequenceAction action = new DroolsConsequenceAction("java", null);
        action.setMetaData("Action", context -> this.logger.info("Executed action"));
        actionNode.setAction((DroolsAction)action);
        actionNode.setId(2L);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)startNode, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        EndNode endNode = new EndNode();
        endNode.setName("End");
        endNode.setId(3L);
        process.addNode((Node)endNode);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)endNode, "DROOLS_DEFAULT");
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime(new Process[]{process});
        final ArrayList processEventStatusList = new ArrayList();
        ProcessEventListener processEventListener = new ProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
            }

            public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
            }

            public void afterProcessCompleted(ProcessCompletedEvent event) {
                processEventStatusList.add(event.getProcessInstance().getState());
            }

            public void afterProcessStarted(ProcessStartedEvent event) {
            }

            public void beforeNodeLeft(ProcessNodeLeftEvent event) {
            }

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
            }

            public void beforeProcessCompleted(ProcessCompletedEvent event) {
                processEventStatusList.add(event.getProcessInstance().getState());
            }

            public void beforeProcessStarted(ProcessStartedEvent event) {
            }

            public void beforeVariableChanged(ProcessVariableChangedEvent event) {
            }

            public void afterVariableChanged(ProcessVariableChangedEvent event) {
            }
        };
        kruntime.getProcessEventManager().addEventListener(processEventListener);
        kruntime.startProcess("org.drools.core.process.event");
        Assertions.assertThat(processEventStatusList).hasSize(2);
        Assertions.assertThat((Integer)((Integer)processEventStatusList.get(0))).isEqualTo((Object)1);
        Assertions.assertThat((Integer)((Integer)processEventStatusList.get(1))).isEqualTo((Object)2);
    }

    @Test
    public void testProcessEventListenerWithEvent() throws Exception {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.core.process.event");
        process.setName("Event Process");
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        process.addNode((Node)startNode);
        ActionNode actionNode = new ActionNode();
        actionNode.setName("Print");
        DroolsConsequenceAction action = new DroolsConsequenceAction("java", null);
        action.setMetaData("Action", context -> this.logger.info("Executed action"));
        actionNode.setAction((DroolsAction)action);
        actionNode.setId(2L);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)startNode, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        EventNode eventNode = new EventNode();
        eventNode.setName("Event");
        eventNode.setId(3L);
        ArrayList<EventTypeFilter> filters = new ArrayList<EventTypeFilter>();
        EventTypeFilter filter = new EventTypeFilter();
        filter.setType("signal");
        filters.add(filter);
        eventNode.setEventFilters(filters);
        process.addNode((Node)eventNode);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)eventNode, "DROOLS_DEFAULT");
        EndNode endNode = new EndNode();
        endNode.setName("End");
        endNode.setId(4L);
        process.addNode((Node)endNode);
        new ConnectionImpl((Node)eventNode, "DROOLS_DEFAULT", (Node)endNode, "DROOLS_DEFAULT");
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime(new Process[]{process});
        final ArrayList processEventList = new ArrayList();
        ProcessEventListener processEventListener = new ProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                processEventList.add(event);
            }

            public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
                processEventList.add(event);
            }

            public void afterProcessCompleted(ProcessCompletedEvent event) {
                processEventList.add(event);
            }

            public void afterProcessStarted(ProcessStartedEvent event) {
                processEventList.add(event);
            }

            public void beforeNodeLeft(ProcessNodeLeftEvent event) {
                processEventList.add(event);
            }

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                processEventList.add(event);
            }

            public void beforeProcessCompleted(ProcessCompletedEvent event) {
                processEventList.add(event);
            }

            public void beforeProcessStarted(ProcessStartedEvent event) {
                processEventList.add(event);
            }

            public void beforeVariableChanged(ProcessVariableChangedEvent event) {
                processEventList.add(event);
            }

            public void afterVariableChanged(ProcessVariableChangedEvent event) {
                processEventList.add(event);
            }
        };
        kruntime.getProcessEventManager().addEventListener(processEventListener);
        KogitoProcessInstance pi = kruntime.startProcess("org.drools.core.process.event");
        pi.signalEvent("signal", null);
        Assertions.assertThat(processEventList).hasSize(20);
        Assertions.assertThat((String)((ProcessEvent)processEventList.get(0)).getProcessInstance().getProcessId()).isEqualTo("org.drools.core.process.event");
        Assertions.assertThat((String)((ProcessNodeTriggeredEvent)processEventList.get(1)).getNodeInstance().getNodeName()).isEqualTo("Start");
        Assertions.assertThat((String)((ProcessNodeLeftEvent)processEventList.get(2)).getNodeInstance().getNodeName()).isEqualTo("Start");
        Assertions.assertThat((String)((ProcessNodeTriggeredEvent)processEventList.get(3)).getNodeInstance().getNodeName()).isEqualTo("Print");
        Assertions.assertThat((String)((ProcessNodeLeftEvent)processEventList.get(4)).getNodeInstance().getNodeName()).isEqualTo("Print");
        Assertions.assertThat((String)((ProcessNodeTriggeredEvent)processEventList.get(5)).getNodeInstance().getNodeName()).isEqualTo("Event");
        Assertions.assertThat((String)((ProcessNodeTriggeredEvent)processEventList.get(6)).getNodeInstance().getNodeName()).isEqualTo("Event");
        Assertions.assertThat((String)((ProcessNodeLeftEvent)processEventList.get(7)).getNodeInstance().getNodeName()).isEqualTo("Print");
        Assertions.assertThat((String)((ProcessNodeTriggeredEvent)processEventList.get(8)).getNodeInstance().getNodeName()).isEqualTo("Print");
        Assertions.assertThat((String)((ProcessNodeLeftEvent)processEventList.get(9)).getNodeInstance().getNodeName()).isEqualTo("Start");
        Assertions.assertThat((String)((ProcessNodeTriggeredEvent)processEventList.get(10)).getNodeInstance().getNodeName()).isEqualTo("Start");
        Assertions.assertThat((String)((ProcessEvent)processEventList.get(11)).getProcessInstance().getProcessId()).isEqualTo("org.drools.core.process.event");
        Assertions.assertThat((String)((ProcessNodeLeftEvent)processEventList.get(12)).getNodeInstance().getNodeName()).isEqualTo("Event");
        Assertions.assertThat((String)((ProcessNodeTriggeredEvent)processEventList.get(13)).getNodeInstance().getNodeName()).isEqualTo("End");
        Assertions.assertThat((String)((ProcessNodeLeftEvent)processEventList.get(14)).getNodeInstance().getNodeName()).isEqualTo("End");
        Assertions.assertThat((String)((ProcessEvent)processEventList.get(15)).getProcessInstance().getProcessId()).isEqualTo("org.drools.core.process.event");
        Assertions.assertThat((String)((ProcessEvent)processEventList.get(16)).getProcessInstance().getProcessId()).isEqualTo("org.drools.core.process.event");
        Assertions.assertThat((String)((ProcessNodeLeftEvent)processEventList.get(17)).getNodeInstance().getNodeName()).isEqualTo("End");
        Assertions.assertThat((String)((ProcessNodeLeftEvent)processEventList.get(19)).getNodeInstance().getNodeName()).isEqualTo("Event");
        Assertions.assertThat((String)((ProcessNodeTriggeredEvent)processEventList.get(18)).getNodeInstance().getNodeName()).isEqualTo("End");
    }

    @Test
    public void testProcessEventListenerWithEndEvent() throws Exception {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.core.process.event");
        process.setName("Event Process");
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        process.addNode((Node)startNode);
        ActionNode actionNode = new ActionNode();
        actionNode.setName("Print");
        DroolsConsequenceAction action = new DroolsConsequenceAction("java", null);
        action.setMetaData("Action", context -> this.logger.info("Executed action"));
        actionNode.setAction((DroolsAction)action);
        actionNode.setId(2L);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)startNode, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        EndNode endNode = new EndNode();
        endNode.setName("End");
        endNode.setId(3L);
        endNode.setTerminate(false);
        process.addNode((Node)endNode);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)endNode, "DROOLS_DEFAULT");
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime(new Process[]{process});
        final ArrayList processEventList = new ArrayList();
        ProcessEventListener processEventListener = new ProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                processEventList.add(event);
            }

            public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
                processEventList.add(event);
            }

            public void afterProcessCompleted(ProcessCompletedEvent event) {
                processEventList.add(event);
            }

            public void afterProcessStarted(ProcessStartedEvent event) {
                processEventList.add(event);
            }

            public void beforeNodeLeft(ProcessNodeLeftEvent event) {
                processEventList.add(event);
            }

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                processEventList.add(event);
            }

            public void beforeProcessCompleted(ProcessCompletedEvent event) {
                processEventList.add(event);
            }

            public void beforeProcessStarted(ProcessStartedEvent event) {
                processEventList.add(event);
            }

            public void beforeVariableChanged(ProcessVariableChangedEvent event) {
                processEventList.add(event);
            }

            public void afterVariableChanged(ProcessVariableChangedEvent event) {
                processEventList.add(event);
            }
        };
        kruntime.getProcessEventManager().addEventListener(processEventListener);
        kruntime.startProcess("org.drools.core.process.event");
        Assertions.assertThat(processEventList).hasSize(14);
        Assertions.assertThat((String)((ProcessEvent)processEventList.get(0)).getProcessInstance().getProcessId()).isEqualTo("org.drools.core.process.event");
        Assertions.assertThat((String)((ProcessNodeTriggeredEvent)processEventList.get(1)).getNodeInstance().getNodeName()).isEqualTo("Start");
        Assertions.assertThat((String)((ProcessNodeLeftEvent)processEventList.get(2)).getNodeInstance().getNodeName()).isEqualTo("Start");
        Assertions.assertThat((String)((ProcessNodeTriggeredEvent)processEventList.get(3)).getNodeInstance().getNodeName()).isEqualTo("Print");
        Assertions.assertThat((String)((ProcessNodeLeftEvent)processEventList.get(4)).getNodeInstance().getNodeName()).isEqualTo("Print");
        Assertions.assertThat((String)((ProcessNodeTriggeredEvent)processEventList.get(5)).getNodeInstance().getNodeName()).isEqualTo("End");
        Assertions.assertThat((String)((ProcessNodeLeftEvent)processEventList.get(6)).getNodeInstance().getNodeName()).isEqualTo("End");
        Assertions.assertThat((String)((ProcessNodeLeftEvent)processEventList.get(7)).getNodeInstance().getNodeName()).isEqualTo("End");
        Assertions.assertThat((String)((ProcessNodeTriggeredEvent)processEventList.get(8)).getNodeInstance().getNodeName()).isEqualTo("End");
        Assertions.assertThat((String)((ProcessNodeLeftEvent)processEventList.get(9)).getNodeInstance().getNodeName()).isEqualTo("Print");
        Assertions.assertThat((String)((ProcessNodeTriggeredEvent)processEventList.get(10)).getNodeInstance().getNodeName()).isEqualTo("Print");
        Assertions.assertThat((String)((ProcessNodeLeftEvent)processEventList.get(11)).getNodeInstance().getNodeName()).isEqualTo("Start");
        Assertions.assertThat((String)((ProcessNodeTriggeredEvent)processEventList.get(12)).getNodeInstance().getNodeName()).isEqualTo("Start");
        Assertions.assertThat((String)((ProcessEvent)processEventList.get(13)).getProcessInstance().getProcessId()).isEqualTo("org.drools.core.process.event");
    }

    @Test
    public void testProcessEventListenerWithStartEvent() throws Exception {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.core.process.event");
        process.setName("Event Process");
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        EventTrigger trigger = new EventTrigger();
        EventTypeFilter eventFilter = new EventTypeFilter();
        eventFilter.setType("signal");
        trigger.addEventFilter((EventFilter)eventFilter);
        startNode.addTrigger((Trigger)trigger);
        process.addNode((Node)startNode);
        ActionNode actionNode = new ActionNode();
        actionNode.setName("Print");
        DroolsConsequenceAction action = new DroolsConsequenceAction("java", null);
        action.setMetaData("Action", context -> this.logger.info("Executed action"));
        actionNode.setAction((DroolsAction)action);
        actionNode.setId(2L);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)startNode, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        EndNode endNode = new EndNode();
        endNode.setName("End");
        endNode.setId(3L);
        process.addNode((Node)endNode);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)endNode, "DROOLS_DEFAULT");
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime(new Process[]{process});
        final ArrayList processEventList = new ArrayList();
        ProcessEventListener processEventListener = new ProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                processEventList.add(event);
            }

            public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
                processEventList.add(event);
            }

            public void afterProcessCompleted(ProcessCompletedEvent event) {
                processEventList.add(event);
            }

            public void afterProcessStarted(ProcessStartedEvent event) {
                processEventList.add(event);
            }

            public void beforeNodeLeft(ProcessNodeLeftEvent event) {
                processEventList.add(event);
            }

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                processEventList.add(event);
            }

            public void beforeProcessCompleted(ProcessCompletedEvent event) {
                processEventList.add(event);
            }

            public void beforeProcessStarted(ProcessStartedEvent event) {
                processEventList.add(event);
            }

            public void beforeVariableChanged(ProcessVariableChangedEvent event) {
                processEventList.add(event);
            }

            public void afterVariableChanged(ProcessVariableChangedEvent event) {
                processEventList.add(event);
            }
        };
        kruntime.getProcessEventManager().addEventListener(processEventListener);
        kruntime.signalEvent("signal", null);
        Assertions.assertThat(processEventList).hasSize(16);
        Assertions.assertThat((String)((ProcessEvent)processEventList.get(0)).getProcessInstance().getProcessId()).isEqualTo("org.drools.core.process.event");
        Assertions.assertThat((String)((ProcessNodeTriggeredEvent)processEventList.get(1)).getNodeInstance().getNodeName()).isEqualTo("Start");
        Assertions.assertThat((String)((ProcessNodeLeftEvent)processEventList.get(2)).getNodeInstance().getNodeName()).isEqualTo("Start");
        Assertions.assertThat((String)((ProcessNodeTriggeredEvent)processEventList.get(3)).getNodeInstance().getNodeName()).isEqualTo("Print");
        Assertions.assertThat((String)((ProcessNodeLeftEvent)processEventList.get(4)).getNodeInstance().getNodeName()).isEqualTo("Print");
        Assertions.assertThat((String)((ProcessNodeTriggeredEvent)processEventList.get(5)).getNodeInstance().getNodeName()).isEqualTo("End");
        Assertions.assertThat((String)((ProcessNodeLeftEvent)processEventList.get(6)).getNodeInstance().getNodeName()).isEqualTo("End");
        Assertions.assertThat((String)((ProcessEvent)processEventList.get(7)).getProcessInstance().getProcessId()).isEqualTo("org.drools.core.process.event");
        Assertions.assertThat((String)((ProcessEvent)processEventList.get(8)).getProcessInstance().getProcessId()).isEqualTo("org.drools.core.process.event");
        Assertions.assertThat((String)((ProcessNodeLeftEvent)processEventList.get(9)).getNodeInstance().getNodeName()).isEqualTo("End");
        Assertions.assertThat((String)((ProcessNodeTriggeredEvent)processEventList.get(10)).getNodeInstance().getNodeName()).isEqualTo("End");
        Assertions.assertThat((String)((ProcessNodeLeftEvent)processEventList.get(11)).getNodeInstance().getNodeName()).isEqualTo("Print");
        Assertions.assertThat((String)((ProcessNodeTriggeredEvent)processEventList.get(12)).getNodeInstance().getNodeName()).isEqualTo("Print");
        Assertions.assertThat((String)((ProcessNodeLeftEvent)processEventList.get(13)).getNodeInstance().getNodeName()).isEqualTo("Start");
        Assertions.assertThat((String)((ProcessNodeTriggeredEvent)processEventList.get(14)).getNodeInstance().getNodeName()).isEqualTo("Start");
        Assertions.assertThat((String)((ProcessEvent)processEventList.get(15)).getProcessInstance().getProcessId()).isEqualTo("org.drools.core.process.event");
    }
}

