/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process;

import org.assertj.core.api.Assertions;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.runtime.process.ProcessRuntimeFactoryService;
import org.drools.kiesession.session.ProcessRuntimeFactory;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.ProcessRuntimeFactoryServiceImpl;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.jupiter.api.Test;
import org.kie.api.definition.process.Process;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.kie.kogito.jobs.DurationExpirationTime;
import org.kie.kogito.jobs.ExactExpirationTime;
import org.kie.kogito.jobs.ExpirationTime;
import org.kie.kogito.jobs.ProcessInstanceJobDescription;
import org.kie.kogito.services.jobs.impl.LegacyInMemoryJobService;
import org.kie.kogito.services.uow.CollectingUnitOfWorkFactory;
import org.kie.kogito.services.uow.DefaultUnitOfWorkManager;
import org.kie.kogito.timer.TimerInstance;
import org.kie.kogito.uow.UnitOfWorkFactory;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.slf4j.LoggerFactory;

public class TimerTest
extends AbstractBaseTest {
    private int counter = 0;

    @Override
    public void addLogger() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Test
    public void testTimer() {
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime(new Process[0]);
        RuleFlowProcessInstance processInstance = new RuleFlowProcessInstance(){
            private static final long serialVersionUID = 510L;

            public void signalEvent(String type, Object event) {
                if ("timerTriggered".equals(type)) {
                    TimerInstance timer = (TimerInstance)event;
                    TimerTest.this.logger.info("Timer {} triggered", (Object)timer.getId());
                    ++TimerTest.this.counter;
                }
            }
        };
        processInstance.setKnowledgeRuntime(((InternalWorkingMemory)kruntime.getKieSession()).getKnowledgeRuntime());
        processInstance.setId("1234");
        InternalProcessRuntime processRuntime = (InternalProcessRuntime)((InternalWorkingMemory)kruntime.getKieSession()).getProcessRuntime();
        processRuntime.getProcessInstanceManager().internalAddProcessInstance((KogitoProcessInstance)processInstance);
        new Thread(() -> kruntime.getKieSession().fireUntilHalt()).start();
        LegacyInMemoryJobService jobService = new LegacyInMemoryJobService(kruntime, (UnitOfWorkManager)new DefaultUnitOfWorkManager((UnitOfWorkFactory)new CollectingUnitOfWorkFactory()));
        ProcessInstanceJobDescription desc = ProcessInstanceJobDescription.builder().expirationTime((ExpirationTime)ExactExpirationTime.now()).processInstanceId(processInstance.getStringId()).processId("test").timerId("timer1").build();
        String jobId = jobService.scheduleProcessInstanceJob(desc);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertThat((int)this.counter).isEqualTo(1);
        this.counter = 0;
        desc = ProcessInstanceJobDescription.builder().expirationTime((ExpirationTime)DurationExpirationTime.after((long)500L)).processInstanceId(processInstance.getStringId()).processId("test").timerId("timer2").build();
        jobId = jobService.scheduleProcessInstanceJob(desc);
        Assertions.assertThat((int)this.counter).isZero();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertThat((int)this.counter).isEqualTo(1);
        this.counter = 0;
        desc = ProcessInstanceJobDescription.builder().expirationTime((ExpirationTime)DurationExpirationTime.repeat((long)500L, (Long)300L)).processInstanceId(processInstance.getStringId()).processId("test").timerId("timer3").build();
        jobId = jobService.scheduleProcessInstanceJob(desc);
        Assertions.assertThat((int)this.counter).isZero();
        try {
            Thread.sleep(700L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertThat((int)this.counter).isEqualTo(1);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertThat((this.counter >= 4 ? 1 : 0) != 0).isTrue();
        jobService.cancelJob(jobId);
        int lastCount = this.counter;
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertThat((int)this.counter).isEqualTo(lastCount);
    }

    static {
        ProcessRuntimeFactory.setProcessRuntimeFactoryService((ProcessRuntimeFactoryService)new ProcessRuntimeFactoryServiceImpl());
    }
}

