/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.datatype.impl.coverter;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.assertj.core.api.Assertions;
import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.junit.jupiter.api.Test;

public class TypeConverterTest {
    @Test
    public void testStringObjectDataType() {
        ObjectDataType data = new ObjectDataType("java.lang.String");
        String readValue = (String)data.readValue("hello");
        Assertions.assertThat((String)readValue).isEqualTo("hello");
    }

    @Test
    public void testDateObjectDataType() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        Date now = new Date();
        ObjectDataType data = new ObjectDataType("java.util.Date");
        Date readValue = (Date)data.readValue(sdf.format(now));
        Assertions.assertThat((Date)readValue).hasToString(now.toString());
    }
}

