/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.util;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.util.WidMVELEvaluator;
import org.junit.jupiter.api.Test;
import org.mvel2.CompileException;
import org.slf4j.LoggerFactory;

public class WidMVELEvaluatorTest
extends AbstractBaseTest {
    @Override
    public void addLogger() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Test
    public void testWidNoImports() throws Exception {
        this.assertCorrectWids(WidMVELEvaluator.eval((String)this.getResourceContent("/wids/test-noimports.wid")));
    }

    @Test
    public void testWidBackwardsCompatImports() throws Exception {
        this.assertCorrectWids(WidMVELEvaluator.eval((String)this.getResourceContent("/wids/test-backwardscompat.wid")));
    }

    @Test
    public void testWidBackwardsCompatPkgImports() throws Exception {
        this.assertCorrectWids(WidMVELEvaluator.eval((String)this.getResourceContent("/wids/test-backwardscompatpkgimport.wid")));
    }

    @Test
    public void testWidBackwardsCompatMixedAndMissingImports() throws Exception {
        this.assertCorrectWids(WidMVELEvaluator.eval((String)this.getResourceContent("/wids/test-backwardscompatmixedandmissingimports.wid")));
    }

    @Test
    public void testWidCustomDataType() throws Exception {
        this.assertCorrectWids(WidMVELEvaluator.eval((String)this.getResourceContent("/wids/test-customdatatype.wid")));
    }

    @Test
    public void testWidCustomDataTypeNoImport() {
        try {
            this.assertCorrectWids(WidMVELEvaluator.eval((String)this.getResourceContent("/wids/test-customdatatypenoimport.wid")));
        }
        catch (Throwable t) {
            Assertions.assertThat((Throwable)t).isInstanceOf(CompileException.class);
        }
    }

    protected String getResourceContent(String path) throws Exception {
        return new String(Files.readAllBytes(Paths.get(this.getClass().getResource(path).getPath(), new String[0])), "UTF-8");
    }

    protected String getResouce(String path) throws Exception {
        return this.getClass().getResource(path).getFile();
    }

    private void assertCorrectWids(Object wids) {
        Assertions.assertThat((Object)wids).isNotNull();
        List widsMap = (List)wids;
        Assertions.assertThat((List)widsMap).hasSize(2);
        Map firstWid = (Map)widsMap.get(0);
        ((MapAssert)Assertions.assertThat((Map)firstWid).isNotNull()).containsEntry((Object)"name", (Object)"MyFirstWorkItem");
        Map firstWidParams = (Map)firstWid.get("parameters");
        ((MapAssert)Assertions.assertThat((Map)firstWidParams).isNotNull()).hasSize(6);
        Map firstWidParamValues = (Map)firstWid.get("parameterValues");
        ((MapAssert)Assertions.assertThat((Map)firstWidParamValues).isNotNull()).hasSize(1);
        Map secondWid = (Map)widsMap.get(1);
        ((MapAssert)Assertions.assertThat((Map)secondWid).isNotNull()).containsEntry((Object)"name", (Object)"MySecondWorkItem");
        Map secondWidParams = (Map)secondWid.get("parameters");
        ((MapAssert)Assertions.assertThat((Map)secondWidParams).isNotNull()).hasSize(6);
        Map secondWidParamValues = (Map)secondWid.get("parameterValues");
        ((MapAssert)Assertions.assertThat((Map)secondWidParamValues).isNotNull()).hasSize(1);
    }
}

