/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.impl;

import java.util.Arrays;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.ProcessInstanceManager;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.process.ProcessRuntime;
import org.kie.internal.process.CorrelationKey;
import org.kie.kogito.Model;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.kie.kogito.process.impl.AbstractProcess;
import org.kie.kogito.process.impl.AbstractProcessInstance;
import org.kie.kogito.uow.UnitOfWork;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.kie.kogito.uow.WorkUnit;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class AbstractProcessInstanceTest {
    private static final String NODE_ID = "my_node_id";
    @Mock
    private ProcessInstanceManager pim;
    @Mock
    private WorkflowProcessInstanceImpl wpi;
    @Mock
    private UnitOfWork unitOfWork;
    private AbstractProcessInstance<TestModel> processInstance;

    @BeforeEach
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        AbstractProcess process = (AbstractProcess)Mockito.mock(AbstractProcess.class);
        Process piProcess = (Process)Mockito.mock(Process.class);
        Mockito.when((Object)process.process()).thenReturn((Object)piProcess);
        Mockito.when((Object)process.get()).thenReturn((Object)piProcess);
        InternalProcessRuntime pr = (InternalProcessRuntime)Mockito.mock(InternalProcessRuntime.class);
        Mockito.when((Object)pr.createProcessInstance((String)ArgumentMatchers.any(), (CorrelationKey)ArgumentMatchers.any(), (Map)ArgumentMatchers.any())).thenReturn((Object)this.wpi);
        Mockito.when((Object)pr.getProcessInstanceManager()).thenReturn((Object)this.pim);
        UnitOfWorkManager unitOfWorkManager = (UnitOfWorkManager)Mockito.mock(UnitOfWorkManager.class);
        Mockito.when((Object)pr.getUnitOfWorkManager()).thenReturn((Object)unitOfWorkManager);
        KogitoProcessRuntime kogitoProcessRuntime = (KogitoProcessRuntime)Mockito.mock(KogitoProcessRuntime.class);
        Mockito.when((Object)pr.getKogitoProcessRuntime()).thenReturn((Object)kogitoProcessRuntime);
        Mockito.when((Object)unitOfWorkManager.currentUnitOfWork()).thenReturn((Object)this.unitOfWork);
        this.processInstance = new TestProcessInstance((AbstractProcess<TestModel>)process, new TestModel(), pr);
    }

    @Test
    public void testCreateProcessInstance() {
        Assertions.assertThat((int)this.processInstance.status()).isEqualTo(0);
        Assertions.assertThat((String)this.processInstance.id()).isNull();
        Assertions.assertThat((String)this.processInstance.businessKey()).isNull();
        ((ProcessInstanceManager)Mockito.verify((Object)this.pim, (VerificationMode)Mockito.never())).addProcessInstance((KogitoProcessInstance)ArgumentMatchers.any());
    }

    @Test
    public void shouldTriggerNodeWhenStartFrom() {
        NodeInstance nodeInstance = this.givenExistingNode(NODE_ID);
        this.processInstance.startFrom(NODE_ID);
        ((NodeInstance)Mockito.verify((Object)nodeInstance)).trigger(null, "DROOLS_DEFAULT");
        ((UnitOfWork)Mockito.verify((Object)this.unitOfWork, (VerificationMode)Mockito.times((int)2))).intercept((WorkUnit)ArgumentMatchers.any());
    }

    @Test
    public void shouldTriggerNodeWhenTrigger() {
        NodeInstance nodeInstance = this.givenExistingNode(NODE_ID);
        this.processInstance.triggerNode(NODE_ID);
        ((NodeInstance)Mockito.verify((Object)nodeInstance)).trigger(null, "DROOLS_DEFAULT");
        ((UnitOfWork)Mockito.verify((Object)this.unitOfWork)).intercept((WorkUnit)ArgumentMatchers.any());
    }

    private NodeInstance givenExistingNode(String nodeId) {
        RuleFlowProcess process = (RuleFlowProcess)Mockito.mock(RuleFlowProcess.class);
        Mockito.when((Object)this.wpi.getProcess()).thenReturn((Object)process);
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)node.getNodeUniqueId()).thenReturn((Object)nodeId);
        Mockito.when((Object)process.getNodesRecursively()).thenReturn(Arrays.asList(node));
        NodeInstance nodeInstance = (NodeInstance)Mockito.mock(NodeInstance.class);
        Mockito.when((Object)this.wpi.getNodeInstance(node)).thenReturn((Object)nodeInstance);
        return nodeInstance;
    }

    @Test
    public void testVersion() {
        this.processInstance.setVersion(10L);
        Assertions.assertThat((long)this.processInstance.version()).isEqualTo(10L);
    }

    static class TestModel
    implements Model {
        TestModel() {
        }

        public void update(Map<String, Object> params) {
            this.fromMap(params);
        }

        public Map<String, Object> toMap() {
            return null;
        }

        public TestModel fromMap(Map<String, Object> params) {
            return this;
        }
    }

    static class TestProcessInstance
    extends AbstractProcessInstance<TestModel> {
        public TestProcessInstance(AbstractProcess<TestModel> process, TestModel variables, InternalProcessRuntime rt) {
            super(process, (Model)variables, (ProcessRuntime)rt);
        }
    }
}

