/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.ProcessInstanceManager;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;

public class DefaultProcessInstanceManager
implements ProcessInstanceManager {
    private Map<String, KogitoProcessInstance> processInstances = new ConcurrentHashMap<String, KogitoProcessInstance>();
    private boolean lock = false;

    @Override
    public void addProcessInstance(KogitoProcessInstance processInstance) {
        if (Objects.isNull(processInstance.getStringId())) {
            ((ProcessInstance)processInstance).setId(UUID.randomUUID().toString());
        }
        this.internalAddProcessInstance(processInstance);
    }

    @Override
    public void internalAddProcessInstance(KogitoProcessInstance processInstance) {
        if (this.lock) {
            this.processInstances.put(processInstance.getStringId() + "_" + Thread.currentThread().getId(), processInstance);
        } else {
            this.processInstances.put(processInstance.getStringId(), processInstance);
        }
    }

    @Override
    public Collection<KogitoProcessInstance> getProcessInstances() {
        return Collections.unmodifiableCollection(this.processInstances.values());
    }

    @Override
    public KogitoProcessInstance getProcessInstance(String id) {
        if (this.lock) {
            return this.processInstances.get(id + "_" + Thread.currentThread().getId());
        }
        return this.processInstances.get(id);
    }

    @Override
    public KogitoProcessInstance getProcessInstance(String id, boolean readOnly) {
        if (this.lock) {
            return this.processInstances.get(id + "_" + Thread.currentThread().getId());
        }
        return this.processInstances.get(id);
    }

    @Override
    public void removeProcessInstance(KogitoProcessInstance processInstance) {
        this.internalRemoveProcessInstance(processInstance);
    }

    @Override
    public void internalRemoveProcessInstance(KogitoProcessInstance processInstance) {
        if (this.lock) {
            this.processInstances.remove(processInstance.getStringId() + "_" + Thread.currentThread().getId());
        } else {
            this.processInstances.remove(processInstance.getStringId());
        }
    }

    @Override
    public void clearProcessInstances() {
        this.processInstances.clear();
    }

    @Override
    public void clearProcessInstancesState() {
    }

    @Override
    public void setLock(boolean lock) {
        this.lock = lock;
    }
}

