/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.core.node;

import java.util.function.Predicate;
import org.jbpm.workflow.core.node.Constrainable;
import org.jbpm.workflow.core.node.StateBasedNode;
import org.kie.api.definition.process.Connection;
import org.kie.api.runtime.process.ProcessContext;

public class MilestoneNode
extends StateBasedNode
implements Constrainable {
    private static final long serialVersionUID = 510L;
    private String condition;
    private Predicate<ProcessContext> conditionPredicate;

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(Predicate<ProcessContext> conditionPredicate) {
        this.conditionPredicate = conditionPredicate;
    }

    public boolean canComplete(ProcessContext context) {
        return this.conditionPredicate == null || this.conditionPredicate.test(context);
    }

    @Override
    public void validateAddIncomingConnection(String type, Connection connection) {
        super.validateAddIncomingConnection(type, connection);
        if (!"DROOLS_DEFAULT".equals(type)) {
            MilestoneNode.throwValidationException(connection, "only accepts default incoming connection type!");
        }
        if (this.getFrom() != null && !Boolean.parseBoolean(System.getProperty("jbpm.enable.multi.con"))) {
            MilestoneNode.throwValidationException(connection, "cannot have more than one incoming connection!");
        }
    }

    @Override
    public void validateAddOutgoingConnection(String type, Connection connection) {
        super.validateAddOutgoingConnection(type, connection);
        if (!"DROOLS_DEFAULT".equals(type)) {
            MilestoneNode.throwValidationException(connection, "only accepts default outgoing connection type!");
        }
        if (this.getTo() != null && !Boolean.parseBoolean(System.getProperty("jbpm.enable.multi.con"))) {
            MilestoneNode.throwValidationException(connection, "cannot have more than one outgoing connection!");
        }
    }

    private static void throwValidationException(Connection connection, String msg) {
        throw new IllegalArgumentException("This type of node [" + connection.getFrom().getMetaData().get("UniqueId") + ", " + connection.getFrom().getName() + "] " + msg);
    }
}

