/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.timer;

import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.jbpm.process.core.timer.DateTimeUtils;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.LoggerFactory;

public class DateTimeUtilsTest
extends AbstractBaseTest {
    private static final long MINUTE_IN_MILLISECONDS = 60000L;
    private static final long FIFTY_NINE_SECONDS_IN_MILLISECONDS = 59000L;
    private static final long HOUR_IN_MILLISECONDS = 3600000L;

    @Override
    public void addLogger() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Test
    public void testParseDateTime() {
        OffsetDateTime hourAfterEpoch = OffsetDateTime.of(1970, 1, 1, 1, 0, 0, 0, ZoneOffset.UTC);
        long parsedMilliseconds = DateTimeUtils.parseDateTime((String)hourAfterEpoch.format(DateTimeFormatter.ISO_DATE_TIME));
        Assertions.assertEquals((long)3600000L, (long)parsedMilliseconds);
    }

    @Test
    public void testParseDuration() {
        long parsedMilliseconds = DateTimeUtils.parseDuration((String)"1h");
        Assertions.assertEquals((long)3600000L, (long)parsedMilliseconds);
    }

    @Test
    public void testParseDurationPeriodFormat() {
        long parsedMilliseconds = DateTimeUtils.parseDuration((String)"PT1H");
        Assertions.assertEquals((long)3600000L, (long)parsedMilliseconds);
    }

    @Test
    public void testParseDurationDefaultMilliseconds() {
        long parsedMilliseconds = DateTimeUtils.parseDuration((String)Long.toString(3600000L));
        Assertions.assertEquals((long)3600000L, (long)parsedMilliseconds);
    }

    @Test
    public void testParseDateAsDuration() {
        OffsetDateTime oneMinuteFromNow = OffsetDateTime.now().plusMinutes(1L);
        long parsedMilliseconds = DateTimeUtils.parseDateAsDuration((String)oneMinuteFromNow.format(DateTimeFormatter.ISO_DATE_TIME));
        Assertions.assertTrue((parsedMilliseconds <= 60000L ? 1 : 0) != 0, (String)"Parsed date as duration is bigger than 60000");
        Assertions.assertTrue((parsedMilliseconds > 59000L ? 1 : 0) != 0, (String)("Parsed date as duration is too low! Expected value is between 60000 and 59000 but is " + parsedMilliseconds));
    }

    @Test
    public void testParseRepeatableStartEndDateTime() {
        OffsetDateTime oneMinuteFromNow = OffsetDateTime.now().plusMinutes(1L);
        OffsetDateTime twoMinutesFromNow = oneMinuteFromNow.plusMinutes(1L);
        String oneMinuteFromNowFormatted = oneMinuteFromNow.format(DateTimeFormatter.ISO_DATE_TIME);
        String twoMinutesFromNowFormatted = twoMinutesFromNow.format(DateTimeFormatter.ISO_DATE_TIME);
        String isoString = "R5/" + oneMinuteFromNowFormatted + "/" + twoMinutesFromNowFormatted;
        long[] parsedRepeatable = DateTimeUtils.parseRepeatableDateTime((String)isoString);
        Assertions.assertEquals((long)5L, (long)parsedRepeatable[0]);
        Assertions.assertTrue((parsedRepeatable[1] <= 60000L ? 1 : 0) != 0, (String)"Parsed delay is bigger than 60000");
        Assertions.assertTrue((parsedRepeatable[1] > 59000L ? 1 : 0) != 0, (String)("Parsed delay is too low! Expected value is between 60000 and 59000 but is " + parsedRepeatable[1]));
        Assertions.assertEquals((long)60000L, (long)parsedRepeatable[2], (String)("Parsed period should be one minute in milliseconds but is " + parsedRepeatable[2]));
    }

    @Test
    public void testParseRepeatableStartDateTimeAndPeriod() {
        OffsetDateTime oneMinuteFromNow = OffsetDateTime.now().plusMinutes(1L);
        String oneMinuteFromNowFormatted = oneMinuteFromNow.format(DateTimeFormatter.ISO_DATE_TIME);
        String isoString = "R5/" + oneMinuteFromNowFormatted + "/PT1M";
        long[] parsedRepeatable = DateTimeUtils.parseRepeatableDateTime((String)isoString);
        Assertions.assertEquals((long)5L, (long)parsedRepeatable[0]);
        Assertions.assertTrue((parsedRepeatable[1] <= 60000L ? 1 : 0) != 0, (String)"Parsed delay is bigger than 60000");
        Assertions.assertTrue((parsedRepeatable[1] > 59000L ? 1 : 0) != 0, (String)("Parsed delay is too low! Expected value is between 60000 and 59000 but is " + parsedRepeatable[1]));
        Assertions.assertEquals((long)60000L, (long)parsedRepeatable[2], (String)("Parsed period should be one minute in milliseconds but is " + parsedRepeatable[2]));
    }

    @Test
    public void testParseRepeatablePeriodAndEndDateTime() {
        OffsetDateTime twoMinutesFromNow = OffsetDateTime.now().plusMinutes(2L);
        String twoMinutesFromNowFormatted = twoMinutesFromNow.format(DateTimeFormatter.ISO_DATE_TIME);
        String isoString = "R5/PT1M/" + twoMinutesFromNowFormatted;
        long[] parsedRepeatable = DateTimeUtils.parseRepeatableDateTime((String)isoString);
        Assertions.assertEquals((long)5L, (long)parsedRepeatable[0]);
        Assertions.assertTrue((parsedRepeatable[1] <= 60000L ? 1 : 0) != 0, (String)"Parsed delay is bigger than 60000");
        Assertions.assertTrue((parsedRepeatable[1] > 59000L ? 1 : 0) != 0, (String)("Parsed delay is too low! Expected value is between 60000 and 59000 but is " + parsedRepeatable[1]));
        Assertions.assertEquals((long)60000L, (long)parsedRepeatable[2], (String)("Parsed period should be one minute in milliseconds but is " + parsedRepeatable[2]));
    }

    @Test
    public void testParseRepeatablePeriodOnly() {
        String isoString = "R/PT1M";
        long[] parsedRepeatable = DateTimeUtils.parseRepeatableDateTime((String)isoString);
        Assertions.assertEquals((long)-1L, (long)parsedRepeatable[0]);
        Assertions.assertEquals((long)1000L, (long)parsedRepeatable[1]);
        Assertions.assertEquals((long)60000L, (long)parsedRepeatable[2], (String)("Parsed period should be one minute in milliseconds but is " + parsedRepeatable[2]));
    }
}

