/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.jbpm.process.instance.impl.humantask.HumanTaskWorkItemHandler;
import org.jbpm.util.JsonSchemaUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Application;
import org.kie.kogito.Config;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessConfig;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.ProcessInstances;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.WorkItemHandlerConfig;
import org.kie.kogito.process.workitem.Policy;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class JsonSchemaUtilTest {
    private static final String example = "{\"$schema\": \"http://json-schema.org/draft-07/schema#\",\n    \"type\": \"object\",\n    \"properties\": {\n        \"traveller\": {\n            \"type\": \"object\",\n            \"properties\": {\n                \"address\": {\n                    \"type\": \"object\",\n                    \"properties\": {\n                        \"city\": {\n                            \"type\": \"string\"\n                        },\n                        \"country\": {\n                            \"type\": \"string\"\n                        },\n                        \"street\": {\n                            \"type\": \"string\"\n                        },\n                        \"zipCode\": {\n                            \"type\": \"string\"\n                        }\n                    }\n                },\n                \"email\": {\n                    \"type\": \"string\"\n                },\n                \"firstName\": {\n                    \"type\": \"string\"\n                },\n                \"lastName\": {\n                    \"type\": \"string\"\n                },\n                \"nationality\": {\n                    \"type\": \"string\"\n                }\n            },\n            \"input\": true\n        },\n        \"approved\": {\n            \"type\": \"boolean\",\n            \"output\": true\n        }\n    }}";

    @Test
    void testJsonSchema() throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(example.getBytes());
        Map schemaMap = JsonSchemaUtil.load((InputStream)in);
        ((InputStream)in).close();
        Assertions.assertEquals((Object)"object", schemaMap.get("type"));
        Map properties = (Map)schemaMap.get("properties");
        Assertions.assertEquals((int)2, (int)properties.size());
        Assertions.assertTrue((boolean)((Boolean)((Map)properties.get("approved")).get("output")));
        Assertions.assertTrue((boolean)((Boolean)((Map)properties.get("traveller")).get("input")));
    }

    @Test
    <T> void testJsonSchemaPhases() throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(example.getBytes());
        Policy[] policies = new Policy[]{};
        Map schemaMap = JsonSchemaUtil.load((InputStream)in);
        ((InputStream)in).close();
        Process process = (Process)Mockito.mock(Process.class);
        ProcessInstances processInstances = (ProcessInstances)Mockito.mock(ProcessInstances.class);
        Mockito.when((Object)process.instances()).thenReturn((Object)processInstances);
        ProcessInstance processInstance = (ProcessInstance)Mockito.mock(ProcessInstance.class);
        Mockito.when((Object)processInstances.findById("pepe", ProcessInstanceReadMode.READ_ONLY)).thenReturn(Optional.of(processInstance));
        WorkItem task = (WorkItem)Mockito.mock(WorkItem.class);
        Mockito.when((Object)processInstance.workItem("task", policies)).thenReturn((Object)task);
        Mockito.when((Object)task.getPhase()).thenReturn((Object)"active");
        Application application = (Application)Mockito.mock(Application.class);
        Config config = (Config)Mockito.mock(Config.class);
        ProcessConfig processConfig = (ProcessConfig)Mockito.mock(ProcessConfig.class);
        Mockito.when((Object)application.config()).thenReturn((Object)config);
        Mockito.when((Object)config.get((Class)ArgumentMatchers.any())).thenReturn((Object)processConfig);
        WorkItemHandlerConfig workItemHandlerConfig = (WorkItemHandlerConfig)Mockito.mock(WorkItemHandlerConfig.class);
        Mockito.when((Object)processConfig.workItemHandlers()).thenReturn((Object)workItemHandlerConfig);
        HumanTaskWorkItemHandler workItemHandler = new HumanTaskWorkItemHandler();
        Mockito.when((Object)workItemHandlerConfig.forName("Human Task")).thenReturn((Object)workItemHandler);
        schemaMap = JsonSchemaUtil.addPhases((Process)process, (Application)application, (String)"pepe", (String)"task", (Policy[])policies, (Map)schemaMap);
        Assertions.assertFalse((boolean)((Collection)schemaMap.get("phases")).isEmpty());
    }
}

