/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.context.exception;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jbpm.process.core.context.exception.ExceptionHandlerPolicy;
import org.jbpm.process.core.context.exception.ExceptionHandlerPolicyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageContentRegexExceptionPolicy
implements ExceptionHandlerPolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageContentRegexExceptionPolicy.class);

    @Override
    public boolean test(String errorCode, Throwable exception) {
        String msg = exception.getMessage();
        try {
            return msg != null && !ExceptionHandlerPolicyUtils.isExceptionErrorCode(errorCode) && Pattern.compile(errorCode).matcher(msg).find();
        }
        catch (PatternSyntaxException ex) {
            LOGGER.debug("Failure parsing regular expression: {}", (Object)errorCode, (Object)ex);
            return false;
        }
    }
}

