/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.datatype.impl.type;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.DataTypeUtils;
import org.jbpm.process.core.datatype.impl.coverter.TypeConverterRegistry;

public class ObjectDataType
implements DataType {
    private static final long serialVersionUID = 510L;
    private static final String DEFAULT_TYPE = "java.lang.Object";
    private String className;
    private transient ClassLoader classLoader;
    private transient Class<?> clazz;

    public ObjectDataType() {
        this(DEFAULT_TYPE);
    }

    public ObjectDataType(String className) {
        this(className, null);
    }

    public ObjectDataType(String className, ClassLoader classLoader) {
        Objects.requireNonNull(className);
        this.className = DataTypeUtils.ensureLangPrefix(className);
        this.classLoader = classLoader;
    }

    public ObjectDataType(Class<?> clazz) {
        this(clazz.getCanonicalName(), clazz.getClassLoader());
        this.clazz = clazz;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.className = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.className);
    }

    @Override
    public boolean verifyDataType(Object value) {
        if (value == null) {
            return true;
        }
        this.getObjectClass();
        return this.clazz.isInstance(value);
    }

    @Override
    public Object readValue(String value) {
        return TypeConverterRegistry.get().forType(this.getStringType()).apply(value);
    }

    @Override
    public String writeValue(Object value) {
        return value.toString();
    }

    @Override
    public String getStringType() {
        return this.getClassName();
    }

    @Override
    public Class<?> getObjectClass() {
        if (this.clazz == null) {
            this.clazz = ObjectDataType.findClass(this.className, this.classLoader);
            if (this.clazz == null) {
                this.clazz = ObjectDataType.findClass(this.className, Thread.currentThread().getContextClassLoader());
            }
        }
        if (this.clazz == null) {
            throw new IllegalArgumentException("Cannot find class " + this.className);
        }
        return this.clazz;
    }

    @Override
    public boolean isAssignableFrom(DataType dataType) {
        return DataTypeUtils.isAssignableFrom(this, dataType) || this.className.equals(DEFAULT_TYPE);
    }

    private static Class<?> findClass(String typeName, ClassLoader cl) {
        if (cl != null) {
            try {
                return Class.forName(typeName, true, cl);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectDataType that = (ObjectDataType)o;
        return Objects.equals(this.className, that.className);
    }

    public int hashCode() {
        return Objects.hash(this.className);
    }
}

