/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.test;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestProcessEventListener
implements ProcessEventListener {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<String> eventHistory = new ArrayList<String>();

    public void beforeProcessStarted(ProcessStartedEvent event) {
        this.logAndAdd("bps");
    }

    public void afterProcessStarted(ProcessStartedEvent event) {
        this.logAndAdd("aps");
    }

    public void beforeProcessCompleted(ProcessCompletedEvent event) {
        this.logAndAdd("bpc");
    }

    public void afterProcessCompleted(ProcessCompletedEvent event) {
        this.logAndAdd("apc");
    }

    public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
        this.logAndAdd("bnt-" + ((NodeInstanceImpl)event.getNodeInstance()).getUniqueId());
    }

    public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
        this.logAndAdd("ant-" + ((NodeInstanceImpl)event.getNodeInstance()).getUniqueId());
    }

    public void beforeNodeLeft(ProcessNodeLeftEvent event) {
        this.logAndAdd("bnl-" + ((NodeInstanceImpl)event.getNodeInstance()).getUniqueId());
    }

    public void afterNodeLeft(ProcessNodeLeftEvent event) {
        this.logAndAdd("anl-" + ((NodeInstanceImpl)event.getNodeInstance()).getUniqueId());
    }

    public void beforeVariableChanged(ProcessVariableChangedEvent event) {
        this.logAndAdd("bvc-" + event.getVariableId());
    }

    public void afterVariableChanged(ProcessVariableChangedEvent event) {
        this.logAndAdd("avc-" + event.getVariableId());
    }

    public List<String> getEventHistory() {
        return this.eventHistory;
    }

    private void logAndAdd(String event) {
        this.logger.trace(event);
        this.eventHistory.add(event);
    }
}

