/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event.impl;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.event.impl.DefaultEventConsumerFactory;
import org.kie.kogito.event.impl.DefaultEventMarshaller;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstances;
import org.kie.kogito.process.Signal;
import org.kie.kogito.services.event.AbstractProcessDataEvent;
import org.kie.kogito.services.event.EventConsumer;
import org.kie.kogito.services.event.EventConsumerFactory;
import org.kie.kogito.services.event.EventMarshaller;
import org.kie.kogito.services.uow.CollectingUnitOfWorkFactory;
import org.kie.kogito.services.uow.DefaultUnitOfWorkManager;
import org.kie.kogito.uow.UnitOfWorkFactory;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class EventImplTest {
    private static EventConsumerFactory factory;
    private static EventMarshaller marshaller;
    private Process<DummyModel> process;
    private ProcessInstance<DummyModel> processInstance;
    private ProcessInstances<DummyModel> processInstances;
    private Application application;

    @BeforeAll
    static void init() {
        factory = new DefaultEventConsumerFactory();
        marshaller = new DefaultEventMarshaller();
    }

    @BeforeEach
    void setup() {
        this.application = (Application)Mockito.mock(Application.class);
        Mockito.when((Object)this.application.unitOfWorkManager()).thenReturn((Object)new DefaultUnitOfWorkManager((UnitOfWorkFactory)new CollectingUnitOfWorkFactory()));
        this.process = (Process)Mockito.mock(Process.class);
        this.processInstances = (ProcessInstances)Mockito.mock(ProcessInstances.class);
        this.processInstance = (ProcessInstance)Mockito.mock(ProcessInstance.class);
        Mockito.when((Object)this.process.instances()).thenReturn(this.processInstances);
        Mockito.when((Object)this.processInstances.findById(ArgumentMatchers.anyString())).thenReturn(Optional.of(this.processInstance));
        Mockito.when((Object)this.process.createInstance((Object)((DummyModel)Mockito.any(DummyModel.class)))).thenReturn(this.processInstance);
    }

    @Test
    void testSigCloudEvent() {
        EventConsumer consumer = factory.get(DummyModel::new, DummyEvent.class, DummyCloudEvent.class, Optional.of(true));
        String trigger = "dummyTopic";
        String payload = "{ \"specversion\": \"0.3\",\"id\": \"21627e26-31eb-43e7-8343-92a696fd96b1\",\"source\": \"\",\"type\": \"dummyTopic\",\"time\": \"2019-10-01T12:02:23.812262+02:00[Europe/Warsaw]\",\"kogitoprocrefid\": \"1\",\"kogitoprocinstanceid\": \"1\",\"data\": {\"dummyField\" : \"pepe\"}}";
        consumer.consume(this.application, this.process, "{ \"specversion\": \"0.3\",\"id\": \"21627e26-31eb-43e7-8343-92a696fd96b1\",\"source\": \"\",\"type\": \"dummyTopic\",\"time\": \"2019-10-01T12:02:23.812262+02:00[Europe/Warsaw]\",\"kogitoprocrefid\": \"1\",\"kogitoprocinstanceid\": \"1\",\"data\": {\"dummyField\" : \"pepe\"}}", "dummyTopic");
        ArgumentCaptor signal = ArgumentCaptor.forClass(Signal.class);
        ((ProcessInstance)Mockito.verify(this.processInstance, (VerificationMode)Mockito.times((int)1))).send((Signal)signal.capture());
        Assertions.assertEquals((Object)"1", (Object)((Signal)signal.getValue()).referenceId());
        Assertions.assertTrue((boolean)(((Signal)signal.getValue()).payload() instanceof DummyEvent));
        Assertions.assertEquals((Object)"pepe", (Object)((DummyEvent)((Signal)signal.getValue()).payload()).getDummyField());
    }

    @Test
    void testCloudEvent() {
        EventConsumer consumer = factory.get(DummyModel::new, DummyEvent.class, DummyCloudEvent.class, Optional.empty());
        String trigger = "dummyTopic";
        String payload = "{ \"specversion\": \"0.3\",\"id\": \"21627e26-31eb-43e7-8343-92a696fd96b1\",\"source\": \"\",\"type\": \"dummyTopic\",\"time\": \"2019-10-01T12:02:23.812262+02:00[Europe/Warsaw]\",\"kogitoprocinstanceid\": \"1\",\"data\": {\"dummyField\" : \"pepe\"}}";
        consumer.consume(this.application, this.process, "{ \"specversion\": \"0.3\",\"id\": \"21627e26-31eb-43e7-8343-92a696fd96b1\",\"source\": \"\",\"type\": \"dummyTopic\",\"time\": \"2019-10-01T12:02:23.812262+02:00[Europe/Warsaw]\",\"kogitoprocinstanceid\": \"1\",\"data\": {\"dummyField\" : \"pepe\"}}", "dummyTopic");
        ((ProcessInstance)Mockito.verify(this.processInstance, (VerificationMode)Mockito.times((int)1))).start("dummyTopic", "1");
    }

    @Test
    void testDataEvent() {
        EventConsumer consumer = factory.get(DummyModel::new, DummyEvent.class, DummyCloudEvent.class, Optional.of(false));
        String trigger = "dummyTopic";
        String payload = "{\"dummyField\" : \"pepe\"}";
        consumer.consume(this.application, this.process, "{\"dummyField\" : \"pepe\"}", "dummyTopic");
        ((ProcessInstance)Mockito.verify(this.processInstance, (VerificationMode)Mockito.times((int)1))).start("dummyTopic", null);
    }

    @Test
    void testDataMarshaller() {
        DummyEvent dataEvent = new DummyEvent("pepe");
        Assertions.assertEquals((Object)"{\"dummyField\":\"pepe\"}", (Object)marshaller.marshall((Object)dataEvent, DummyCloudEvent::new, Optional.of(false)));
    }

    @Test
    void testCloudEventMarshaller() {
        DummyEvent dataEvent = new DummyEvent("pepe");
        String jsonString = marshaller.marshall((Object)dataEvent, DummyCloudEvent::new, Optional.empty());
        Assertions.assertTrue((boolean)jsonString.contains("\"dummyField\":\"pepe\""));
        Assertions.assertTrue((boolean)jsonString.contains("\"kogitoprocinstanceid\":\"1\""));
    }

    @Test
    void testCloudEventPayloadException() {
        EventConsumer consumer = factory.get(DummyModel::new, DummyEvent.class, DummyCloudEvent.class, Optional.empty());
        String trigger = "dummyTopic";
        String payload = "{ a = b }";
        Assertions.assertThrows(IllegalStateException.class, () -> consumer.consume(this.application, this.process, "{ a = b }", "dummyTopic"));
    }

    private static class DummyCloudEvent
    extends AbstractProcessDataEvent<DummyEvent> {
        public DummyCloudEvent() {
        }

        public DummyCloudEvent(DummyEvent dummyEvent) {
            super("", (Object)dummyEvent, "1", null, null, null, null, null, null);
        }
    }

    private static class DummyModel
    implements Model {
        private DummyEvent dummyEvent;

        public void fromMap(Map<String, Object> params) {
            this.dummyEvent = (DummyEvent)params.get("dummyEvent");
        }

        public Map<String, Object> toMap() {
            return Collections.singletonMap("dummyEvent", this.dummyEvent);
        }

        public DummyModel(DummyEvent dummyEvent) {
            this.dummyEvent = dummyEvent;
        }

        public void update(Map<String, Object> params) {
            this.fromMap(params);
        }
    }

    private static class DummyEvent {
        private String dummyField;

        public DummyEvent() {
        }

        public DummyEvent(String dummyField) {
            this.dummyField = dummyField;
        }

        public String getDummyField() {
            return this.dummyField;
        }
    }
}

