/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.datatype.impl.coverter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jbpm.process.core.datatype.impl.coverter.CloneHelper;
import org.jbpm.process.core.datatype.impl.coverter.CloneHelperRegister;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;

public class CloneHelperTest {
    @BeforeAll
    static void init() {
        CloneHelperRegister.get().registerCloner(CustomCloneable.class, o -> new CustomCloneable(o.getName() + "_" + o.getName()));
    }

    @Test
    void testCloneable() {
        this.assertCloned(new CloneableCollectionHolder<Integer>(Arrays.asList(1, 2, 3, 4)));
    }

    @Test
    void testCopyConstructor() {
        this.assertCloned(new CopyCollectionHolder<Integer>(Arrays.asList(1, 2, 3, 4)));
    }

    @Test
    void testDefault() {
        this.assertNotCloned(new CollectionHolder<Integer>(Arrays.asList(1, 2, 3, 4)));
    }

    @Test
    void testCloneableError() {
        this.assertCloneError(new DumbCloneableCollectionHolder<Integer>(Arrays.asList(1, 2, 3, 4)));
    }

    @Test
    void testCopyError() {
        this.assertCloneError(new DumbCopyCollectionHolder<Integer>(Arrays.asList(1, 2, 3, 4)));
    }

    @Test
    void testNoCloneable() {
        this.assertNotCloned(new LierCloneableCollectionHolder<Integer>(Arrays.asList(1, 2, 3, 4)));
    }

    @Test
    void testCloneRegister() {
        Assertions.assertThat((Object)((CustomCloneable)CloneHelper.get().clone((Object)new CustomCloneable("Javierito")))).isEqualTo((Object)new CustomCloneable("Javierito_Javierito"));
    }

    @Test
    void testCloneIntPrimitive() {
        this.assertNotCloned(1);
    }

    @Test
    void testCloneBoolPrimitive() {
        this.assertNotCloned(true);
    }

    @Test
    void testCloneStringPrimitive() {
        this.assertCloned("pepe");
    }

    @Test
    void testCloneNull() {
        Object clode = CloneHelper.get().clone(null);
        Assertions.assertThat((Object)clode).isNull();
    }

    @Test
    void testListClone() {
        this.assertCloned(new ArrayList<Integer>(Arrays.asList(1, 2, 3)));
    }

    @Test
    void testObjectNodeClone() {
        Assertions.assertThat((Object)CloneHelper.get().getCloner(ObjectNode.class)).isSameAs((Object)CloneHelper.get().getCloner(JsonNode.class));
        this.assertCloned(ObjectMapperFactory.get().createObjectNode().put("name", "Javierito"));
    }

    private void assertNotCloned(Object toClone) {
        Assertions.assertThat((Object)CloneHelper.get().clone(toClone)).isSameAs(toClone);
    }

    private void assertCloned(Object toClone) {
        Object cloned = CloneHelper.get().clone(toClone);
        ((ObjectAssert)Assertions.assertThat((Object)cloned).isEqualTo(toClone)).isNotSameAs(toClone);
    }

    private <T> void assertCloneError(T toClone) {
        UnaryOperator cloner = CloneHelper.get().getCloner(toClone.getClass());
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> cloner.apply(toClone));
    }

    private static class CustomCloneable {
        private final String name;

        public CustomCloneable(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CustomCloneable)) {
                return false;
            }
            CustomCloneable other = (CustomCloneable)obj;
            return Objects.equals(this.name, other.name);
        }
    }

    private static class CloneableCollectionHolder<T>
    extends CollectionHolder<T>
    implements Cloneable {
        public CloneableCollectionHolder(Collection<T> collection) {
            super(collection);
        }

        public Object clone() {
            return new CloneableCollectionHolder(new ArrayList(super.getCollection()));
        }
    }

    private static class CopyCollectionHolder<T>
    extends CollectionHolder<T> {
        public CopyCollectionHolder(Collection<T> collection) {
            super(collection);
        }

        public CopyCollectionHolder(CopyCollectionHolder<T> collection) {
            super(new ArrayList(collection.getCollection()));
        }
    }

    private static class CollectionHolder<T> {
        private final Collection<T> collection;

        public Collection<T> getCollection() {
            return this.collection;
        }

        public CollectionHolder(Collection<T> collection) {
            this.collection = collection;
        }

        public int hashCode() {
            return Objects.hash(this.collection);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CollectionHolder other = (CollectionHolder)obj;
            return Objects.equals(this.collection, other.collection);
        }
    }

    private static class DumbCloneableCollectionHolder<T>
    extends CollectionHolder<T>
    implements Cloneable {
        public DumbCloneableCollectionHolder(Collection<T> collection) {
            super(collection);
        }

        public Object clone() {
            throw new UnsupportedOperationException();
        }
    }

    private static class DumbCopyCollectionHolder<T>
    extends CollectionHolder<T> {
        public DumbCopyCollectionHolder(Collection<T> collection) {
            super(collection);
        }

        public DumbCopyCollectionHolder(CollectionHolder<T> collection) {
            super(new ArrayList<T>(collection.getCollection()));
            throw new RuntimeException();
        }
    }

    private static class LierCloneableCollectionHolder<T>
    extends CollectionHolder<T>
    implements Cloneable {
        public LierCloneableCollectionHolder(Collection<T> collection) {
            super(collection);
        }
    }
}

