/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.jbpm.process.core.impl.ProcessImpl;
import org.jbpm.process.instance.StartProcessHelper;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.jupiter.api.Test;
import org.kie.api.KieBase;
import org.kie.api.definition.process.Process;
import org.slf4j.LoggerFactory;

public class StartProcessHelperTest
extends AbstractBaseTest {
    @Override
    public void addLogger() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Test
    public void testFindLatestProcessByNameNoInput() {
        String foundProcessId = StartProcessHelper.findLatestProcessByName((KieBase)null, (String)"Hello");
        Assertions.assertThat((String)foundProcessId).isNull();
    }

    @Test
    public void testFindLatestProcessByNameNoExisting() {
        List<Process> processes = this.buildProcessCollection("Hello", 5);
        String foundProcessId = StartProcessHelper.findLatestProcessByName(processes, (String)"NoSuchProcess");
        Assertions.assertThat((String)foundProcessId).isNull();
    }

    @Test
    public void testFindLatestProcessByName() {
        List<Process> processes = this.buildProcessCollection("Hello", 5);
        String foundProcessId = StartProcessHelper.findLatestProcessByName(processes, (String)"Hello");
        ((AbstractStringAssert)Assertions.assertThat((String)foundProcessId).isNotNull()).isEqualTo("5");
    }

    @Test
    public void testFindLatestProcessByNameMultipleProcesses() {
        List<Process> processes = this.buildProcessCollection("Hello", 5);
        processes.addAll(this.buildProcessCollection("DifferentProcess", 10));
        processes.addAll(this.buildProcessCollection("DifferentProcess1", 10));
        processes.addAll(this.buildProcessCollection("DifferentProcess2", 30));
        processes.addAll(this.buildProcessCollection("Process", 10));
        processes.addAll(this.buildProcessCollection("Diffeocess1", 10));
        processes.addAll(this.buildProcessCollection("Differs2", 30));
        processes.addAll(this.buildProcessCollection("zDifferentProcess", 10));
        processes.addAll(this.buildProcessCollection("xDifferentProcess1", 10));
        processes.addAll(this.buildProcessCollection("cDifferentProcess2", 30));
        processes.addAll(this.buildProcessCollection("vProcess", 10));
        processes.addAll(this.buildProcessCollection("bDiffeocess1", 10));
        processes.addAll(this.buildProcessCollection("nDiffers2", 30));
        Collections.shuffle(processes);
        String foundProcessId = StartProcessHelper.findLatestProcessByName(processes, (String)"Hello");
        ((AbstractStringAssert)Assertions.assertThat((String)foundProcessId).isNotNull()).isEqualTo("5");
        foundProcessId = StartProcessHelper.findLatestProcessByName(processes, (String)"DifferentProcess");
        ((AbstractStringAssert)Assertions.assertThat((String)foundProcessId).isNotNull()).isEqualTo("10");
    }

    @Test
    public void testFindLatestProcessByNameDoubleAsVersion() {
        ArrayList<ProcessImpl> processes = new ArrayList<ProcessImpl>();
        ProcessImpl process = new ProcessImpl();
        process.setName("Hello");
        process.setId("1");
        process.setVersion("0.1");
        processes.add(process);
        process = new ProcessImpl();
        process.setName("Hello");
        process.setId("2");
        process.setVersion("0.2");
        processes.add(process);
        String foundProcessId = StartProcessHelper.findLatestProcessByName(processes, (String)"Hello");
        ((AbstractStringAssert)Assertions.assertThat((String)foundProcessId).isNotNull()).isEqualTo("2");
    }

    private List<Process> buildProcessCollection(String processName, int limit) {
        ArrayList<Process> processes = new ArrayList<Process>();
        ProcessImpl process = null;
        for (int i = 1; i <= limit; ++i) {
            process = new ProcessImpl();
            process.setName(processName);
            process.setId("" + i);
            process.setVersion("" + i);
            processes.add((Process)process);
        }
        return processes;
    }
}

