/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.ArrayList;
import java.util.regex.Matcher;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.util.PatternConstants;
import org.junit.jupiter.api.Test;
import org.slf4j.LoggerFactory;

public class ParameterResolverTest
extends AbstractBaseTest {
    @Override
    public void addLogger() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Test
    public void testSingleVariable() {
        Object[] expected = new String[]{"var1"};
        String s = "#{var1}";
        ArrayList<String> foundVariables = new ArrayList<String>();
        Matcher matcher = PatternConstants.PARAMETER_MATCHER.matcher(s);
        while (matcher.find()) {
            String paramName = matcher.group(1);
            foundVariables.add(paramName);
        }
        ((ListAssert)Assertions.assertThat(foundVariables).hasSize(1)).containsExactly(expected);
    }

    @Test
    public void testSingleVariableEnclosedWithText() {
        Object[] expected = new String[]{"var1"};
        String s = "this is my #{var1} variable";
        ArrayList<String> foundVariables = new ArrayList<String>();
        Matcher matcher = PatternConstants.PARAMETER_MATCHER.matcher(s);
        while (matcher.find()) {
            String paramName = matcher.group(1);
            foundVariables.add(paramName);
        }
        ((ListAssert)Assertions.assertThat(foundVariables).hasSize(1)).containsExactly(expected);
    }

    @Test
    public void testMultiVariableWithoutWhitespace() {
        Object[] expected = new String[]{"var1", "var2"};
        String s = "#{var1}=#{var2}";
        ArrayList<String> foundVariables = new ArrayList<String>();
        Matcher matcher = PatternConstants.PARAMETER_MATCHER.matcher(s);
        while (matcher.find()) {
            String paramName = matcher.group(1);
            foundVariables.add(paramName);
        }
        ((ListAssert)Assertions.assertThat(foundVariables).hasSize(2)).containsExactly(expected);
    }

    @Test
    public void testMultiVariableSeparatedWithComma() {
        Object[] expected = new String[]{"var1", "var2"};
        String s = "#{var1},#{var2}";
        ArrayList<String> foundVariables = new ArrayList<String>();
        Matcher matcher = PatternConstants.PARAMETER_MATCHER.matcher(s);
        while (matcher.find()) {
            String paramName = matcher.group(1);
            foundVariables.add(paramName);
        }
        ((ListAssert)Assertions.assertThat(foundVariables).hasSize(2)).containsExactly(expected);
    }

    @Test
    public void testMultiVariableEnclosedWithText() {
        Object[] expected = new String[]{"var1", "var2"};
        String s = "Here are my two #{var1},#{var2} variables";
        ArrayList<String> foundVariables = new ArrayList<String>();
        Matcher matcher = PatternConstants.PARAMETER_MATCHER.matcher(s);
        while (matcher.find()) {
            String paramName = matcher.group(1);
            foundVariables.add(paramName);
        }
        ((ListAssert)Assertions.assertThat(foundVariables).hasSize(2)).containsExactly(expected);
    }

    @Test
    public void testMultiVariableNextToEachOther() {
        Object[] expected = new String[]{"var1", "var2"};
        String s = "#{var1}#{var2}";
        ArrayList<String> foundVariables = new ArrayList<String>();
        Matcher matcher = PatternConstants.PARAMETER_MATCHER.matcher(s);
        while (matcher.find()) {
            String paramName = matcher.group(1);
            foundVariables.add(paramName);
        }
        ((ListAssert)Assertions.assertThat(foundVariables).hasSize(2)).containsExactly(expected);
    }

    @Test
    public void testSingleVariableViaSysPropWithText() {
        Object[] expected = new String[]{"System.getProperty(\"var1\",\"var1default\")"};
        String s = "#{System.getProperty(\"var1\",\"var1default\")}/someText";
        ArrayList<String> foundVariables = new ArrayList<String>();
        Matcher matcher = PatternConstants.PARAMETER_MATCHER.matcher(s);
        while (matcher.find()) {
            String paramName = matcher.group(1);
            foundVariables.add(paramName);
        }
        ((ListAssert)Assertions.assertThat(foundVariables).hasSize(1)).containsExactly(expected);
    }

    @Test
    public void testSingleVariableViaSysPropWithTextAndSpaces() {
        Object[] expected = new String[]{"System.getProperty(\"var1\", \"var1default\")"};
        String s = "#{System.getProperty(\"var1\", \"var1default\")}/someText";
        ArrayList<String> foundVariables = new ArrayList<String>();
        Matcher matcher = PatternConstants.PARAMETER_MATCHER.matcher(s);
        while (matcher.find()) {
            String paramName = matcher.group(1);
            foundVariables.add(paramName);
        }
        ((ListAssert)Assertions.assertThat(foundVariables).hasSize(1)).containsExactly(expected);
    }

    @Test
    public void testMultiVariableViaSysPropWithText() {
        Object[] expected = new String[]{"System.getProperty(\"var1\",\"var1default\")", "System.getProperty(\"var2\",\"var2default\")"};
        String s = "#{System.getProperty(\"var1\",\"var1default\")}/someText, #{System.getProperty(\"var2\",\"var2default\")}/someOtherText";
        ArrayList<String> foundVariables = new ArrayList<String>();
        Matcher matcher = PatternConstants.PARAMETER_MATCHER.matcher(s);
        while (matcher.find()) {
            String paramName = matcher.group(1);
            foundVariables.add(paramName);
        }
        ((ListAssert)Assertions.assertThat(foundVariables).hasSize(2)).containsExactly(expected);
    }

    @Test
    public void testMultiVariableViaSysPropWithTextAndSpaces() {
        Object[] expected = new String[]{"System.getProperty(\"var1\", \"var1default\")", "System.getProperty(\"var2\", \"var2default\")"};
        String s = "#{System.getProperty(\"var1\", \"var1default\")}/someText, #{System.getProperty(\"var2\", \"var2default\")}/someOtherText";
        ArrayList<String> foundVariables = new ArrayList<String>();
        Matcher matcher = PatternConstants.PARAMETER_MATCHER.matcher(s);
        while (matcher.find()) {
            String paramName = matcher.group(1);
            foundVariables.add(paramName);
        }
        ((ListAssert)Assertions.assertThat(foundVariables).hasSize(2)).containsExactly(expected);
    }
}

