/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.repository.infinispan.marshaller;

import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.assertj.core.api.Assertions;
import org.infinispan.protostream.MessageMarshaller;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.jobs.service.repository.infinispan.marshaller.TriggerMarshaller;
import org.kie.kogito.timer.Trigger;
import org.kie.kogito.timer.impl.IntervalTrigger;
import org.kie.kogito.timer.impl.PointInTimeTrigger;
import org.kie.kogito.timer.impl.SimpleTimerTrigger;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class TriggerMarshallerTest {
    private static final OffsetDateTime START_TIME_VALUE = OffsetDateTime.parse("2023-03-16T12:13:14.001+01:00");
    private static final OffsetDateTime NEXT_FIRE_TIME_VALUE = OffsetDateTime.parse("2023-03-16T14:15:16.001+01:00");
    private static final OffsetDateTime END_TIME_VALUE = OffsetDateTime.parse("2023-03-16T15:16:17.001+01:00");
    private static final long PERIOD_VALUE = 2L;
    private static final int REPEAT_LIMIT_VALUE = 3;
    private static final int REPEAT_COUNT_VALUE = 4;
    private static final int CURRENT_REPEAT_COUNT_VALUE = 1;
    private static final boolean END_TIME_REACHED_VALUE = false;
    private static final String ZONE_ID_VALUE = "+01:00";
    private static final ChronoUnit PERIOD_UNIT_VALUE = ChronoUnit.HOURS;
    @Mock
    private MessageMarshaller.ProtoStreamWriter writer;
    @Mock
    private MessageMarshaller.ProtoStreamReader reader;
    private final TriggerMarshaller marshaller = new TriggerMarshaller();

    TriggerMarshallerTest() {
    }

    @Test
    void getTypeName() {
        Assertions.assertThat((String)this.marshaller.getTypeName()).isEqualTo("job.service.Trigger");
    }

    @Test
    void getJavaClass() {
        Assertions.assertThat((Class)this.marshaller.getJavaClass()).isEqualTo(Trigger.class);
    }

    @Test
    void writeToSimpleTimerTrigger() throws IOException {
        SimpleTimerTrigger trigger = new SimpleTimerTrigger();
        trigger.setStartTime(java.sql.Date.from(START_TIME_VALUE.toInstant()));
        trigger.setPeriod(2L);
        trigger.setPeriodUnit(PERIOD_UNIT_VALUE);
        trigger.setRepeatCount(4);
        trigger.setEndTime(java.sql.Date.from(END_TIME_VALUE.toInstant()));
        trigger.setZoneId(ZONE_ID_VALUE);
        trigger.setNextFireTime(java.sql.Date.from(NEXT_FIRE_TIME_VALUE.toInstant()));
        trigger.setCurrentRepeatCount(1);
        trigger.setEndTimeReached(false);
        this.marshaller.writeTo(this.writer, (Trigger)trigger);
        ((MessageMarshaller.ProtoStreamWriter)Mockito.verify((Object)this.writer)).writeString("classType", SimpleTimerTrigger.class.getName());
        ((MessageMarshaller.ProtoStreamWriter)Mockito.verify((Object)this.writer)).writeInstant("startTime", START_TIME_VALUE.toInstant());
        ((MessageMarshaller.ProtoStreamWriter)Mockito.verify((Object)this.writer)).writeInstant("endTime", END_TIME_VALUE.toInstant());
        ((MessageMarshaller.ProtoStreamWriter)Mockito.verify((Object)this.writer)).writeInt("repeatCount", 4);
        ((MessageMarshaller.ProtoStreamWriter)Mockito.verify((Object)this.writer)).writeInstant("nextFireTime", NEXT_FIRE_TIME_VALUE.toInstant());
        ((MessageMarshaller.ProtoStreamWriter)Mockito.verify((Object)this.writer)).writeLong("period", 2L);
        ((MessageMarshaller.ProtoStreamWriter)Mockito.verify((Object)this.writer)).writeString("periodUnit", PERIOD_UNIT_VALUE.name());
        ((MessageMarshaller.ProtoStreamWriter)Mockito.verify((Object)this.writer)).writeString("zoneId", ZONE_ID_VALUE);
        ((MessageMarshaller.ProtoStreamWriter)Mockito.verify((Object)this.writer)).writeInt("currentRepeatCount", 1);
        ((MessageMarshaller.ProtoStreamWriter)Mockito.verify((Object)this.writer)).writeBoolean("endTimeReached", false);
    }

    @Test
    void writeToIntervalTrigger() throws IOException {
        IntervalTrigger trigger = new IntervalTrigger();
        trigger.setStartTime(java.sql.Date.from(START_TIME_VALUE.toInstant()));
        trigger.setEndTime(java.sql.Date.from(END_TIME_VALUE.toInstant()));
        trigger.setRepeatLimit(3);
        trigger.setRepeatCount(4);
        trigger.setNextFireTime(java.sql.Date.from(NEXT_FIRE_TIME_VALUE.toInstant()));
        trigger.setPeriod(2L);
        this.marshaller.writeTo(this.writer, (Trigger)trigger);
        ((MessageMarshaller.ProtoStreamWriter)Mockito.verify((Object)this.writer)).writeString("classType", IntervalTrigger.class.getName());
        ((MessageMarshaller.ProtoStreamWriter)Mockito.verify((Object)this.writer)).writeInstant("startTime", START_TIME_VALUE.toInstant());
        ((MessageMarshaller.ProtoStreamWriter)Mockito.verify((Object)this.writer)).writeInstant("endTime", END_TIME_VALUE.toInstant());
        ((MessageMarshaller.ProtoStreamWriter)Mockito.verify((Object)this.writer)).writeInt("repeatLimit", 3);
        ((MessageMarshaller.ProtoStreamWriter)Mockito.verify((Object)this.writer)).writeInt("repeatCount", 4);
        ((MessageMarshaller.ProtoStreamWriter)Mockito.verify((Object)this.writer)).writeInstant("nextFireTime", NEXT_FIRE_TIME_VALUE.toInstant());
        ((MessageMarshaller.ProtoStreamWriter)Mockito.verify((Object)this.writer)).writeLong("period", 2L);
    }

    @Test
    void writeToPointInTimeTrigger() throws IOException {
        PointInTimeTrigger trigger = new PointInTimeTrigger(NEXT_FIRE_TIME_VALUE.toInstant().toEpochMilli(), null, null);
        this.marshaller.writeTo(this.writer, (Trigger)trigger);
        ((MessageMarshaller.ProtoStreamWriter)Mockito.verify((Object)this.writer)).writeString("classType", PointInTimeTrigger.class.getName());
        ((MessageMarshaller.ProtoStreamWriter)Mockito.verify((Object)this.writer)).writeInstant("nextFireTime", NEXT_FIRE_TIME_VALUE.toInstant());
    }

    @Test
    void readFromSimpleTimerTrigger() throws IOException {
        ((MessageMarshaller.ProtoStreamReader)Mockito.doReturn((Object)SimpleTimerTrigger.class.getName()).when((Object)this.reader)).readString("classType");
        Trigger result = this.readTrigger();
        Assertions.assertThat((Object)result).isExactlyInstanceOf(SimpleTimerTrigger.class);
        SimpleTimerTrigger trigger = (SimpleTimerTrigger)result;
        Assertions.assertThat((Date)trigger.getStartTime()).isEqualTo(START_TIME_VALUE.toInstant());
        Assertions.assertThat((long)trigger.getPeriod()).isEqualTo(2L);
        Assertions.assertThat((Comparable)((Object)trigger.getPeriodUnit())).isEqualTo((Object)PERIOD_UNIT_VALUE);
        Assertions.assertThat((int)trigger.getRepeatCount()).isEqualTo(4);
        Assertions.assertThat((Date)trigger.getEndTime()).isEqualTo(END_TIME_VALUE.toInstant());
        Assertions.assertThat((Date)trigger.getNextFireTime()).isEqualTo(NEXT_FIRE_TIME_VALUE.toInstant());
        Assertions.assertThat((String)trigger.getZoneId()).isEqualTo(ZONE_ID_VALUE);
        Assertions.assertThat((int)trigger.getCurrentRepeatCount()).isEqualTo(1);
        Assertions.assertThat((boolean)trigger.isEndTimeReached()).isEqualTo(false);
    }

    @Test
    void readFromIntervalTrigger() throws IOException {
        ((MessageMarshaller.ProtoStreamReader)Mockito.doReturn((Object)IntervalTrigger.class.getName()).when((Object)this.reader)).readString("classType");
        Trigger result = this.readTrigger();
        Assertions.assertThat((Object)result).isExactlyInstanceOf(IntervalTrigger.class);
        IntervalTrigger trigger = (IntervalTrigger)result;
        Assertions.assertThat((Date)trigger.getStartTime()).isEqualTo(START_TIME_VALUE.toInstant());
        Assertions.assertThat((long)trigger.getPeriod()).isEqualTo(2L);
        Assertions.assertThat((int)trigger.getRepeatLimit()).isEqualTo(3);
        Assertions.assertThat((int)trigger.getRepeatCount()).isEqualTo(4);
        Assertions.assertThat((Date)trigger.getEndTime()).isEqualTo(END_TIME_VALUE.toInstant());
        Assertions.assertThat((Date)trigger.getNextFireTime()).isEqualTo(NEXT_FIRE_TIME_VALUE.toInstant());
    }

    @Test
    void readFromPointInTime() throws IOException {
        ((MessageMarshaller.ProtoStreamReader)Mockito.doReturn((Object)PointInTimeTrigger.class.getName()).when((Object)this.reader)).readString("classType");
        Trigger result = this.readTrigger();
        Assertions.assertThat((Object)result).isExactlyInstanceOf(PointInTimeTrigger.class);
        PointInTimeTrigger trigger = (PointInTimeTrigger)result;
        Assertions.assertThat((Date)trigger.hasNextFireTime()).isEqualTo(NEXT_FIRE_TIME_VALUE.toInstant());
    }

    private Trigger readTrigger() throws IOException {
        ((MessageMarshaller.ProtoStreamReader)Mockito.doReturn((Object)START_TIME_VALUE.toInstant()).when((Object)this.reader)).readInstant("startTime");
        ((MessageMarshaller.ProtoStreamReader)Mockito.doReturn((Object)END_TIME_VALUE.toInstant()).when((Object)this.reader)).readInstant("endTime");
        ((MessageMarshaller.ProtoStreamReader)Mockito.doReturn((Object)3).when((Object)this.reader)).readInt("repeatLimit");
        ((MessageMarshaller.ProtoStreamReader)Mockito.doReturn((Object)4).when((Object)this.reader)).readInt("repeatCount");
        ((MessageMarshaller.ProtoStreamReader)Mockito.doReturn((Object)NEXT_FIRE_TIME_VALUE.toInstant()).when((Object)this.reader)).readInstant("nextFireTime");
        ((MessageMarshaller.ProtoStreamReader)Mockito.doReturn((Object)2L).when((Object)this.reader)).readLong("period");
        ((MessageMarshaller.ProtoStreamReader)Mockito.doReturn((Object)PERIOD_UNIT_VALUE.name()).when((Object)this.reader)).readString("periodUnit");
        ((MessageMarshaller.ProtoStreamReader)Mockito.doReturn((Object)ZONE_ID_VALUE).when((Object)this.reader)).readString("zoneId");
        ((MessageMarshaller.ProtoStreamReader)Mockito.doReturn((Object)1).when((Object)this.reader)).readInt("currentRepeatCount");
        ((MessageMarshaller.ProtoStreamReader)Mockito.doReturn((Object)false).when((Object)this.reader)).readBoolean("endTimeReached");
        return this.marshaller.readFrom(this.reader);
    }
}

