/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.model;

import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.StringJoiner;
import org.kie.kogito.jobs.service.model.JobDetailsBuilder;
import org.kie.kogito.jobs.service.model.JobStatus;
import org.kie.kogito.jobs.service.model.Recipient;
import org.kie.kogito.timer.Trigger;

public class JobDetails {
    private String id;
    private String correlationId;
    private JobStatus status;
    private ZonedDateTime lastUpdate;
    private Integer retries;
    private Integer priority;
    private Integer executionCounter;
    private String scheduledId;
    private Recipient recipient;
    private Trigger trigger;
    private Long executionTimeout;
    private ChronoUnit executionTimeoutUnit;

    protected JobDetails(String id, String correlationId, JobStatus status, ZonedDateTime lastUpdate, Integer retries, Integer executionCounter, String scheduledId, Recipient recipient, Trigger trigger, Integer priority, Long executionTimeout, ChronoUnit executionTimeoutUnit) {
        this.id = id;
        this.correlationId = correlationId;
        this.status = status;
        this.lastUpdate = lastUpdate;
        this.retries = retries;
        this.executionCounter = executionCounter;
        this.scheduledId = scheduledId;
        this.recipient = recipient;
        this.trigger = trigger;
        this.priority = priority;
        this.executionTimeout = executionTimeout;
        this.executionTimeoutUnit = executionTimeoutUnit;
    }

    public String getId() {
        return this.id;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public JobStatus getStatus() {
        return this.status;
    }

    public ZonedDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    public Integer getRetries() {
        return this.retries;
    }

    public Integer getExecutionCounter() {
        return this.executionCounter;
    }

    public String getScheduledId() {
        return this.scheduledId;
    }

    public Recipient getRecipient() {
        return this.recipient;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public Long getExecutionTimeout() {
        return this.executionTimeout;
    }

    public ChronoUnit getExecutionTimeoutUnit() {
        return this.executionTimeoutUnit;
    }

    public static JobDetailsBuilder builder() {
        return new JobDetailsBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JobDetails)) {
            return false;
        }
        JobDetails that = (JobDetails)o;
        return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getCorrelationId(), that.getCorrelationId()) && Objects.equals((Object)this.getStatus(), (Object)that.getStatus()) && (Objects.equals(this.getLastUpdate(), that.getLastUpdate()) || Objects.isNull(this.getLastUpdate()) || Objects.isNull(that.getLastUpdate())) && Objects.equals(this.getRetries(), that.getRetries()) && Objects.equals(this.getExecutionCounter(), that.getExecutionCounter()) && Objects.equals(this.getScheduledId(), that.getScheduledId()) && Objects.equals(this.getRecipient(), that.getRecipient()) && Objects.equals(this.getTrigger().hasNextFireTime(), that.getTrigger().hasNextFireTime()) && Objects.equals(this.getExecutionTimeout(), that.getExecutionTimeout()) && Objects.equals(this.getExecutionTimeoutUnit(), that.getExecutionTimeoutUnit());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getId(), this.getCorrelationId(), this.getStatus(), this.getRetries(), this.getExecutionCounter(), this.getScheduledId(), this.getRecipient(), this.getTrigger(), this.getExecutionTimeout(), this.getExecutionTimeoutUnit()});
    }

    public String toString() {
        return new StringJoiner(", ", JobDetails.class.getSimpleName() + "[", "]").add("id='" + this.id + "'").add("correlationId='" + this.correlationId + "'").add("status=" + this.status).add("lastUpdate=" + this.lastUpdate).add("retries=" + this.retries).add("executionCounter=" + this.executionCounter).add("scheduledId='" + this.scheduledId + "'").add("recipient=" + this.recipient).add("trigger=" + this.trigger).add("executionTimeout=" + this.executionTimeout).add("executionTimeoutUnit=" + this.executionTimeoutUnit).toString();
    }
}

