/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.repository.postgresql;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import java.time.OffsetDateTime;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.jobs.service.model.JobServiceManagementInfo;
import org.kie.kogito.jobs.service.repository.JobServiceManagementRepository;
import org.kie.kogito.jobs.service.utils.DateUtil;
import org.kie.kogito.testcontainers.quarkus.PostgreSqlQuarkusTestResource;

@QuarkusTest
@QuarkusTestResource(value=PostgreSqlQuarkusTestResource.class)
class PostgreSqlJobServiceManagementRepositoryTest {
    @Inject
    JobServiceManagementRepository tested;

    PostgreSqlJobServiceManagementRepositoryTest() {
    }

    @BeforeEach
    void setUp() {
    }

    @Test
    void testGetAndUpdate() {
        String id = "instance-id-1";
        String token = "token1";
        this.create(id, token);
        AtomicReference date = new AtomicReference();
        JobServiceManagementInfo updated = (JobServiceManagementInfo)this.tested.getAndUpdate(id, info -> {
            date.set(DateUtil.now().toOffsetDateTime());
            info.setLastHeartbeat((OffsetDateTime)date.get());
            return info;
        }).await().indefinitely();
        Assertions.assertThat((String)updated.getId()).isEqualTo(id);
        Assertions.assertThat((OffsetDateTime)((OffsetDateTime)date.get())).isNotNull();
        Assertions.assertThat((OffsetDateTime)updated.getLastHeartbeat()).isEqualTo(date.get());
        Assertions.assertThat((String)updated.getToken()).isEqualTo(token);
    }

    @Test
    void testGetAndUpdateNotExisting() {
        String id = "instance-id-2";
        AtomicReference<JobServiceManagementInfo> found = new AtomicReference<JobServiceManagementInfo>(new JobServiceManagementInfo());
        JobServiceManagementInfo updated = (JobServiceManagementInfo)this.tested.getAndUpdate(id, info -> {
            found.set((JobServiceManagementInfo)info);
            return info;
        }).await().indefinitely();
        Assertions.assertThat((Object)updated).isNull();
        Assertions.assertThat((Object)found.get()).isNull();
    }

    private JobServiceManagementInfo create(String id, String token) {
        JobServiceManagementInfo created = (JobServiceManagementInfo)this.tested.set(new JobServiceManagementInfo(id, token, null)).await().indefinitely();
        Assertions.assertThat((String)created.getId()).isEqualTo(id);
        Assertions.assertThat((String)created.getToken()).isEqualTo(token);
        Assertions.assertThat((OffsetDateTime)created.getLastHeartbeat()).isNull();
        return created;
    }

    @Test
    void testHeartbeat() {
        String id = "instance-id-3";
        String token = "token3";
        JobServiceManagementInfo created = this.create(id, token);
        JobServiceManagementInfo updated = (JobServiceManagementInfo)this.tested.heartbeat(created).await().indefinitely();
        Assertions.assertThat((OffsetDateTime)updated.getLastHeartbeat()).isNotNull();
        Assertions.assertThat((OffsetDateTime)updated.getLastHeartbeat()).isBefore(DateUtil.now().plusSeconds(1L).toOffsetDateTime());
    }

    @Test
    void testConflictHeartbeat() {
        String id = "instance-id-4";
        String token = "token4";
        this.create(id, token);
        JobServiceManagementInfo updated = (JobServiceManagementInfo)this.tested.heartbeat(new JobServiceManagementInfo(id, "differentToken", null)).await().indefinitely();
        Assertions.assertThat((Object)updated).isNull();
    }
}

