/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.management;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.jobs.ExactExpirationTime;
import org.kie.kogito.jobs.ExpirationTime;
import org.kie.kogito.jobs.ProcessInstanceJobDescription;
import org.kie.kogito.jobs.ProcessJobDescription;
import org.kie.kogito.jobs.management.RestJobsService;
import org.kie.kogito.jobs.service.api.Job;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipient;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipientJsonPayloadData;
import org.kie.kogito.jobs.service.api.schedule.timer.TimerSchedule;

public abstract class RestJobsServiceTest<T extends RestJobsService> {
    public static final String CALLBACK_URL = "http://localhost:8080";
    public static final String JOB_SERVICE_URL = "http://localhost:8085";
    public static final String JOB_ID = "456";
    public static final String TIMER_ID = "123";
    public static final String PROCESS_ID = "PROCESS_ID";
    public static final String PROCESS_INSTANCE_ID = "PROCESS_INSTANCE_ID";
    public static final String ROOT_PROCESS_ID = "ROOT_PROCESS_ID";
    public static final String ROOT_PROCESS_INSTANCE_ID = "ROOT_PROCESS_INSTANCE_ID";
    public static final String NODE_INSTANCE_ID = "NODE_INSTANCE_ID";
    public static final ZonedDateTime EXPIRATION_TIME = ZonedDateTime.parse("2023-01-13T10:20:30.000001+01:00[Europe/Madrid]");
    protected T tested;

    @BeforeEach
    void setUp() {
        this.tested = this.createJobService(JOB_SERVICE_URL, CALLBACK_URL);
    }

    public abstract T createJobService(String var1, String var2);

    @Test
    void testGetCallbackEndpoint() {
        ProcessInstanceJobDescription description = ProcessInstanceJobDescription.builder().id(JOB_ID).timerId(TIMER_ID).expirationTime((ExpirationTime)ExactExpirationTime.now()).processInstanceId(PROCESS_INSTANCE_ID).processId(PROCESS_ID).build();
        String callbackEndpoint = this.tested.getCallbackEndpoint(description);
        Assertions.assertThat((String)callbackEndpoint).isEqualTo("%s/management/jobs/%s/instances/%s/timers/%s", new Object[]{CALLBACK_URL, PROCESS_ID, PROCESS_INSTANCE_ID, description.timerId()});
    }

    @Test
    void testGetJobsServiceUri() {
        URI jobsServiceUri = this.tested.getJobsServiceUri();
        Assertions.assertThat((URI)jobsServiceUri).hasToString("http://localhost:8085/v2/jobs");
    }

    @Test
    void testScheduleProcessJob() {
        ProcessJobDescription processJobDescription = ProcessJobDescription.of((ExpirationTime)ExactExpirationTime.of((ZonedDateTime)EXPIRATION_TIME), (Integer)1, (String)PROCESS_ID);
        Assertions.assertThatThrownBy(() -> this.tested.scheduleProcessJob(processJobDescription)).isInstanceOf(UnsupportedOperationException.class);
    }

    protected ProcessInstanceJobDescription buildProcessInstanceJobDescription() {
        return ProcessInstanceJobDescription.builder().id(JOB_ID).timerId(TIMER_ID).expirationTime((ExpirationTime)ExactExpirationTime.of((ZonedDateTime)EXPIRATION_TIME)).processInstanceId(PROCESS_INSTANCE_ID).rootProcessInstanceId(ROOT_PROCESS_INSTANCE_ID).processId(PROCESS_ID).rootProcessId(ROOT_PROCESS_ID).nodeInstanceId(NODE_INSTANCE_ID).build();
    }

    protected void assertExpectedJob(Job job, String expectedJobId) {
        Assertions.assertThat((Object)job).isNotNull();
        Assertions.assertThat((String)job.getId()).isEqualTo(expectedJobId);
        ((ObjectAssert)Assertions.assertThat((Object)job.getRecipient()).isNotNull()).isInstanceOf(HttpRecipient.class);
        HttpRecipient httpRecipient = (HttpRecipient)job.getRecipient();
        Assertions.assertThat((String)httpRecipient.getMethod()).isEqualTo("POST");
        Assertions.assertThat((String)httpRecipient.getUrl()).isEqualTo("%s/management/jobs/%s/instances/%s/timers/%s", new Object[]{CALLBACK_URL, PROCESS_ID, PROCESS_INSTANCE_ID, TIMER_ID});
        ((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)httpRecipient.getHeaders()).hasSize(6)).containsEntry((Object)"processId", (Object)PROCESS_ID)).containsEntry((Object)"processInstanceId", (Object)PROCESS_INSTANCE_ID)).containsEntry((Object)"rootProcessId", (Object)ROOT_PROCESS_ID)).containsEntry((Object)"rootProcessInstanceId", (Object)ROOT_PROCESS_INSTANCE_ID)).containsEntry((Object)"nodeInstanceId", (Object)NODE_INSTANCE_ID)).containsEntry((Object)"Content-Type", (Object)"application/json");
        Assertions.assertThat((Object)httpRecipient.getPayload()).isNotNull();
        Assertions.assertThat((Object)httpRecipient.getPayload()).isInstanceOf(HttpRecipientJsonPayloadData.class);
        JsonNode data = ((HttpRecipientJsonPayloadData)httpRecipient.getPayload()).getData();
        ((IterableAssert)Assertions.assertThat((Iterable)data).isNotNull()).hasSize(1);
        Assertions.assertThat((String)data.get("correlationId").asText()).isEqualTo(JOB_ID);
        ((ObjectAssert)Assertions.assertThat((Object)job.getSchedule()).isNotNull()).isInstanceOf(TimerSchedule.class);
        TimerSchedule timerSchedule = (TimerSchedule)job.getSchedule();
        Assertions.assertThat((OffsetDateTime)timerSchedule.getStartTime()).isEqualTo((Object)EXPIRATION_TIME.toOffsetDateTime().truncatedTo(ChronoUnit.MILLIS));
    }
}

