/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.infinispan;

import java.util.Collections;
import java.util.Date;
import org.assertj.core.api.Assertions;
import org.drools.io.ClassPathResource;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.api.io.Resource;
import org.kie.kogito.infinispan.AbstractProcessInstancesFactory;
import org.kie.kogito.infinispan.CacheProcessInstances;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstancesFactory;
import org.kie.kogito.process.bpmn2.BpmnProcess;
import org.kie.kogito.process.bpmn2.BpmnVariables;
import org.kie.kogito.process.impl.AbstractProcessInstance;
import org.kie.kogito.testcontainers.KogitoInfinispanContainer;
import org.mockito.Mockito;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
class CacheProcessInstancesWithLockIT {
    private static final String TEST_ID = "02ac3854-46ee-42b7-8b63-5186c9889d96";
    @Container
    public KogitoInfinispanContainer container = new KogitoInfinispanContainer();
    private RemoteCacheManager cacheManager;

    CacheProcessInstancesWithLockIT() {
    }

    @BeforeEach
    void setup() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host("127.0.0.1").port(this.container.getMappedPort());
        this.cacheManager = new RemoteCacheManager(builder.build());
    }

    @AfterEach
    void close() {
        if (this.cacheManager != null) {
            this.cacheManager.close();
        }
    }

    private BpmnProcess createProcess(String fileName) {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource(fileName)}).get(0);
        AbstractProcessInstancesFactory factory = (AbstractProcessInstancesFactory)Mockito.mock(AbstractProcessInstancesFactory.class);
        process.setProcessInstancesFactory((ProcessInstancesFactory)factory);
        process.configure();
        return process;
    }

    @Test
    public void testBasic() {
        BpmnProcess process = this.createProcess("BPMN2-UserTask.bpmn2");
        CacheProcessInstances pi = new CacheProcessInstances((Process)process, this.cacheManager, null, true);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)pi);
        WorkflowProcessInstance createPi = ((AbstractProcessInstance)process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")))).internalGetProcessInstance();
        createPi.setId(TEST_ID);
        createPi.setStartDate(new Date());
        AbstractProcessInstance mockCreatePi = (AbstractProcessInstance)Mockito.mock(AbstractProcessInstance.class);
        mockCreatePi.setVersion(1L);
        Mockito.when((Object)mockCreatePi.status()).thenReturn((Object)1);
        Mockito.when((Object)mockCreatePi.internalGetProcessInstance()).thenReturn((Object)createPi);
        Mockito.when((Object)mockCreatePi.id()).thenReturn((Object)TEST_ID);
        pi.create(TEST_ID, (ProcessInstance)mockCreatePi);
        Assertions.assertThat((Integer)pi.size()).isOne();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pi.exists(TEST_ID));
        WorkflowProcessInstance updatePi = ((AbstractProcessInstance)process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")))).internalGetProcessInstance();
        updatePi.setId(TEST_ID);
        updatePi.setStartDate(new Date());
        AbstractProcessInstance mockUpdatePi = (AbstractProcessInstance)Mockito.mock(AbstractProcessInstance.class);
        Mockito.when((Object)mockUpdatePi.status()).thenReturn((Object)1);
        Mockito.when((Object)mockUpdatePi.internalGetProcessInstance()).thenReturn((Object)updatePi);
        Mockito.when((Object)mockUpdatePi.id()).thenReturn((Object)TEST_ID);
        try {
            pi.update(TEST_ID, (ProcessInstance)mockUpdatePi);
            org.junit.jupiter.api.Assertions.fail((String)"Updating process should have failed");
        }
        catch (RuntimeException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo("Process instance with id '02ac3854-46ee-42b7-8b63-5186c9889d96' updated or deleted by other request");
        }
        pi.remove(TEST_ID);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)pi.exists(TEST_ID));
    }
}

